/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class ETCOID3V2Frame
extends ID3V2Frame {
    private TimestampFormat m_oTimestampFormat;
    private SortedMap m_oTimeToEventMap = null;

    public ETCOID3V2Frame(TimestampFormat oTimestampFormat) throws ID3Exception {
        if (oTimestampFormat == null) {
            throw new ID3Exception("Timestamp format required in ETCO frame.");
        }
        this.m_oTimestampFormat = oTimestampFormat;
        this.m_oTimeToEventMap = new TreeMap();
    }

    public ETCOID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_oTimestampFormat = new TimestampFormat((byte)oFrameDataID3DIS.readUnsignedByte());
            this.m_oTimeToEventMap = new TreeMap();
            while (oFrameDataID3DIS.available() > 0) {
                byte byTypeOfEvent = (byte)oFrameDataID3DIS.readUnsignedByte();
                EventType oEventType = new EventType(byTypeOfEvent);
                int iTimestamp = oFrameDataID3DIS.readBE32();
                this.addEvent(new Event(oEventType, iTimestamp));
            }
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitETCOID3V2Frame(this);
    }

    public TimestampFormat getTimestampFormat() {
        return this.m_oTimestampFormat;
    }

    public void addEvent(Event oEvent) {
        this.m_oTimeToEventMap.put(new Integer(oEvent.getTimestamp()), oEvent);
    }

    public Event getEvent(int iTimestamp) throws ID3Exception {
        if (iTimestamp < 0) {
            throw new ID3Exception("Negative timestamps are not valid in ETCO frames.");
        }
        return (Event)this.m_oTimeToEventMap.get(new Integer(iTimestamp));
    }

    public Event[] getEvents() {
        return this.m_oTimeToEventMap.values().toArray(new Event[0]);
    }

    public Event removeEvent(Event oEvent) {
        return (Event)this.m_oTimeToEventMap.remove(new Integer(oEvent.getTimestamp()));
    }

    protected byte[] getFrameId() {
        return "ETCO".getBytes();
    }

    public String toString() {
        StringBuffer sbOutput = new StringBuffer();
        sbOutput.append("Event Timing Codes: Timestamp format = " + this.m_oTimestampFormat.getValue());
        sbOutput.append(", Events = ");
        Iterator oIter = this.m_oTimeToEventMap.values().iterator();
        while (oIter.hasNext()) {
            Event oEvent = (Event)oIter.next();
            sbOutput.append(oEvent.getEventType().getValue() + ":" + oEvent.getTimestamp() + " ");
        }
        return sbOutput.toString();
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.writeUnsignedByte(this.m_oTimestampFormat.getValue());
        Iterator oIter = this.m_oTimeToEventMap.values().iterator();
        while (oIter.hasNext()) {
            Event oEvent = (Event)oIter.next();
            oIDOS.writeUnsignedByte(oEvent.getEventType().getValue());
            oIDOS.writeBE32(oEvent.getTimestamp());
        }
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof ETCOID3V2Frame)) {
            return false;
        }
        ETCOID3V2Frame oOtherETCO = (ETCOID3V2Frame)oOther;
        return this.m_oTimestampFormat.equals(oOtherETCO.m_oTimestampFormat) && this.m_oTimeToEventMap.equals(oOtherETCO.m_oTimeToEventMap);
    }

    public static class Event {
        private EventType m_oEventType;
        private int m_iTimestamp;

        public Event(EventType oEventType, int iTimestamp) throws ID3Exception {
            if (iTimestamp < 0) {
                throw new ID3Exception("Negative timestamps are not valid in ETCO frames.");
            }
            this.m_oEventType = oEventType;
            this.m_iTimestamp = iTimestamp;
        }

        public EventType getEventType() {
            return this.m_oEventType;
        }

        public int getTimestamp() {
            return this.m_iTimestamp;
        }

        public boolean equals(Object oOther) {
            try {
                Event oOtherEvent = (Event)oOther;
                return this.m_iTimestamp == oOtherEvent.m_iTimestamp && this.m_oEventType.equals(oOtherEvent.m_oEventType);
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class EventType {
        private byte m_byTypeOfEvent;
        public static final EventType PADDING = new EventType(0);
        public static final EventType END_OF_INITIAL_SILENCE = new EventType(1);
        public static final EventType INTRO_START = new EventType(2);
        public static final EventType MAINPART_START = new EventType(3);
        public static final EventType OUTRO_START = new EventType(4);
        public static final EventType OUTRO_END = new EventType(5);
        public static final EventType VERSE_START = new EventType(6);
        public static final EventType REFRAIN_START = new EventType(7);
        public static final EventType INTERLUDE_START = new EventType(8);
        public static final EventType THEME_START = new EventType(9);
        public static final EventType VARIATION_START = new EventType(10);
        public static final EventType KEY_CHANGE = new EventType(11);
        public static final EventType TIME_CHANGE = new EventType(12);
        public static final EventType MOMENTARY_UNWANTED_NOISE = new EventType(13);
        public static final EventType SUSTAINED_NOISE = new EventType(14);
        public static final EventType SUSTAINED_NOISE_END = new EventType(15);
        public static final EventType INTRO_END = new EventType(16);
        public static final EventType MAINPART_END = new EventType(17);
        public static final EventType VERSE_END = new EventType(18);
        public static final EventType REFRAIN_END = new EventType(19);
        public static final EventType THEME_END = new EventType(20);
        public static final EventType USER_DEFINED_01 = new EventType(-32);
        public static final EventType USER_DEFINED_02 = new EventType(-31);
        public static final EventType USER_DEFINED_03 = new EventType(-30);
        public static final EventType USER_DEFINED_04 = new EventType(-29);
        public static final EventType USER_DEFINED_05 = new EventType(-28);
        public static final EventType USER_DEFINED_06 = new EventType(-27);
        public static final EventType USER_DEFINED_07 = new EventType(-26);
        public static final EventType USER_DEFINED_08 = new EventType(-25);
        public static final EventType USER_DEFINED_09 = new EventType(-24);
        public static final EventType USER_DEFINED_10 = new EventType(-23);
        public static final EventType USER_DEFINED_11 = new EventType(-22);
        public static final EventType USER_DEFINED_12 = new EventType(-21);
        public static final EventType USER_DEFINED_13 = new EventType(-20);
        public static final EventType USER_DEFINED_14 = new EventType(-19);
        public static final EventType USER_DEFINED_15 = new EventType(-18);
        public static final EventType USER_DEFINED_16 = new EventType(-17);
        public static final EventType AUDIO_END = new EventType(-3);
        public static final EventType AUDIO_FILE_ENDS = new EventType(-2);

        private EventType(byte byTypeOfEvent) {
            this.m_byTypeOfEvent = byTypeOfEvent;
        }

        private byte getValue() {
            return this.m_byTypeOfEvent;
        }

        public boolean equals(Object oOther) {
            try {
                EventType oOtherET = (EventType)oOther;
                return this.m_byTypeOfEvent == oOtherET.m_byTypeOfEvent;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static class TimestampFormat {
        private byte m_byTimestampFormat;
        public static final TimestampFormat ABSOLUTE_MPEG_FRAMES = new TimestampFormat(1);
        public static final TimestampFormat ABSOLUTE_MILLISECONDS = new TimestampFormat(2);

        private TimestampFormat(byte byTimestampFormat) {
            this.m_byTimestampFormat = byTimestampFormat;
        }

        private byte getValue() {
            return this.m_byTimestampFormat;
        }

        public boolean equals(Object oOther) {
            try {
                TimestampFormat oOtherTF = (TimestampFormat)oOther;
                return this.m_byTimestampFormat == oOtherTF.m_byTimestampFormat;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

