/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class EQUAID3V2Frame
extends ID3V2Frame {
    private byte m_byAdjustmentBits;
    private Map m_oFrequencyToAdjustmentMap = null;

    public EQUAID3V2Frame(byte byAdjustmentBits) {
        this.m_byAdjustmentBits = byAdjustmentBits;
        this.m_oFrequencyToAdjustmentMap = new HashMap();
    }

    public EQUAID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            this.m_byAdjustmentBits = (byte)oFrameDataID3DIS.readUnsignedByte();
            this.m_oFrequencyToAdjustmentMap = new HashMap();
            while (oFrameDataID3DIS.available() > 0) {
                int iIncrementAndFrequency = oFrameDataID3DIS.readBEUnsigned16();
                boolean bIncrement = (iIncrementAndFrequency & 0x8000) > 0;
                int iFrequency = iIncrementAndFrequency & Short.MAX_VALUE;
                byte[] abyAdjustment = new byte[this.m_byAdjustmentBits / 8];
                oFrameDataID3DIS.readFully(abyAdjustment);
                Adjustment oAdjustment = new Adjustment(bIncrement, iFrequency, abyAdjustment);
                this.m_oFrequencyToAdjustmentMap.put(new Integer(iFrequency), oAdjustment);
            }
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitEQUAID3V2Frame(this);
    }

    public void setAdjustmentBits(byte byAdjustmentBits) {
        this.m_byAdjustmentBits = byAdjustmentBits;
    }

    public byte getAdjustmentBits() {
        return this.m_byAdjustmentBits;
    }

    public void setAdjustment(Adjustment oAdjustment) {
        this.m_oFrequencyToAdjustmentMap.put(new Integer(oAdjustment.getFrequency()), oAdjustment);
    }

    public Adjustment getAdjustment(int iFrequency) throws ID3Exception {
        if (iFrequency < 0 || iFrequency > Short.MAX_VALUE) {
            throw new ID3Exception("Valid frequency range for EQUA adjustments is from 0-32767Hz.");
        }
        return (Adjustment)this.m_oFrequencyToAdjustmentMap.get(new Integer(iFrequency));
    }

    public Adjustment removeAdjustment(int iFrequency) throws ID3Exception {
        if (iFrequency < 0 || iFrequency > Short.MAX_VALUE) {
            throw new ID3Exception("Valid frequency range for EQUA adjustments is from 0-32767Hz.");
        }
        return (Adjustment)this.m_oFrequencyToAdjustmentMap.remove(new Integer(iFrequency));
    }

    public Adjustment[] getAdjustments() {
        return this.m_oFrequencyToAdjustmentMap.values().toArray(new Adjustment[0]);
    }

    protected byte[] getFrameId() {
        return "EQUA".getBytes();
    }

    public String toString() {
        return "Equalization: Adjustment Bits = " + this.m_byAdjustmentBits;
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.writeUnsignedByte(this.m_byAdjustmentBits);
        Adjustment[] aoAdjustment = this.getAdjustments();
        for (int i = 0; i < aoAdjustment.length; ++i) {
            aoAdjustment[i].write(oIDOS);
        }
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof EQUAID3V2Frame)) {
            return false;
        }
        EQUAID3V2Frame oOtherEQUA = (EQUAID3V2Frame)oOther;
        return this.m_byAdjustmentBits == oOtherEQUA.m_byAdjustmentBits && ((Object)this.m_oFrequencyToAdjustmentMap).equals(oOtherEQUA.m_oFrequencyToAdjustmentMap);
    }

    public class Adjustment {
        private boolean m_bIncrement;
        private int m_iFrequency;
        private byte[] m_abyAdjustment;

        public Adjustment(boolean bIncrement, int iFrequency, byte[] abyAdjustment) throws ID3Exception {
            this.m_bIncrement = bIncrement;
            if (iFrequency < 0 || iFrequency > Short.MAX_VALUE) {
                throw new ID3Exception("The valid frequency range for EQUA frame is from 0 to 32767Hz.");
            }
            this.m_iFrequency = iFrequency;
            if (abyAdjustment == null || abyAdjustment.length == 0) {
                throw new ID3Exception("Adjustment bytes must be specified for EQUA frame.");
            }
            this.m_abyAdjustment = abyAdjustment;
        }

        public boolean isIncrement() {
            return this.m_bIncrement;
        }

        public boolean isDecrement() {
            return !this.m_bIncrement;
        }

        public int getFrequency() {
            return this.m_iFrequency;
        }

        public byte[] getAdjustment() {
            return this.m_abyAdjustment;
        }

        private void write(ID3DataOutputStream oIDOS) throws IOException {
            int iIncrementAndFrequency = this.m_iFrequency;
            if (this.m_bIncrement) {
                iIncrementAndFrequency |= 0x8000;
            }
            oIDOS.writeBEUnsigned16(iIncrementAndFrequency);
            oIDOS.write(this.m_abyAdjustment);
        }

        public boolean equals(Object oOther) {
            if (oOther == null || !(oOther instanceof Adjustment)) {
                return false;
            }
            Adjustment oOtherAdjustment = (Adjustment)oOther;
            return this.m_bIncrement == oOtherAdjustment.m_bIncrement && this.m_iFrequency == oOtherAdjustment.m_iFrequency && Arrays.equals(this.m_abyAdjustment, oOtherAdjustment.m_abyAdjustment);
        }
    }
}

