/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.v2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.blinkenlights.jid3.ID3Exception;
import org.blinkenlights.jid3.InvalidFrameID3Exception;
import org.blinkenlights.jid3.io.ID3DataInputStream;
import org.blinkenlights.jid3.io.ID3DataOutputStream;
import org.blinkenlights.jid3.util.ID3Visitor;
import org.blinkenlights.jid3.v2.ID3V2Frame;

public class ENCRID3V2Frame
extends ID3V2Frame {
    private String m_sOwnerIdentifier = null;
    private byte m_byMethodSymbol;
    private byte[] m_abyEncryptionData = null;

    public ENCRID3V2Frame(String sOwnerIdentifier, byte byMethodSymbol, byte[] abyEncryptionData) throws ID3Exception {
        if (sOwnerIdentifier == null) {
            throw new ID3Exception("ENCR frame requires owner identifier string.");
        }
        this.m_sOwnerIdentifier = sOwnerIdentifier;
        if ((byMethodSymbol & 0xFF) < 128) {
            throw new ID3Exception("Encryption method symbols below 0x80 are reserved.");
        }
        this.m_byMethodSymbol = byMethodSymbol;
        this.m_abyEncryptionData = abyEncryptionData;
        if (this.m_abyEncryptionData == null) {
            this.m_abyEncryptionData = new byte[0];
        }
    }

    public ENCRID3V2Frame(InputStream oIS) throws ID3Exception {
        try {
            int iOwnerIdentifierByte;
            ID3DataInputStream oFrameDataID3DIS = new ID3DataInputStream(oIS);
            ByteArrayOutputStream oOwnerIdentifierBAOS = new ByteArrayOutputStream();
            do {
                if ((iOwnerIdentifierByte = oFrameDataID3DIS.readUnsignedByte()) == 0) continue;
                oOwnerIdentifierBAOS.write(iOwnerIdentifierByte);
            } while (iOwnerIdentifierByte != 0);
            if (oOwnerIdentifierBAOS.size() > 0) {
                byte[] abyOwnerIdentifier = oOwnerIdentifierBAOS.toByteArray();
                this.m_sOwnerIdentifier = new String(abyOwnerIdentifier);
            } else {
                this.m_sOwnerIdentifier = "";
            }
            this.m_byMethodSymbol = (byte)oFrameDataID3DIS.readUnsignedByte();
            this.m_abyEncryptionData = new byte[oFrameDataID3DIS.available()];
            oFrameDataID3DIS.readFully(this.m_abyEncryptionData);
        }
        catch (Exception e) {
            throw new InvalidFrameID3Exception(e);
        }
    }

    public void accept(ID3Visitor oID3Visitor) {
        oID3Visitor.visitENCRID3V2Frame(this);
    }

    public void setEncryptionDetails(String sOwnerIdentifier, byte byMethodSymbol, byte[] abyEncryptionData) throws ID3Exception {
        String sOrigOwnerIdentifier = this.m_sOwnerIdentifier;
        byte byOrigMethodSymbol = this.m_byMethodSymbol;
        byte[] abyOrigEncryptionData = this.m_abyEncryptionData;
        if (sOwnerIdentifier == null) {
            throw new ID3Exception("ENCR frame requires owner identifier string.");
        }
        if ((byMethodSymbol & 0xFF) < 128) {
            throw new ID3Exception("Encryption method symbols below 0x80 are reserved.");
        }
        this.m_sOwnerIdentifier = sOwnerIdentifier;
        this.m_byMethodSymbol = byMethodSymbol;
        this.m_abyEncryptionData = abyEncryptionData;
        try {
            this.notifyID3Observers();
        }
        catch (ID3Exception e) {
            this.m_sOwnerIdentifier = sOrigOwnerIdentifier;
            this.m_byMethodSymbol = byOrigMethodSymbol;
            this.m_abyEncryptionData = abyOrigEncryptionData;
            throw e;
        }
    }

    public String getOwnerIdentifier() {
        return this.m_sOwnerIdentifier;
    }

    public byte getEncryptionMethodSymbol() {
        return this.m_byMethodSymbol;
    }

    public byte[] getEncryptionData() {
        return this.m_abyEncryptionData;
    }

    protected byte[] getFrameId() {
        return "ENCR".getBytes();
    }

    public String toString() {
        return "Encryption Method Registration: Owner identifier=[" + this.m_sOwnerIdentifier + "], Method Symbol=[" + this.m_byMethodSymbol + "]";
    }

    protected void writeBody(ID3DataOutputStream oIDOS) throws IOException {
        oIDOS.write(this.m_sOwnerIdentifier.getBytes());
        oIDOS.writeUnsignedByte(0);
        oIDOS.writeUnsignedByte(this.m_byMethodSymbol);
        if (this.m_abyEncryptionData != null) {
            oIDOS.write(this.m_abyEncryptionData);
        }
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof ENCRID3V2Frame)) {
            return false;
        }
        ENCRID3V2Frame oOtherENCR = (ENCRID3V2Frame)oOther;
        return this.m_sOwnerIdentifier.equals(oOtherENCR.m_sOwnerIdentifier) && this.m_byMethodSymbol == oOtherENCR.m_byMethodSymbol && Arrays.equals(this.m_abyEncryptionData, oOtherENCR.m_abyEncryptionData);
    }
}

