/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import junit.framework.TestCase;
import junit.swingui.TestRunner;
import org.blinkenlights.jid3.ID3Tag;
import org.blinkenlights.jid3.MP3File;
import org.blinkenlights.jid3.MediaFile;
import org.blinkenlights.jid3.test.AllTests;
import org.blinkenlights.jid3.util.ID3Util;
import org.blinkenlights.jid3.v1.ID3V1Tag;
import org.blinkenlights.jid3.v1.ID3V1_0Tag;
import org.blinkenlights.jid3.v1.ID3V1_1Tag;

public class ID3V1Test
extends TestCase {
    public ID3V1Test(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)ID3V1Test.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReadV1_0Tag() {
        try {
            ID3V1_0Tag oID3V1_0Tag;
            File oSourceFile = new File(AllTests.s_RootPath + "v1_0tags.mp3");
            MP3File oMediaFile = new MP3File(oSourceFile);
            ID3Tag[] aoID3Tag = ((MediaFile)oMediaFile).getTags();
            System.out.println("\n*** v1_0tags.mp3 tags:");
            ID3Util.printTags(aoID3Tag);
            if (aoID3Tag.length != 1) {
                ID3V1Test.fail((String)"There should be exactly one set of tags in this file.");
            }
            if (!(aoID3Tag[0] instanceof ID3V1_0Tag)) {
                ID3V1Test.fail((String)"Expected ID3V1_0Tag.");
            }
            if (!((oID3V1_0Tag = (ID3V1_0Tag)aoID3Tag[0]).getTitle().equals("Title") && oID3V1_0Tag.getArtist().equals("Artist") && oID3V1_0Tag.getAlbum().equals("Album") && oID3V1_0Tag.getYear().equals("1999") && oID3V1_0Tag.getComment().equals("Comment") && oID3V1_0Tag.getGenre().equals(ID3V1Tag.Genre.Nullsoft_BlackMetal))) {
                ID3V1Test.fail((String)"Unexpected tag value found.");
            }
        }
        catch (Exception e) {
            ID3V1Test.fail((String)e.toString());
        }
    }

    public void testWriteV1_0Tag() {
        try {
            ID3V1Test.copy(AllTests.s_RootPath + "notags.mp3", AllTests.s_RootPath + "id3_v1_0_testresult.mp3");
            File oSourceFile = new File(AllTests.s_RootPath + "id3_v1_0_testresult.mp3");
            MP3File oMediaFile = new MP3File(oSourceFile);
            ID3V1_0Tag oID3V1_0Tag = new ID3V1_0Tag();
            oID3V1_0Tag.setAlbum("Album");
            oID3V1_0Tag.setArtist("Artist");
            oID3V1_0Tag.setComment("Comment");
            oID3V1_0Tag.setGenre(ID3V1Tag.Genre.Nullsoft_BlackMetal);
            oID3V1_0Tag.setTitle("Title");
            oID3V1_0Tag.setYear("1999");
            System.out.println(oID3V1_0Tag.toString());
            oMediaFile.setID3Tag(oID3V1_0Tag);
            ((MediaFile)oMediaFile).sync();
            ID3V1Test.compare(AllTests.s_RootPath + "v1_0tags.mp3", AllTests.s_RootPath + "id3_v1_0_testresult.mp3");
        }
        catch (Exception e) {
            ID3V1Test.fail((String)e.toString());
        }
    }

    public void testReadV1_1Tag() {
        try {
            ID3V1_1Tag oID3V1_1Tag;
            File oSourceFile = new File(AllTests.s_RootPath + "v1_1tags.mp3");
            MP3File oMediaFile = new MP3File(oSourceFile);
            ID3Tag[] aoID3Tag = ((MediaFile)oMediaFile).getTags();
            System.out.println("\n*** v1_1tags.mp3 tags:");
            ID3Util.printTags(aoID3Tag);
            if (aoID3Tag.length != 1) {
                ID3V1Test.fail((String)"There should be exactly one set of tags in this file.");
            }
            if (!(aoID3Tag[0] instanceof ID3V1_1Tag)) {
                ID3V1Test.fail((String)"Expected ID3V1_1Tag.");
            }
            if (!((oID3V1_1Tag = (ID3V1_1Tag)aoID3Tag[0]).getTitle().equals("Title") && oID3V1_1Tag.getArtist().equals("Artist") && oID3V1_1Tag.getAlbum().equals("Album") && oID3V1_1Tag.getYear().equals("1999") && oID3V1_1Tag.getComment().equals("Comment") && oID3V1_1Tag.getGenre().equals(ID3V1Tag.Genre.Nullsoft_BlackMetal) && oID3V1_1Tag.getAlbumTrack() == 7 && oID3V1_1Tag.getGenre().getByteValue() == 138)) {
                ID3V1Test.fail((String)"Unexpected tag value found.");
            }
        }
        catch (Exception e) {
            ID3V1Test.fail((String)e.toString());
        }
    }

    public void testWriteV1_1Tag() {
        try {
            ID3V1Test.copy(AllTests.s_RootPath + "notags.mp3", AllTests.s_RootPath + "id3_v1_1_testresult.mp3");
            File oSourceFile = new File(AllTests.s_RootPath + "id3_v1_1_testresult.mp3");
            MP3File oMediaFile = new MP3File(oSourceFile);
            ID3V1_1Tag oID3V1_1Tag = new ID3V1_1Tag();
            oID3V1_1Tag.setAlbum("Album");
            oID3V1_1Tag.setArtist("Artist");
            oID3V1_1Tag.setComment("Comment");
            oID3V1_1Tag.setGenre(ID3V1Tag.Genre.Nullsoft_BlackMetal);
            oID3V1_1Tag.setTitle("Title");
            oID3V1_1Tag.setYear("1999");
            oID3V1_1Tag.setAlbumTrack(7);
            System.out.println(oID3V1_1Tag.toString());
            oMediaFile.setID3Tag(oID3V1_1Tag);
            ((MediaFile)oMediaFile).sync();
            ID3V1Test.compare(AllTests.s_RootPath + "v1_1tags.mp3", AllTests.s_RootPath + "id3_v1_1_testresult.mp3");
        }
        catch (Exception e) {
            ID3V1Test.fail((String)e.toString());
        }
    }

    private static void copy(String sSource, String sDestination) throws Exception {
        int c;
        File oInputFile = new File(sSource);
        File oOutputFile = new File(sDestination);
        FileInputStream oFIS = new FileInputStream(oInputFile);
        FileOutputStream oFOS = new FileOutputStream(oOutputFile);
        while ((c = oFIS.read()) != -1) {
            oFOS.write(c);
        }
        oFIS.close();
        oFOS.close();
    }

    private static void compare(String sFileOne, String sFileTwo) throws Exception {
        int c;
        File oOneFile = new File(sFileOne);
        File oTwoFile = new File(sFileTwo);
        if (oOneFile.length() != oTwoFile.length()) {
            throw new Exception("File lengths differ.");
        }
        FileInputStream oFIS1 = new FileInputStream(oOneFile);
        FileInputStream oFIS2 = new FileInputStream(oTwoFile);
        int i = 0;
        while ((c = oFIS1.read()) != -1) {
            if (oFIS2.read() != c) {
                throw new Exception("File contents differ at position " + i + ".");
            }
            ++i;
        }
        oFIS1.close();
        oFIS2.close();
    }
}

