/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.blinkenlights.jid3.ID3Tag;
import org.blinkenlights.jid3.MP3File;
import org.blinkenlights.jid3.MediaFile;
import org.blinkenlights.jid3.test.AllTests;
import org.blinkenlights.jid3.v1.ID3V1Tag;
import org.blinkenlights.jid3.v1.ID3V1_0Tag;
import org.blinkenlights.jid3.v1.ID3V1_1Tag;
import org.blinkenlights.jid3.v2.ID3V2_3_0Tag;

public class ID3Test {
    public static void main(String[] args) throws Exception {
        ID3Test.testWriteV1_0Tag();
        ID3Test.testWriteV1_1Tag();
        ID3Test.testReadV1_0Tag();
        ID3Test.testReadV1_1Tag();
    }

    static void testWriteV1_0Tag() throws Exception {
        System.out.println("\n--- testWriteV1_0Tag ---");
        ID3Test.copy(AllTests.s_RootPath + "notags.mp3", AllTests.s_RootPath + "id3_v1_0_testresult.mp3");
        File oSourceFile = new File(AllTests.s_RootPath + "id3_v1_0_testresult.mp3");
        MP3File oMediaFile = new MP3File(oSourceFile);
        ID3V1_0Tag oID3V1_0Tag = new ID3V1_0Tag();
        oID3V1_0Tag.setAlbum("Album");
        oID3V1_0Tag.setArtist("Artist");
        oID3V1_0Tag.setComment("Comment");
        oID3V1_0Tag.setGenre(ID3V1Tag.Genre.Dance);
        oID3V1_0Tag.setTitle("Title");
        oID3V1_0Tag.setYear("1999");
        System.out.println(oID3V1_0Tag.toString());
        oMediaFile.setID3Tag(oID3V1_0Tag);
        ((MediaFile)oMediaFile).sync();
    }

    static void testWriteV1_1Tag() throws Exception {
        System.out.println("\n--- testWriteV1_1Tag ---");
        ID3Test.copy(AllTests.s_RootPath + "notags.mp3", AllTests.s_RootPath + "id3_v1_1_testresult.mp3");
        File oSourceFile = new File(AllTests.s_RootPath + "id3_v1_1_testresult.mp3");
        MP3File oMediaFile = new MP3File(oSourceFile);
        ID3V1_1Tag oID3V1_1Tag = new ID3V1_1Tag();
        oID3V1_1Tag.setAlbum("Album");
        oID3V1_1Tag.setArtist("Artist");
        oID3V1_1Tag.setComment("Comment");
        oID3V1_1Tag.setGenre(ID3V1Tag.Genre.Dance);
        oID3V1_1Tag.setTitle("Title");
        oID3V1_1Tag.setYear("1999");
        oID3V1_1Tag.setAlbumTrack(7);
        System.out.println(oID3V1_1Tag.toString());
        oMediaFile.setID3Tag(oID3V1_1Tag);
        ((MediaFile)oMediaFile).sync();
    }

    private static void testReadV1_0Tag() throws Exception {
        System.out.println("\n--- testReadV1_0Tag ---");
        File oSourceFile = new File(AllTests.s_RootPath + "v1_0tags.mp3");
        MP3File oMediaFile = new MP3File(oSourceFile);
        ID3Tag[] aoID3Tag = ((MediaFile)oMediaFile).getTags();
        ID3Test.printTags(aoID3Tag);
    }

    private static void testReadV1_1Tag() throws Exception {
        System.out.println("\n--- testReadV1_1Tag ---");
        File oSourceFile = new File(AllTests.s_RootPath + "v1_1tags.mp3");
        MP3File oMediaFile = new MP3File(oSourceFile);
        ID3Tag[] aoID3Tag = ((MediaFile)oMediaFile).getTags();
        ID3Test.printTags(aoID3Tag);
    }

    private static void printTags(ID3Tag[] aoID3Tag) throws Exception {
        System.out.println("Number of tag sets: " + aoID3Tag.length);
        for (int i = 0; i < aoID3Tag.length; ++i) {
            if (aoID3Tag[i] instanceof ID3V1_0Tag) {
                System.out.println("ID3V1_0Tag:");
                System.out.println(aoID3Tag[i].toString());
                continue;
            }
            if (aoID3Tag[i] instanceof ID3V1_1Tag) {
                System.out.println("ID3V1_1Tag:");
                System.out.println(aoID3Tag[i].toString());
                continue;
            }
            if (!(aoID3Tag[i] instanceof ID3V2_3_0Tag)) continue;
            System.out.println("ID3V2_3_0Tag:");
            System.out.println(aoID3Tag[i].toString());
        }
    }

    private static void copy(String sSource, String sDestination) throws Exception {
        int c;
        File oInputFile = new File(sSource);
        File oOutputFile = new File(sDestination);
        FileInputStream oFIS = new FileInputStream(oInputFile);
        FileOutputStream oFOS = new FileOutputStream(oOutputFile);
        while ((c = oFIS.read()) != -1) {
            oFOS.write(c);
        }
        oFIS.close();
        oFOS.close();
    }
}

