/*
 * Decompiled with CFR 0.152.
 */
package org.blinkenlights.jid3.io;

import org.blinkenlights.jid3.ID3Exception;

public class TextEncoding {
    private byte m_byEncoding;
    public static final TextEncoding ISO_8859_1 = new TextEncoding(0);
    public static final TextEncoding UNICODE = new TextEncoding(1);
    private static TextEncoding s_oDefaultTextEncoding = ISO_8859_1;

    private TextEncoding(byte byEncoding) {
        this.m_byEncoding = byEncoding;
    }

    public static TextEncoding getTextEncoding(int iEncoding) throws ID3Exception {
        return TextEncoding.getTextEncoding((byte)iEncoding);
    }

    public static TextEncoding getTextEncoding(byte byEncoding) throws ID3Exception {
        switch (byEncoding) {
            case 0: {
                return ISO_8859_1;
            }
            case 1: {
                return UNICODE;
            }
        }
        throw new ID3Exception("Unknown text encoding value " + byEncoding + ".");
    }

    public byte getEncodingValue() {
        return this.m_byEncoding;
    }

    public String getEncodingString() {
        switch (this.m_byEncoding) {
            case 0: {
                return "ISO-8859-1";
            }
            case 1: {
                return "Unicode";
            }
        }
        return null;
    }

    public boolean equals(Object oOther) {
        if (oOther == null || !(oOther instanceof TextEncoding)) {
            return false;
        }
        TextEncoding oOtherTextEncoding = (TextEncoding)oOther;
        return this.m_byEncoding == oOtherTextEncoding.m_byEncoding;
    }

    public static TextEncoding getDefaultTextEncoding() {
        return s_oDefaultTextEncoding;
    }

    public static void setDefaultTextEncoding(TextEncoding oTextEncoding) {
        if (oTextEncoding == null) {
            throw new NullPointerException("Default text encoding cannot be null.");
        }
        s_oDefaultTextEncoding = oTextEncoding;
    }
}

