/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.symmetry.internal;

import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.ce.CECalculator;
import org.biojava.nbio.structure.align.ce.CeCPMain;
import org.biojava.nbio.structure.align.ce.MatrixListener;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.util.AFPChainScorer;
import org.biojava.nbio.structure.jama.Matrix;
import org.biojava.nbio.structure.secstruc.SecStrucCalc;
import org.biojava.nbio.structure.secstruc.SecStrucTools;
import org.biojava.nbio.structure.symmetry.internal.AngleOrderDetectorPlus;
import org.biojava.nbio.structure.symmetry.internal.CESymmParameters;
import org.biojava.nbio.structure.symmetry.internal.CeSymmIterative;
import org.biojava.nbio.structure.symmetry.internal.CeSymmResult;
import org.biojava.nbio.structure.symmetry.internal.GraphComponentOrderDetector;
import org.biojava.nbio.structure.symmetry.internal.GraphComponentRefiner;
import org.biojava.nbio.structure.symmetry.internal.OrderDetector;
import org.biojava.nbio.structure.symmetry.internal.RefinerFailedException;
import org.biojava.nbio.structure.symmetry.internal.SequenceFunctionOrderDetector;
import org.biojava.nbio.structure.symmetry.internal.SequenceFunctionRefiner;
import org.biojava.nbio.structure.symmetry.internal.SymmOptimizer;
import org.biojava.nbio.structure.symmetry.internal.SymmetryAxes;
import org.biojava.nbio.structure.symmetry.internal.SymmetryRefiner;
import org.biojava.nbio.structure.symmetry.utils.SymmetryTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CeSymm {
    public static final String version = "2.2";
    public static final String algorithmName = "jCE-symm";
    private static final Logger logger = LoggerFactory.getLogger(CeSymm.class);
    private static final boolean multiPass = false;

    private CeSymm() {
    }

    private static Matrix align(AFPChain afpChain, Atom[] ca1, Atom[] ca2, CESymmParameters params, Matrix origM, CECalculator calculator, int counter) throws StructureException {
        int fragmentLength = params.getWinSize();
        Atom[] ca2clone = StructureTools.cloneAtomArray(ca2);
        int rows = ca1.length;
        int cols = ca2.length;
        int blankWindowSize = fragmentLength;
        if (origM == null) {
            afpChain = calculator.extractFragments(afpChain, ca1, ca2clone);
            origM = SymmetryTools.blankOutPreviousAlignment(afpChain, ca2, rows, cols, calculator, null, blankWindowSize);
        } else {
            origM = SymmetryTools.blankOutPreviousAlignment(afpChain, ca2, rows, cols, calculator, origM, blankWindowSize);
        }
        Matrix clone = (Matrix)origM.clone();
        calculator.setMatMatrix(clone.getArray());
        calculator.traceFragmentMatrix(afpChain, ca1, ca2clone);
        final Matrix origMfinal = (Matrix)origM.clone();
        calculator.addMatrixListener(new MatrixListener(){

            @Override
            public double[][] matrixInOptimizer(double[][] max) {
                for (int i = 0; i < max.length; ++i) {
                    for (int j = 0; j < max[i].length; ++j) {
                        if (!(origMfinal.getArray()[i][j] > 1.0E9)) continue;
                        max[i][j] = -origMfinal.getArray()[i][j];
                    }
                }
                return max;
            }

            @Override
            public boolean[][] initializeBreakFlag(boolean[][] brkFlag) {
                return brkFlag;
            }
        });
        calculator.nextStep(afpChain, ca1, ca2clone);
        afpChain.setAlgorithmName(algorithmName);
        afpChain.setVersion(version);
        afpChain.setDistanceMatrix(origM);
        return origMfinal;
    }

    protected static CeSymmResult align(Atom[] atoms, CESymmParameters params) throws StructureException {
        int order;
        CeSymmResult result = new CeSymmResult();
        result.setParams(params);
        result.setAtoms(atoms);
        Atom[] ca2 = StructureTools.duplicateCA2(atoms);
        int rows = atoms.length;
        int cols = ca2.length;
        if (rows == 0 || cols == 0) {
            throw new StructureException("Aligning empty structure");
        }
        Matrix origM = null;
        AFPChain myAFP = new AFPChain(algorithmName);
        CECalculator calculator = new CECalculator(params);
        Matrix lastMatrix = null;
        ArrayList<AFPChain> selfAlignments = new ArrayList<AFPChain>();
        AFPChain optimalAFP = null;
        int i = 0;
        if (origM != null) {
            myAFP.setDistanceMatrix((Matrix)origM.clone());
        }
        origM = CeSymm.align(myAFP, atoms, ca2, params, origM, calculator, i);
        double tmScore2 = AFPChainScorer.getTMScore(myAFP, atoms, ca2);
        myAFP.setTMScore(tmScore2);
        AFPChain newAFP = (AFPChain)myAFP.clone();
        newAFP = CeCPMain.postProcessAlignment(newAFP, atoms, ca2, calculator);
        double tmScore3 = AFPChainScorer.getTMScore(newAFP, atoms, ca2);
        newAFP.setTMScore(tmScore3);
        if (tmScore3 < params.getUnrefinedScoreThreshold()) {
            if (i == 0) {
                selfAlignments.add(newAFP);
            }
            lastMatrix = newAFP.getDistanceMatrix().copy();
        } else {
            selfAlignments.add(newAFP);
            if (++i < params.getMaxSymmOrder()) {
                // empty if block
            }
        }
        if (lastMatrix != null || selfAlignments.size() > 1) {
            // empty if block
        }
        optimalAFP = (AFPChain)selfAlignments.get(0);
        StructureIdentifier id = atoms[0].getGroup().getChain().getStructure().getStructureIdentifier();
        optimalAFP.setName1(id.getIdentifier());
        optimalAFP.setName2(id.getIdentifier());
        result.setSelfAlignment(optimalAFP);
        result.setStructureId(id);
        CESymmParameters.SymmetryType type = params.getSymmType();
        if (type == CESymmParameters.SymmetryType.AUTO) {
            if (result.getSelfAlignment().getBlockNum() == 1) {
                type = CESymmParameters.SymmetryType.OPEN;
                logger.info("Open Symmetry detected");
            } else {
                type = CESymmParameters.SymmetryType.CLOSED;
                logger.info("Close Symmetry detected");
            }
        }
        if (optimalAFP.getTMScore() < params.getUnrefinedScoreThreshold()) {
            result.setNumRepeats(1);
            return result;
        }
        try {
            OrderDetector orderDetector = null;
            order = 1;
            switch (params.getOrderDetectorMethod()) {
                case USER_INPUT: {
                    order = params.getUserOrder();
                    break;
                }
                case SEQUENCE_FUNCTION: {
                    if (type == CESymmParameters.SymmetryType.CLOSED) {
                        orderDetector = new SequenceFunctionOrderDetector(params.getMaxSymmOrder(), 0.4f);
                        order = orderDetector.calculateOrder(result.getSelfAlignment(), atoms);
                        break;
                    }
                }
                case ANGLE: {
                    if (type == CESymmParameters.SymmetryType.CLOSED) {
                        orderDetector = new AngleOrderDetectorPlus(params.getMaxSymmOrder());
                        order = orderDetector.calculateOrder(result.getSelfAlignment(), atoms);
                        break;
                    }
                }
                case GRAPH_COMPONENT: {
                    orderDetector = new GraphComponentOrderDetector();
                    order = orderDetector.calculateOrder(result.getSelfAlignment(), atoms);
                }
            }
            result.setNumRepeats(order);
            SymmetryRefiner refiner = null;
            switch (params.getRefineMethod()) {
                case NOT_REFINED: {
                    return result;
                }
                case SEQUENCE_FUNCTION: {
                    if (type == CESymmParameters.SymmetryType.CLOSED) {
                        refiner = new SequenceFunctionRefiner();
                        break;
                    }
                }
                case GRAPH_COMPONENT: {
                    refiner = new GraphComponentRefiner();
                }
            }
            MultipleAlignment msa = refiner.refine(result.getSelfAlignment(), atoms, order);
            result.setMultipleAlignment(msa);
            result.setNumRepeats(msa.size());
            result.setRefined(true);
        }
        catch (RefinerFailedException e) {
            logger.info("Refinement failed: " + e.getMessage());
            return result;
        }
        SymmetryAxes axes = new SymmetryAxes();
        order = result.getMultipleAlignment().size();
        Matrix4d axis = result.getMultipleAlignment().getBlockSet(0).getTransformations().get(1);
        axes.addAxis(axis, order, type);
        result.setAxes(axes);
        return result;
    }

    public static CeSymmResult analyze(Atom[] atoms) throws StructureException {
        CESymmParameters params = new CESymmParameters();
        return CeSymm.analyze(atoms, params);
    }

    public static CeSymmResult analyze(Atom[] atoms, CESymmParameters params) throws StructureException {
        CeSymmIterative iter;
        CeSymmResult result;
        Structure s;
        if (atoms.length < 1) {
            throw new IllegalArgumentException("Empty Atom array given.");
        }
        if (params.getSSEThreshold() > 0 && SecStrucTools.getSecStrucInfo(s = atoms[0].getGroup().getChain().getStructure()).isEmpty()) {
            logger.info("Calculating Secondary Structure...");
            SecStrucCalc ssp = new SecStrucCalc();
            ssp.calculate(s, true);
        }
        if ((result = (iter = new CeSymmIterative(params)).execute(atoms)).isRefined()) {
            if (params.getOptimization() && result.getSymmLevels() > 1) {
                try {
                    SymmOptimizer optimizer = new SymmOptimizer(result);
                    MultipleAlignment optimized = optimizer.optimize();
                    result.setMultipleAlignment(optimized);
                }
                catch (RefinerFailedException e) {
                    logger.info("Final optimization failed:" + e.getMessage());
                }
            }
            result.getMultipleAlignment().getEnsemble().setStructureIdentifiers(result.getRepeatsID());
        }
        return result;
    }

    public static CeSymmResult analyzeLevel(Atom[] atoms, CESymmParameters params) throws StructureException {
        if (atoms.length < 1) {
            throw new IllegalArgumentException("Empty Atom array given.");
        }
        CeSymmResult result = CeSymm.align(atoms, params);
        if (result.isRefined() && result.getParams().getOptimization()) {
            try {
                MultipleAlignment msa = result.getMultipleAlignment();
                SymmOptimizer optimizer = new SymmOptimizer(result);
                msa = optimizer.optimize();
                result.setMultipleAlignment(msa);
            }
            catch (RefinerFailedException e) {
                logger.debug("Optimization failed:" + e.getMessage());
            }
        }
        return result;
    }
}

