/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.biojava.nbio.alignment.Alignments;
import org.biojava.nbio.alignment.SimpleGapPenalty;
import org.biojava.nbio.alignment.template.GapPenalty;
import org.biojava.nbio.alignment.template.PairwiseSequenceAligner;
import org.biojava.nbio.core.alignment.matrices.SubstitutionMatrixHelper;
import org.biojava.nbio.core.alignment.template.SequencePair;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.RNASequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.NucleotideCompound;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.EntityType;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.io.SeqRes2AtomAligner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityFinder {
    private static final Logger logger = LoggerFactory.getLogger(EntityFinder.class);
    public static final double RATIO_GAPS_FOR_MISMATCH = 0.5;
    public static final double IDENTITY_THRESHOLD = 0.99999;
    public static final double GAP_COVERAGE_THRESHOLD = 0.3;

    public static List<EntityInfo> findPolyEntities(List<List<Chain>> polyModels) {
        TreeMap<String, EntityInfo> chainIds2entities = EntityFinder.findEntitiesFromAlignment(polyModels);
        return EntityFinder.findUniqueEntities(chainIds2entities);
    }

    private static List<EntityInfo> findUniqueEntities(TreeMap<String, EntityInfo> chainIds2entities) {
        ArrayList<EntityInfo> list = new ArrayList<EntityInfo>();
        for (EntityInfo cluster : chainIds2entities.values()) {
            boolean present = false;
            for (EntityInfo cl : list) {
                if (cl != cluster) continue;
                present = true;
                break;
            }
            if (present) continue;
            list.add(cluster);
        }
        return list;
    }

    public static void createPurelyNonPolyEntities(List<List<Chain>> nonPolyModels, List<List<Chain>> waterModels, List<EntityInfo> entities) {
        if (nonPolyModels.isEmpty()) {
            return;
        }
        int maxMolId = 0;
        if (!entities.isEmpty()) {
            maxMolId = Collections.max(entities, Comparator.comparingInt(EntityInfo::getMolId)).getMolId();
        }
        int molId = maxMolId + 1;
        if (!nonPolyModels.get(0).isEmpty()) {
            ArrayList<EntityInfo> nonPolyEntities = new ArrayList<EntityInfo>();
            for (List<Chain> model : nonPolyModels) {
                for (Chain c : model) {
                    String molecPdbName = c.getAtomGroup(0).getPDBName();
                    EntityInfo nonPolyEntity = EntityFinder.findNonPolyEntityWithDescription(molecPdbName, nonPolyEntities);
                    if (nonPolyEntity == null) {
                        nonPolyEntity = new EntityInfo();
                        nonPolyEntity.setDescription(molecPdbName);
                        nonPolyEntity.setType(EntityType.NONPOLYMER);
                        nonPolyEntity.setMolId(molId++);
                        nonPolyEntities.add(nonPolyEntity);
                    }
                    nonPolyEntity.addChain(c);
                    c.setEntityInfo(nonPolyEntity);
                }
            }
            entities.addAll(nonPolyEntities);
        }
        if (!waterModels.get(0).isEmpty()) {
            EntityInfo waterEntity = new EntityInfo();
            waterEntity.setType(EntityType.WATER);
            waterEntity.setDescription("water");
            waterEntity.setMolId(molId);
            for (List<Chain> model : waterModels) {
                for (Chain waterChain : model) {
                    waterEntity.addChain(waterChain);
                    waterChain.setEntityInfo(waterEntity);
                }
            }
            entities.add(waterEntity);
        }
    }

    private static EntityInfo findNonPolyEntityWithDescription(String description, List<EntityInfo> nonPolyEntities) {
        for (EntityInfo e : nonPolyEntities) {
            if (!e.getDescription().equals(description)) continue;
            return e;
        }
        return null;
    }

    private static boolean areResNumbersAligned(Chain c1, Chain c2) {
        boolean isC2prot;
        boolean isC1prot = c1.isProtein();
        if (isC1prot != (isC2prot = c2.isProtein())) {
            return false;
        }
        List<Group> c1AtomGroups = null;
        c1AtomGroups = isC1prot ? c1.getAtomGroups(GroupType.AMINOACID) : c1.getAtomGroups(GroupType.NUCLEOTIDE);
        int countNonExisting = 0;
        for (Group g1 : c1AtomGroups) {
            try {
                Group g2 = c2.getGroupByPDB(g1.getResidueNumber());
                if (g2.getPDBName().equals(g1.getPDBName())) continue;
                logger.debug("Mismatch of residues between chains {},{} for residue number {}: {} {}", new Object[]{c1.getId(), c2.getId(), g1.getResidueNumber(), g1.getPDBName(), g2.getPDBName()});
                return false;
            }
            catch (StructureException e) {
                ++countNonExisting;
            }
        }
        if ((double)countNonExisting / (double)c1AtomGroups.size() > 0.5) {
            logger.debug("More than {} of the residues ({} out of {}) are not present in chain {} when comparing by residue numbers to chain {}.", new Object[]{0.5, countNonExisting, c1AtomGroups.size(), c2.getId(), c1.getId()});
            return false;
        }
        return true;
    }

    private static TreeMap<String, EntityInfo> findEntitiesFromAlignment(List<List<Chain>> polyModels) {
        int i;
        TreeMap<String, EntityInfo> chainIds2entities = new TreeMap<String, EntityInfo>();
        if (polyModels.isEmpty()) {
            return chainIds2entities;
        }
        TreeSet<Integer> polyChainIndices = new TreeSet<Integer>();
        for (int i2 = 0; i2 < polyModels.get(0).size(); ++i2) {
            polyChainIndices.add(i2);
        }
        int molId = 1;
        Iterator iterator = polyChainIndices.iterator();
        block1: while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            Chain c1 = polyModels.get(0).get(i);
            String str1 = SeqRes2AtomAligner.getFullAtomSequence(c1.getAtomGroups(), new HashMap<Integer, Integer>(), false);
            Iterator iterator2 = polyChainIndices.iterator();
            while (iterator2.hasNext()) {
                SequencePair<ProteinSequence, AminoAcidCompound> pair;
                ProteinSequence s2;
                ProteinSequence s1;
                int j = (Integer)iterator2.next();
                if (j <= i) continue;
                Chain c2 = polyModels.get(0).get(j);
                String str2 = SeqRes2AtomAligner.getFullAtomSequence(c2.getAtomGroups(), new HashMap<Integer, Integer>(), false);
                int seq1Length = 0;
                int seq2Length = 0;
                if (EntityFinder.isProteinSequence(str1) && EntityFinder.isProteinSequence(str2)) {
                    s1 = EntityFinder.getProteinSequence(str1);
                    s2 = EntityFinder.getProteinSequence(str2);
                    seq1Length = s1.getLength();
                    seq2Length = s2.getLength();
                    pair = EntityFinder.alignProtein(s1, s2);
                } else if (EntityFinder.isDNASequence(str1) && EntityFinder.isDNASequence(str2)) {
                    s1 = EntityFinder.getDNASequence(str1);
                    s2 = EntityFinder.getDNASequence(str2);
                    seq1Length = s1.getLength();
                    seq2Length = s2.getLength();
                    pair = EntityFinder.alignDNA((DNASequence)s1, (DNASequence)s2);
                } else if (EntityFinder.isRNASequence(str1) && EntityFinder.isRNASequence(str2)) {
                    s1 = EntityFinder.getRNASequence(str1);
                    s2 = EntityFinder.getRNASequence(str2);
                    seq1Length = s1.getLength();
                    seq2Length = s2.getLength();
                    pair = EntityFinder.alignRNA((RNASequence)s1, (RNASequence)s2);
                } else {
                    logger.debug("Chains {},{} are either different kind of polymers or could not be recognized as protein or nucleotide polymers", (Object)c1.getId(), (Object)c2.getId());
                    continue;
                }
                int numGaps = EntityFinder.getNumGaps(pair);
                int numGaps1 = EntityFinder.getNumGapsQuery(pair);
                int numGaps2 = EntityFinder.getNumGapsTarget(pair);
                int nonGaps = pair.getLength() - numGaps;
                double identity = (double)pair.getNumIdenticals() / (double)nonGaps;
                double gapCov1 = (double)numGaps1 / (double)seq1Length;
                double gapCov2 = (double)numGaps2 / (double)seq2Length;
                logger.debug("Alignment for chain pair {},{}: identity: {}, gap coverage 1: {}, gap coverage 2: {}", new Object[]{c1.getId(), c2.getId(), String.format("%4.2f", identity), String.format("%4.2f", gapCov1), String.format("%4.2f", gapCov2)});
                logger.debug("\n" + pair.toString(100));
                if (identity > 0.99999 && gapCov1 < 0.3 && gapCov2 < 0.3) {
                    if (!chainIds2entities.containsKey(c1.getId()) && !chainIds2entities.containsKey(c2.getId())) {
                        logger.debug("Creating entity with chains {},{}", (Object)c1.getId(), (Object)c2.getId());
                        EntityInfo ent = new EntityInfo();
                        ent.addChain(c1);
                        ent.addChain(c2);
                        ent.setMolId(molId++);
                        ent.setType(EntityType.POLYMER);
                        c1.setEntityInfo(ent);
                        c2.setEntityInfo(ent);
                        chainIds2entities.put(c1.getId(), ent);
                        chainIds2entities.put(c2.getId(), ent);
                    } else {
                        Chain chainToAdd;
                        EntityInfo ent = chainIds2entities.get(c1.getId());
                        if (ent == null) {
                            ent = chainIds2entities.get(c2.getId());
                            chainToAdd = c1;
                        } else {
                            chainToAdd = c2;
                        }
                        if (!chainIds2entities.containsKey(chainToAdd.getId())) {
                            logger.debug("Adding chain {} to entity {}", (Object)chainToAdd.getId(), (Object)ent.getId());
                            ent.addChain(chainToAdd);
                            chainToAdd.setEntityInfo(ent);
                            chainIds2entities.put(chainToAdd.getId(), ent);
                        }
                    }
                    if (!EntityFinder.areResNumbersAligned(c1, c2)) {
                        logger.warn("Including 100% identical chains {},{} in same entity, although they have misaligned residue numbers", (Object)c1.getId(), (Object)c2.getId());
                    }
                }
                if (identity > 1.0) {
                    logger.warn("Identity for chains {},{} above 1. {} identicals out of {} non-gap-aligned residues (identity {})", new Object[]{c1.getId(), c2.getId(), pair.getNumIdenticals(), nonGaps, identity});
                    logger.warn("\n" + pair.toString(100));
                }
                if (chainIds2entities.size() != polyChainIndices.size()) continue;
                break block1;
            }
        }
        iterator = polyChainIndices.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            Chain c = polyModels.get(0).get(i);
            if (chainIds2entities.containsKey(c.getId())) continue;
            logger.debug("Creating a 1-member entity for chain {}", (Object)c.getId());
            EntityInfo ent = new EntityInfo();
            ent.addChain(c);
            ent.setMolId(molId++);
            ent.setType(EntityType.POLYMER);
            c.setEntityInfo(ent);
            chainIds2entities.put(c.getId(), ent);
        }
        for (int i3 = 1; i3 < polyModels.size(); ++i3) {
            for (Chain chain : polyModels.get(i3)) {
                EntityInfo e = chainIds2entities.get(chain.getId());
                chain.setEntityInfo(e);
                e.addChain(chain);
            }
        }
        return chainIds2entities;
    }

    private static SequencePair<ProteinSequence, AminoAcidCompound> alignProtein(ProteinSequence s1, ProteinSequence s2) {
        SubstitutionMatrix matrix = SubstitutionMatrixHelper.getIdentity();
        SimpleGapPenalty penalty = new SimpleGapPenalty(8, 1);
        PairwiseSequenceAligner nw = Alignments.getPairwiseAligner((Sequence)s1, (Sequence)s2, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.GLOBAL, (GapPenalty)penalty, (SubstitutionMatrix)matrix);
        return nw.getPair();
    }

    private static SequencePair<DNASequence, NucleotideCompound> alignDNA(DNASequence s1, DNASequence s2) {
        SubstitutionMatrix matrix = SubstitutionMatrixHelper.getNuc4_4();
        SimpleGapPenalty penalty = new SimpleGapPenalty(8, 1);
        PairwiseSequenceAligner nw = Alignments.getPairwiseAligner((Sequence)s1, (Sequence)s2, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.GLOBAL, (GapPenalty)penalty, (SubstitutionMatrix)matrix);
        return nw.getPair();
    }

    private static SequencePair<RNASequence, NucleotideCompound> alignRNA(RNASequence s1, RNASequence s2) {
        SubstitutionMatrix matrix = SubstitutionMatrixHelper.getNuc4_4();
        SimpleGapPenalty penalty = new SimpleGapPenalty(8, 1);
        PairwiseSequenceAligner nw = Alignments.getPairwiseAligner((Sequence)s1, (Sequence)s2, (Alignments.PairwiseSequenceAlignerType)Alignments.PairwiseSequenceAlignerType.GLOBAL, (GapPenalty)penalty, (SubstitutionMatrix)matrix);
        return nw.getPair();
    }

    private static int getNumGaps(SequencePair<?, ?> pair) {
        int numGaps = 0;
        for (int alignmentIndex = 1; alignmentIndex <= pair.getLength(); ++alignmentIndex) {
            if (!pair.hasGap(alignmentIndex)) continue;
            ++numGaps;
        }
        return numGaps;
    }

    private static int getNumGapsQuery(SequencePair<?, ?> pair) {
        int numGaps = 0;
        for (int alignmentIndex = 1; alignmentIndex <= pair.getLength(); ++alignmentIndex) {
            if (!pair.getCompoundInQueryAt(alignmentIndex).getShortName().equals("-")) continue;
            ++numGaps;
        }
        return numGaps;
    }

    private static int getNumGapsTarget(SequencePair<?, ?> pair) {
        int numGaps = 0;
        for (int alignmentIndex = 1; alignmentIndex <= pair.getLength(); ++alignmentIndex) {
            if (!pair.getCompoundInTargetAt(alignmentIndex).getShortName().equals("-")) continue;
            ++numGaps;
        }
        return numGaps;
    }

    private static boolean isProteinSequence(String str) {
        try {
            new ProteinSequence(str);
        }
        catch (CompoundNotFoundException e) {
            return false;
        }
        return true;
    }

    private static boolean isDNASequence(String str) {
        try {
            new DNASequence(str);
        }
        catch (CompoundNotFoundException e) {
            return false;
        }
        return true;
    }

    private static boolean isRNASequence(String str) {
        try {
            new RNASequence(str);
        }
        catch (CompoundNotFoundException e) {
            return false;
        }
        return true;
    }

    private static ProteinSequence getProteinSequence(String str) {
        try {
            ProteinSequence s = new ProteinSequence(str);
            return s;
        }
        catch (CompoundNotFoundException e) {
            logger.error("Unexpected error when creating ProteinSequence", (Throwable)e);
            return null;
        }
    }

    private static DNASequence getDNASequence(String str) {
        try {
            DNASequence s = new DNASequence(str);
            return s;
        }
        catch (CompoundNotFoundException e) {
            logger.error("Unexpected error when creating DNASequence ", (Throwable)e);
            return null;
        }
    }

    private static RNASequence getRNASequence(String str) {
        try {
            RNASequence s = new RNASequence(str);
            return s;
        }
        catch (CompoundNotFoundException e) {
            logger.error("Unexpected error when creating RNASequence ", (Throwable)e);
            return null;
        }
    }
}

