/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.contact;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import org.biojava.nbio.structure.contact.Contact;
import org.biojava.nbio.structure.contact.Grid;

public class GridCell {
    private Grid grid;
    private ArrayList<Integer> iIndices = new ArrayList();
    private ArrayList<Integer> jIndices = new ArrayList();

    public GridCell(Grid parent) {
        this.grid = parent;
    }

    public void addIindex(int serial) {
        this.iIndices.add(serial);
    }

    public void addJindex(int serial) {
        this.jIndices.add(serial);
    }

    public int getNumIindices() {
        return this.iIndices.size();
    }

    public int getNumJindices() {
        return this.jIndices.size();
    }

    public List<Contact> getContactsWithinCell() {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        Point3d[] iAtoms = this.grid.getIAtoms();
        Point3d[] jAtoms = this.grid.getJAtoms();
        double cutoff = this.grid.getCutoff();
        if (jAtoms == null) {
            for (int i : this.iIndices) {
                for (int j : this.iIndices) {
                    double distance;
                    if (j <= i || !((distance = iAtoms[i].distance(iAtoms[j])) < cutoff)) continue;
                    contacts.add(new Contact(i, j, distance));
                }
            }
        } else {
            for (int i : this.iIndices) {
                for (int j : this.jIndices) {
                    double distance = iAtoms[i].distance(jAtoms[j]);
                    if (!(distance < cutoff)) continue;
                    contacts.add(new Contact(i, j, distance));
                }
            }
        }
        return contacts;
    }

    public List<Contact> getContactsToOtherCell(GridCell otherCell) {
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        Point3d[] iAtoms = this.grid.getIAtoms();
        Point3d[] jAtoms = this.grid.getJAtoms();
        double cutoff = this.grid.getCutoff();
        if (jAtoms == null) {
            for (int i : this.iIndices) {
                for (int j : otherCell.iIndices) {
                    double distance;
                    if (j <= i || !((distance = iAtoms[i].distance(iAtoms[j])) < cutoff)) continue;
                    contacts.add(new Contact(i, j, distance));
                }
            }
        } else {
            for (int i : this.iIndices) {
                for (int j : otherCell.jIndices) {
                    double distance = iAtoms[i].distance(jAtoms[j]);
                    if (!(distance < cutoff)) continue;
                    contacts.add(new Contact(i, j, distance));
                }
            }
        }
        return contacts;
    }

    public boolean hasContactToAtom(Point3d[] iAtoms, Point3d[] jAtoms, Point3d query, double cutoff) {
        double distance;
        for (int i : this.iIndices) {
            distance = iAtoms[i].distance(query);
            if (!(distance < cutoff)) continue;
            return true;
        }
        if (jAtoms != null) {
            for (int i : this.jIndices) {
                distance = jAtoms[i].distance(query);
                if (!(distance < cutoff)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.format("GridCell [%d iAtoms,%d jAtoms]", this.iIndices.size(), this.jIndices == null ? "-" : Integer.valueOf(this.jIndices.size()));
    }
}

