/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.basepairs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.contact.Pair;
import org.biojava.nbio.structure.geometry.SuperPositionQCP;
import org.biojava.nbio.structure.io.PDBFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePairParameters
implements Serializable {
    private static final long serialVersionUID = 6214502385L;
    private static Logger log = LoggerFactory.getLogger(BasePairParameters.class);
    public static final String[] STANDARD_BASES = new String[]{"SEQRES   1 A    1  A\nATOM      2  N9    A A   1      -1.291   4.498   0.000\nATOM      3  C8    A A   1       0.024   4.897   0.000\nATOM      4  N7    A A   1       0.877   3.902   0.000\nATOM      5  C5    A A   1       0.071   2.771   0.000\nATOM      6  C6    A A   1       0.369   1.398   0.000\nATOM      8  N1    A A   1      -0.668   0.532   0.000\nATOM      9  C2    A A   1      -1.912   1.023   0.000\nATOM     10  N3    A A   1      -2.320   2.290   0.000\nATOM     11  C4    A A   1      -1.267   3.124   0.000\nEND", "SEQRES   1 A    1  G\nATOM      2  N9    G A   1      -1.289   4.551   0.000\nATOM      3  C8    G A   1       0.023   4.962   0.000\nATOM      4  N7    G A   1       0.870   3.969   0.000\nATOM      5  C5    G A   1       0.071   2.833   0.000\nATOM      6  C6    G A   1       0.424   1.460   0.000\nATOM      8  N1    G A   1      -0.700   0.641   0.000\nATOM      9  C2    G A   1      -1.999   1.087   0.000\nATOM     11  N3    G A   1      -2.342   2.364   0.001\nATOM     12  C4    G A   1      -1.265   3.177   0.000\nEND", "SEQRES   1 A    1  T\nATOM      2  N1    T A   1      -1.284   4.500   0.000\nATOM      3  C2    T A   1      -1.462   3.135   0.000\nATOM      5  N3    T A   1      -0.298   2.407   0.000\nATOM      6  C4    T A   1       0.994   2.897   0.000\nATOM      8  C5    T A   1       1.106   4.338   0.000\nATOM     10  C6    T A   1      -0.024   5.057   0.000\nEND", "SEQRES   1 A    1  C\nATOM      2  N1    C A   1      -1.285   4.542   0.000\nATOM      3  C2    C A   1      -1.472   3.158   0.000\nATOM      5  N3    C A   1      -0.391   2.344   0.000\nATOM      6  C4    C A   1       0.837   2.868   0.000\nATOM      8  C5    C A   1       1.056   4.275   0.000\nATOM      9  C6    C A   1      -0.023   5.068   0.000\nEND", "SEQRES   1 A    1  U\nATOM      2  N1    U A   1      -1.284   4.500   0.000\nATOM      3  C2    U A   1      -1.462   3.131   0.000\nATOM      5  N3    U A   1      -0.302   2.397   0.000\nATOM      6  C4    U A   1       0.989   2.884   0.000\nATOM      8  C5    U A   1       1.089   4.311   0.000\nATOM      9  C6    U A   1      -0.024   5.053   0.000\n"};
    protected static final String[] BASE_LIST_DNA = new String[]{"A", "G", "T", "C"};
    protected static final String[] BASE_LIST_RNA = new String[]{"A", "G", "U", "C"};
    protected static final Map<String, Integer> BASE_MAP = new HashMap<String, Integer>();
    protected static final Map<Integer, List<String>> RING_MAP;
    protected Structure structure;
    protected boolean canonical = true;
    protected boolean useRNA = false;
    protected boolean nonredundant = false;
    protected double[] pairParameters;
    protected String pairSequence = "";
    protected double[][] pairingParameters;
    protected double[][] stepParameters;
    protected List<String> pairingNames = new ArrayList<String>();
    protected List<Matrix4d> referenceFrames = new ArrayList<Matrix4d>();

    public BasePairParameters(Structure structure, boolean useRNA, boolean removeDups, boolean canonical) {
        this.structure = structure;
        this.useRNA = useRNA;
        this.canonical = canonical;
        this.nonredundant = removeDups;
    }

    public BasePairParameters(Structure structure, boolean useRNA, boolean removeDups) {
        this(structure, useRNA, removeDups, false);
    }

    public BasePairParameters(Structure structure, boolean useRNA) {
        this(structure, useRNA, false, false);
    }

    public BasePairParameters(Structure structure) {
        this(structure, false, false, true);
    }

    public BasePairParameters analyze() {
        if (this.structure == null) {
            this.pairingParameters = null;
            this.stepParameters = null;
            return this;
        }
        List<Chain> nucleics = this.getNucleicChains(this.nonredundant);
        List<Pair<Group>> pairs = this.findPairs(nucleics);
        this.pairingParameters = new double[pairs.size()][6];
        this.stepParameters = new double[pairs.size()][6];
        Matrix4d currentStep = null;
        for (int i = 0; i < pairs.size(); ++i) {
            Matrix4d lastStep = currentStep;
            currentStep = this.basePairReferenceFrame(pairs.get(i));
            this.referenceFrames.add((Matrix4d)currentStep.clone());
            for (int j = 0; j < 6; ++j) {
                this.pairingParameters[i][j] = this.pairParameters[j];
            }
            if (i == 0) continue;
            lastStep.invert();
            lastStep.mul(currentStep);
            double[] sparms = BasePairParameters.calculateTp(lastStep);
            for (int j = 0; j < 6; ++j) {
                this.stepParameters[i][j] = sparms[j];
            }
        }
        return this;
    }

    public int getLength() {
        if (this.structure == null || this.pairParameters == null) {
            throw new IllegalArgumentException("This structure is not analyzed or not initialized.");
        }
        return this.pairingParameters.length;
    }

    public double[][] getPairingParameters() {
        return this.pairingParameters;
    }

    public double[][] getStepParameters() {
        return this.stepParameters;
    }

    public String getPairSequence() {
        return this.pairSequence;
    }

    public List<String> getPairingNames() {
        return this.pairingNames;
    }

    public List<Matrix4d> getReferenceFrames() {
        return this.referenceFrames;
    }

    private void checkArgument(int bp) {
        if (bp < 0 || bp >= this.getPairingParameters().length) {
            throw new IllegalArgumentException("Base pair number is out of range.");
        }
    }

    public Double getBuckle(int bp) {
        this.checkArgument(bp);
        return this.pairingParameters[bp][0];
    }

    public Double getPropeller(int bp) {
        this.checkArgument(bp);
        return this.pairingParameters[bp][1];
    }

    public Double getOpening(int bp) {
        this.checkArgument(bp);
        return this.pairingParameters[bp][2];
    }

    public Double getShear(int bp) {
        this.checkArgument(bp);
        return this.pairingParameters[bp][3];
    }

    public Double getStretch(int bp) {
        this.checkArgument(bp);
        return this.pairingParameters[bp][4];
    }

    public Double getStagger(int bp) {
        this.checkArgument(bp);
        return this.pairingParameters[bp][5];
    }

    public Double getTilt(int bp) {
        this.checkArgument(bp);
        return this.stepParameters[bp][0];
    }

    public Double getRoll(int bp) {
        if (bp < 0 || bp >= this.getStepParameters().length) {
            throw new IllegalArgumentException("Base pair number is out of range.");
        }
        return this.stepParameters[bp][1];
    }

    public Double getTwist(int bp) {
        if (bp < 0 || bp >= this.getStepParameters().length) {
            throw new IllegalArgumentException("Base pair number is out of range.");
        }
        return this.stepParameters[bp][2];
    }

    public Double getShift(int bp) {
        if (bp < 0 || bp >= this.getStepParameters().length) {
            throw new IllegalArgumentException("Base pair number is out of range.");
        }
        return this.stepParameters[bp][3];
    }

    public Double getSlide(int bp) {
        if (bp < 0 || bp >= this.getStepParameters().length) {
            throw new IllegalArgumentException("Base pair number is out of range.");
        }
        return this.stepParameters[bp][4];
    }

    public Double getRise(int bp) {
        if (bp < 0 || bp >= this.getStepParameters().length) {
            throw new IllegalArgumentException("Base pair number is out of range.");
        }
        return this.stepParameters[bp][5];
    }

    public List<Chain> getNucleicChains(boolean removeDups) {
        if (this.structure == null) {
            return new ArrayList<Chain>();
        }
        List<Chain> chains = this.structure.getChains();
        ArrayList<Chain> result = new ArrayList<Chain>();
        for (Chain c : chains) {
            if (!c.isNucleicAcid()) continue;
            result.add(c);
        }
        if (removeDups) {
            for (int i = 0; i < result.size(); ++i) {
                for (int j = i + 2; j < result.size(); ++j) {
                    if (!((Chain)result.get(i)).getAtomSequence().equals(((Chain)result.get(j)).getAtomSequence())) continue;
                    result.remove(j);
                }
            }
        }
        return result;
    }

    public List<Pair<Group>> findPairs(List<Chain> chains) {
        ArrayList<Pair<Group>> result = new ArrayList<Pair<Group>>();
        for (int i = 0; i < chains.size(); ++i) {
            Chain c = chains.get(i);
            for (int j = i + 1; j < chains.size(); ++j) {
                String complement = BasePairParameters.complement(chains.get(j).getAtomSequence(), this.useRNA);
                String match = BasePairParameters.longestCommonSubstring(c.getAtomSequence(), complement);
                if (log.isDebugEnabled()) {
                    log.debug(c.getAtomSequence() + " " + chains.get(j).getAtomSequence() + " " + match);
                }
                int index1 = c.getAtomSequence().indexOf(match);
                int index2 = complement.length() - complement.indexOf(match) - 1;
                for (int k = 0; k < match.length(); ++k) {
                    double dz;
                    double dy;
                    Group g1 = c.getAtomGroup(index1 + k);
                    Group g2 = chains.get(j).getAtomGroup(index2 - k);
                    Integer type1 = BASE_MAP.get(g1.getPDBName());
                    Integer type2 = BASE_MAP.get(g2.getPDBName());
                    if (type1 == null || type2 == null) {
                        if (this.pairSequence.length() == 0 || this.pairSequence.charAt(this.pairSequence.length() - 1) == ' ') continue;
                        this.pairSequence = this.pairSequence + ' ';
                        continue;
                    }
                    Atom a1 = g1.getAtom(RING_MAP.get(type1).get(0));
                    Atom a2 = g2.getAtom(RING_MAP.get(type2).get(0));
                    if (a1 == null) {
                        log.info("Error processing " + g1.getPDBName());
                        if (this.pairSequence.length() == 0 || this.pairSequence.charAt(this.pairSequence.length() - 1) == ' ') continue;
                        this.pairSequence = this.pairSequence + ' ';
                        continue;
                    }
                    if (a2 == null) {
                        log.info("Error processing " + g2.getPDBName());
                        if (this.pairSequence.length() == 0 || this.pairSequence.charAt(this.pairSequence.length() - 1) == ' ') continue;
                        this.pairSequence = this.pairSequence + ' ';
                        continue;
                    }
                    double dx = a1.getX() - a2.getX();
                    double distance = Math.sqrt(dx * dx + (dy = a1.getY() - a2.getY()) * dy + (dz = a1.getZ() - a2.getZ()) * dz);
                    if (Math.abs(distance - 10.0) < 4.0) {
                        Atom a;
                        boolean valid = true;
                        for (String atomname : RING_MAP.get(type1)) {
                            a = g1.getAtom(atomname);
                            if (a != null) continue;
                            valid = false;
                        }
                        if (valid) {
                            for (String atomname : RING_MAP.get(type2)) {
                                a = g2.getAtom(atomname);
                                if (a != null) continue;
                                valid = false;
                            }
                        }
                        if (valid) {
                            result.add(new Pair<Group>(g1, g2));
                            this.pairingNames.add(this.useRNA ? BASE_LIST_RNA[type1] + BASE_LIST_RNA[type2] : BASE_LIST_DNA[type1] + BASE_LIST_DNA[type2]);
                            this.pairSequence = this.pairSequence + c.getAtomSequence().charAt(index1 + k);
                            continue;
                        }
                        if (this.pairSequence.length() == 0 || this.pairSequence.charAt(this.pairSequence.length() - 1) == ' ') continue;
                        this.pairSequence = this.pairSequence + ' ';
                        continue;
                    }
                    if (this.pairSequence.length() == 0 || this.pairSequence.charAt(this.pairSequence.length() - 1) == ' ') continue;
                    this.pairSequence = this.pairSequence + ' ';
                }
                if (this.pairSequence.length() == 0 || this.pairSequence.charAt(this.pairSequence.length() - 1) == ' ') continue;
                this.pairSequence = this.pairSequence + ' ';
            }
        }
        log.info("Matched: " + this.pairSequence);
        return result;
    }

    public Matrix4d basePairReferenceFrame(Pair<Group> pair) {
        int i;
        Structure s2;
        Structure s1;
        Integer type1 = BASE_MAP.get(pair.getFirst().getPDBName());
        Integer type2 = BASE_MAP.get(pair.getSecond().getPDBName());
        SuperPositionQCP sp = new SuperPositionQCP(true);
        if (type1 == null || type2 == null) {
            return null;
        }
        PDBFileReader pdbFileReader = new PDBFileReader();
        try {
            s1 = pdbFileReader.getStructure(new ByteArrayInputStream(STANDARD_BASES[type1].getBytes()));
            s2 = pdbFileReader.getStructure(new ByteArrayInputStream(STANDARD_BASES[type2].getBytes()));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        Group std1 = s1.getChain("A").getAtomGroup(0);
        Group std2 = s2.getChain("A").getAtomGroup(0);
        Point3d[] pointref = new Point3d[std1.getAtoms().size()];
        Point3d[] pointact = new Point3d[std1.getAtoms().size()];
        int count = 0;
        for (Atom atom : std1.getAtoms()) {
            if (pair.getFirst().getAtom(atom.getName()) == null) {
                return null;
            }
            pointref[count] = atom.getCoordsAsPoint3d();
            pointact[count] = pair.getFirst().getAtom(atom.getName()).getCoordsAsPoint3d();
            ++count;
        }
        assert (count == std1.getAtoms().size());
        Matrix4d ref1 = (Matrix4d)sp.superposeAndTransform(pointact, pointref).clone();
        pointref = new Point3d[std2.getAtoms().size()];
        pointact = new Point3d[std2.getAtoms().size()];
        count = 0;
        for (Atom a : std2.getAtoms()) {
            if (pair.getSecond().getAtom(a.getName()) == null) {
                return null;
            }
            pointref[count] = a.getCoordsAsPoint3d();
            pointact[count] = pair.getSecond().getAtom(a.getName()).getCoordsAsPoint3d();
            ++count;
        }
        assert (count == std2.getAtoms().size());
        Matrix4d matrix4d = (Matrix4d)ref1.clone();
        Matrix4d temp2 = (Matrix4d)matrix4d.clone();
        Matrix4d ref2 = sp.superposeAndTransform(pointact, pointref);
        double[][] v = new double[3][4];
        double[] y3 = new double[4];
        double[] z3 = new double[4];
        ref2.getColumn(1, y3);
        ref2.getColumn(2, z3);
        double[] z31 = new double[4];
        ref1.getColumn(2, z31);
        if (z3[0] * z31[0] + z3[1] * z31[1] + z3[2] * z31[2] < 0.0) {
            int i2 = 0;
            while (i2 < 3) {
                int n = i2;
                y3[n] = y3[n] * -1.0;
                int n2 = i2++;
                z3[n2] = z3[n2] * -1.0;
            }
        }
        ref2.setColumn(1, y3);
        ref2.setColumn(2, z3);
        matrix4d.add(ref2);
        matrix4d.mul(0.5);
        double[] x3 = new double[4];
        matrix4d.getColumn(0, x3);
        matrix4d.getColumn(1, y3);
        matrix4d.getColumn(2, z3);
        x3 = BasePairParameters.removeComponent(x3, z3);
        x3 = BasePairParameters.removeComponent(x3, y3);
        y3 = BasePairParameters.removeComponent(y3, z3);
        matrix4d.setColumn(0, x3);
        matrix4d.setColumn(1, y3);
        matrix4d.setColumn(2, z3);
        for (i = 0; i < 3; ++i) {
            matrix4d.getColumn(i, v[i]);
            double r = Math.sqrt(v[i][0] * v[i][0] + v[i][1] * v[i][1] + v[i][2] * v[i][2]);
            int j = 0;
            while (j < 3) {
                double[] dArray = v[i];
                int n = j++;
                dArray[n] = dArray[n] / r;
            }
            matrix4d.setColumn(i, v[i]);
        }
        temp2.invert();
        temp2.mul(ref2);
        this.pairParameters = BasePairParameters.calculateTp(temp2);
        i = 0;
        while (i < 6) {
            int n = i++;
            this.pairParameters[n] = this.pairParameters[n] * -1.0;
        }
        return matrix4d;
    }

    public String toString() {
        if (this.getPairingParameters() == null) {
            return "No data";
        }
        StringBuilder result = new StringBuilder(10000);
        result.append(this.pairingParameters.length + " base pairs\n");
        result.append("bp: buckle propeller opening shear stretch stagger tilt roll twist shift slide rise\n");
        for (int i = 0; i < this.pairingParameters.length; ++i) {
            int j;
            result.append(this.pairingNames.get(i) + ": ");
            for (j = 0; j < 6; ++j) {
                result.append(String.format(Locale.US, "%5.4f", this.pairingParameters[i][j]) + " ");
            }
            for (j = 0; j < 6; ++j) {
                result.append(String.format(Locale.US, "%5.4f", this.stepParameters[i][j]) + " ");
            }
            result.append("\n");
        }
        return result.toString();
    }

    public static double[] calculateTp(Matrix4d input) {
        double[][] A = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                A[i][j] = input.getElement(i, j);
            }
        }
        double[] M = new double[6];
        double cosgamma = A[2][2];
        if (cosgamma > 1.0) {
            cosgamma = 1.0;
        } else if (cosgamma < -1.0) {
            cosgamma = -1.0;
        }
        double gamma = Math.acos(cosgamma);
        double sgcp = A[1][1] * A[0][2] - A[0][1] * A[1][2];
        double omega = gamma == 0.0 ? -Math.atan2(A[0][1], A[1][1]) : Math.atan2(A[2][1] * A[0][2] + sgcp * A[1][2], sgcp * A[0][2] - A[2][1] * A[1][2]);
        double omega2_minus_phi = Math.atan2(A[1][2], A[0][2]);
        double phi = omega / 2.0 - omega2_minus_phi;
        M[0] = gamma * Math.sin(phi) * 180.0 / Math.PI;
        M[1] = gamma * Math.cos(phi) * 180.0 / Math.PI;
        M[2] = omega * 180.0 / Math.PI;
        double sm = Math.sin(omega / 2.0 - phi);
        double cm = Math.cos(omega / 2.0 - phi);
        double sp = Math.sin(phi);
        double cp = Math.cos(phi);
        double sg = Math.sin(gamma / 2.0);
        double cg = Math.cos(gamma / 2.0);
        M[3] = (cm * cg * cp - sm * sp) * A[0][3] + (sm * cg * cp + cm * sp) * A[1][3] - sg * cp * A[2][3];
        M[4] = (-cm * cg * sp - sm * cp) * A[0][3] + (-sm * cg * sp + cm * cp) * A[1][3] + sg * sp * A[2][3];
        M[5] = cm * sg * A[0][3] + sm * sg * A[1][3] + cg * A[2][3];
        return M;
    }

    protected static char complementBase(char base, boolean RNA) {
        if (base == 'A' && RNA) {
            return 'U';
        }
        if (base == 'A') {
            return 'T';
        }
        if (base == 'T' && !RNA) {
            return 'A';
        }
        if (base == 'U' && RNA) {
            return 'A';
        }
        if (base == 'C') {
            return 'G';
        }
        if (base == 'G') {
            return 'C';
        }
        return ' ';
    }

    private static String complement(String sequence, boolean RNA) {
        String result = "";
        for (int i = sequence.length() - 1; i >= 0; --i) {
            result = result + BasePairParameters.complementBase(sequence.charAt(i), RNA);
        }
        return result;
    }

    private static double[] cross(double[] a, double[] b) {
        assert (a.length >= 3 && b.length >= 3);
        double[] result = new double[4];
        result[0] = a[1] * b[2] - a[2] * b[1];
        result[1] = a[2] * b[0] - a[0] * b[2];
        result[2] = a[0] * b[1] - a[1] * b[0];
        return result;
    }

    private static double[] removeComponent(double[] a, double[] b) {
        int i;
        double dot = 0.0;
        double[] result = new double[4];
        for (i = 0; i < 3; ++i) {
            dot += a[i] * b[i];
        }
        for (i = 0; i < 3; ++i) {
            result[i] = a[i] - dot * b[i];
        }
        return result;
    }

    private static String longestCommonSubstring(String s1, String s2) {
        int start = 0;
        int max = 0;
        for (int i = 0; i < s1.length(); ++i) {
            for (int j = 0; j < s2.length(); ++j) {
                int x = 0;
                while (s1.charAt(i + x) == s2.charAt(j + x) && i + ++x < s1.length() && j + x < s2.length()) {
                }
                if (x <= max) continue;
                max = x;
                start = i;
            }
        }
        return s1.substring(start, start + max);
    }

    protected static boolean match(char a, char b, boolean RNA) {
        if (a == 'A' && b == 'T' && !RNA) {
            return true;
        }
        if (a == 'A' && b == 'U' && RNA) {
            return true;
        }
        if (a == 'T' && b == 'A' && !RNA) {
            return true;
        }
        if (a == 'U' && b == 'A' && RNA) {
            return true;
        }
        if (a == 'G' && b == 'C') {
            return true;
        }
        return a == 'C' && b == 'G';
    }

    static {
        BASE_MAP.put("DA", 0);
        BASE_MAP.put("ADE", 0);
        BASE_MAP.put("A", 0);
        BASE_MAP.put("DG", 1);
        BASE_MAP.put("GUA", 1);
        BASE_MAP.put("G", 1);
        BASE_MAP.put("DT", 2);
        BASE_MAP.put("THY", 2);
        BASE_MAP.put("T", 2);
        BASE_MAP.put("U", 2);
        BASE_MAP.put("URA", 2);
        BASE_MAP.put("DC", 3);
        BASE_MAP.put("CYT", 3);
        BASE_MAP.put("C", 3);
        RING_MAP = new HashMap<Integer, List<String>>();
        RING_MAP.put(0, Arrays.asList("C8", "C2", "N3", "C4", "C5", "C6", "N7", "N1", "N9"));
        RING_MAP.put(1, Arrays.asList("C8", "C2", "N3", "C4", "C5", "C6", "N7", "N1", "N9"));
        RING_MAP.put(2, Arrays.asList("C6", "C2", "N3", "C4", "C5", "N1"));
        RING_MAP.put(3, Arrays.asList("C6", "C2", "N3", "C4", "C5", "N1"));
    }
}

