/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.multiple.util;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.multiple.Block;
import org.biojava.nbio.structure.align.multiple.BlockSet;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.util.MultipleSuperimposer;
import org.biojava.nbio.structure.geometry.SuperPositions;

public class ReferenceSuperimposer
implements MultipleSuperimposer {
    private int reference;

    public ReferenceSuperimposer() {
        this(0);
    }

    public ReferenceSuperimposer(int reference) {
        if (reference < 0) {
            throw new IllegalArgumentException("reference index has to be positive, but was " + reference);
        }
        this.reference = reference;
    }

    @Override
    public void superimpose(MultipleAlignment alignment) throws StructureException {
        if (alignment.getEnsemble() == null) {
            throw new NullPointerException("No ensemble set for this alignment. Structure information cannot be obtained.");
        }
        if (alignment.size() < 1) {
            throw new IndexOutOfBoundsException("No aligned structures, alignment size == 0.");
        }
        if (alignment.getCoreLength() < 1) {
            throw new IndexOutOfBoundsException("Alignment too short, core alignment length < 1.");
        }
        List<Atom[]> atomArrays = alignment.getAtomArrays();
        if (atomArrays.size() <= this.reference) {
            throw new IndexOutOfBoundsException(String.format("Invalid reference structure: requested %d but only %d structures.", this.reference, atomArrays.size()));
        }
        alignment.clear();
        for (BlockSet bs : alignment.getBlockSets()) {
            ArrayList<Matrix4d> transforms = new ArrayList<Matrix4d>(atomArrays.size());
            for (int i = 0; i < atomArrays.size(); ++i) {
                if (i == this.reference) {
                    Matrix4d ident = new Matrix4d();
                    ident.setIdentity();
                    transforms.add(ident);
                    continue;
                }
                Atom[] ref = atomArrays.get(this.reference);
                Atom[] curr = atomArrays.get(i);
                ArrayList<Atom> atomSet1 = new ArrayList<Atom>();
                ArrayList<Atom> atomSet2 = new ArrayList<Atom>();
                for (Block blk : bs.getBlocks()) {
                    if (blk.size() != atomArrays.size()) {
                        throw new IllegalStateException(String.format("Mismatched block length. Expected %d structures, found %d.", atomArrays.size(), blk.size()));
                    }
                    for (int j = 0; j < blk.length(); ++j) {
                        Integer pos1 = blk.getAlignRes().get(this.reference).get(j);
                        Integer pos2 = blk.getAlignRes().get(i).get(j);
                        if (pos1 == null || pos2 == null) continue;
                        atomSet1.add(ref[pos1]);
                        atomSet2.add(curr[pos2]);
                    }
                }
                Atom[] array1 = atomSet1.toArray(new Atom[atomSet1.size()]);
                Atom[] array2 = atomSet2.toArray(new Atom[atomSet2.size()]);
                array2 = StructureTools.cloneAtomArray(array2);
                Matrix4d trans = SuperPositions.superpose(Calc.atomsToPoints(array1), Calc.atomsToPoints(array2));
                transforms.add(trans);
            }
            bs.setTransformations(transforms);
        }
    }
}

