/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.fatcat.calc;

import org.biojava.nbio.structure.align.fatcat.calc.FatCatParameters;
import org.biojava.nbio.structure.align.model.AFPChain;

public class SigEva {
    double mu;
    double beta;
    double mu_a;
    double beta_a;
    double mu_b;
    double beta_b;

    public SigEva() {
        this.getPara(3, 0);
    }

    public void getPara(int set, int len) {
        if (set == 1) {
            this.mu_a = 0.2461;
            this.mu_b = 17.153;
            this.beta_a = 0.1284;
            this.beta_b = 1.3756;
        } else if (set == 2) {
            this.mu_a = 1.1137;
            this.mu_b = 6.5574;
            this.beta_a = 0.6448;
            this.beta_b = -12.2793;
        } else if (set == 3) {
            this.mu_a = 0.844;
            this.mu_b = 30.216;
            this.beta_a = 0.3525;
            this.beta_b = 18.6652;
        } else if (set == 4) {
            this.mu_a = 0.4708;
            this.mu_b = 38.9863;
            this.beta_a = 0.2511;
            this.beta_b = 12.9228;
        } else if (set == 5) {
            this.mu_a = 1.3794;
            this.mu_b = -14.4778;
            this.beta_a = 0.7465;
            this.beta_b = -22.9452;
        } else if (set == 6) {
            this.mu_a = 0.6036;
            this.mu_b = 35.4783;
            this.beta_a = 0.3136;
            this.beta_b = 13.3922;
        } else if (set == 7) {
            this.mu_a = 0.7183;
            this.mu_b = 27.9647;
            this.beta_a = 0.4688;
            this.beta_b = -1.3293;
        } else if (set == 8) {
            this.mu_a = 0.4813;
            this.mu_b = 34.2051;
            this.beta_a = 0.2618;
            this.beta_b = 12.4581;
        } else if (set == 9) {
            this.mu_a = 0.6672;
            this.mu_b = 26.5767;
            this.beta_a = 0.4373;
            this.beta_b = -1.4017;
        } else {
            System.err.println("no corresponding parameter set found!");
        }
        this.beta = 0.0;
        this.mu = 0.0;
        this.calMu(len);
        this.calBeta(len);
    }

    private void calMu(int len) {
        this.mu = this.mu_a * (double)len + this.mu_b;
    }

    private void calBeta(int len) {
        this.beta = this.beta_a * (double)len + this.beta_b;
    }

    private int aveLen(int len1, int len2) {
        int len = (int)(0.5 * (double)(len1 + len2));
        return len;
    }

    public double calSigAll(FatCatParameters params, AFPChain afpChain) {
        int twist = params.getMaxTra();
        int sparse = params.getSparse();
        int len1 = afpChain.getCa1Length();
        int len2 = afpChain.getCa2Length();
        double score = afpChain.getAlignScore();
        double rmsd = afpChain.getTotalRmsdOpt();
        int optLen = afpChain.getOptLength();
        int r = afpChain.getBlockNum() - 1;
        return this.calSigAll(twist, sparse, len1, len2, score, rmsd, optLen, r);
    }

    private double calSigAll(int twist, int sparse, int len1, int len2, double score, double rmsd, int optLen, int r) {
        int len = this.aveLen(len1, len2);
        if (sparse == 2) {
            if (twist == 0) {
                this.getPara(4, len);
            } else {
                this.getPara(5, len);
            }
        } else if (sparse == 3) {
            if (twist == 0) {
                this.getPara(8, len);
            } else {
                this.getPara(8, len);
            }
        } else if (sparse == 1) {
            if (twist == 0) {
                this.getPara(6, len);
            } else {
                this.getPara(7, len);
            }
        } else if (twist == 0) {
            this.getPara(2, len);
        } else {
            this.getPara(3, len);
        }
        double mods = this.normScore(score, rmsd, optLen, r);
        double t = (mods - this.mu) / this.beta;
        double sf = this.sF(t);
        return sf;
    }

    private double sF(double t) {
        return 1.0 - this.cDF(t);
    }

    private double cDF(double t) {
        return Math.exp(-Math.exp(-t));
    }

    private double normScore(double score, double rmsd, int optLen, int r) {
        double score1 = score;
        if (r > 0) {
            score1 /= Math.sqrt(r + 1);
        }
        score1 = rmsd < 0.5 ? (score1 *= Math.sqrt((double)optLen / 0.5)) : (score1 *= Math.sqrt((double)optLen / rmsd));
        return score1;
    }

    public double calNS(FatCatParameters params, AFPChain afpChain) {
        int len1 = afpChain.getCa1Length();
        int len2 = afpChain.getCa2Length();
        double score = afpChain.getAlignScore();
        double rmsd = afpChain.getTotalRmsdOpt();
        int optLen = afpChain.getOptLength();
        int r = afpChain.getBlockNum() - 1;
        return this.calNS(len1, len2, score, rmsd, optLen, r);
    }

    private double calNS(int len1, int len2, double score, double rmsd, int optlen, int r) {
        int len = this.aveLen(len1, len2);
        this.getPara(3, len);
        double ns0 = this.normScore(score, rmsd, optlen, r);
        double ns1 = (ns0 - this.mu) / this.beta;
        return ns1;
    }
}

