/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.ce;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureTools;
import org.biojava.nbio.structure.align.ce.CeCPMain;
import org.biojava.nbio.structure.align.ce.CeMain;
import org.biojava.nbio.structure.align.ce.CeParameters;
import org.biojava.nbio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.nbio.structure.align.ce.GuiWrapper;
import org.biojava.nbio.structure.align.ce.OptimalCECPParameters;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.util.AFPChainScorer;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.jama.Matrix;

public class OptimalCECPMain
extends CeMain {
    private static final boolean debug = true;
    public static final String algorithmName = "jCE Optimal Circular Permutation";
    public static final String version = "1.0";
    protected OptimalCECPParameters params = new OptimalCECPParameters();

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public ConfigStrucAligParams getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(ConfigStrucAligParams params) {
        if (!(params instanceof OptimalCECPParameters)) {
            throw new IllegalArgumentException("provided parameter object is not of type CeParameter");
        }
        this.params = (OptimalCECPParameters)params;
    }

    private static <T> void permuteArray(T[] arr, int cp) {
        int i;
        if (cp == 0) {
            return;
        }
        if (cp < 0) {
            cp = arr.length + cp;
        }
        if (cp < 0 || cp >= arr.length) {
            throw new ArrayIndexOutOfBoundsException("Permutation point (" + cp + ") must be between -ca2.length and ca2.length-1");
        }
        ArrayList<T> temp = new ArrayList<T>(cp);
        for (i = 0; i < cp; ++i) {
            temp.add(arr[i]);
        }
        for (int j = cp; j < arr.length; ++j) {
            arr[j - cp] = arr[j];
        }
        for (i = 0; i < cp; ++i) {
            arr[arr.length - cp + i] = temp.get(i);
        }
    }

    public AFPChain alignPermuted(Atom[] ca1, Atom[] ca2, Object param, int cp) throws StructureException {
        OptimalCECPMain.permuteArray(ca2, cp);
        AFPChain afpChain = super.align(ca1, ca2, param);
        OptimalCECPMain.permuteAFPChain(afpChain, -cp);
        if (afpChain.getName2() != null) {
            afpChain.setName2(afpChain.getName2() + " CP=" + cp);
        }
        return afpChain;
    }

    private static void permuteAFPChain(AFPChain afpChain, int cp) {
        int ca2len = afpChain.getCa2Length();
        if (cp == 0) {
            return;
        }
        if (cp < 0) {
            cp = ca2len + cp;
        }
        if (cp < 0 || cp >= ca2len) {
            throw new ArrayIndexOutOfBoundsException("Permutation point (" + cp + ") must be between -ca2.length and ca2.length-1");
        }
        OptimalCECPMain.permuteOptAln(afpChain, cp);
        if (afpChain.getBlockNum() > 1) {
            afpChain.setSequentialAlignment(false);
        }
        afpChain.setDistanceMatrix(OptimalCECPMain.permuteMatrix(afpChain.getDistanceMatrix(), 0, -cp));
        afpChain.setDisTable2(OptimalCECPMain.permuteMatrix(afpChain.getDisTable2(), -cp, -cp));
    }

    private static Matrix permuteMatrix(Matrix mat, int cpRows, int cpCols) {
        if (cpRows == 0 && cpCols == 0) {
            return mat.copy();
        }
        if (cpRows < 0) {
            cpRows = mat.getRowDimension() + cpRows;
        }
        if (cpRows < 0 || cpRows >= mat.getRowDimension()) {
            throw new ArrayIndexOutOfBoundsException(String.format("Can't permute rows by %d: only %d rows.", cpRows, mat.getRowDimension()));
        }
        if (cpCols < 0) {
            cpCols = mat.getColumnDimension() + cpCols;
        }
        if (cpCols < 0 || cpCols >= mat.getColumnDimension()) {
            throw new ArrayIndexOutOfBoundsException(String.format("Can't permute cols by %d: only %d rows.", cpCols, mat.getColumnDimension()));
        }
        int[] rows = new int[mat.getRowDimension()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = (i + cpRows) % rows.length;
        }
        int[] cols = new int[mat.getColumnDimension()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = (i + cpCols) % cols.length;
        }
        Matrix newMat = mat.getMatrix(rows, cols);
        assert (newMat.getRowDimension() == mat.getRowDimension());
        assert (newMat.getColumnDimension() == mat.getColumnDimension());
        assert (newMat.get(0, 0) == mat.get(cpRows % mat.getRowDimension(), cpCols % mat.getColumnDimension()));
        return newMat;
    }

    private static void permuteOptAln(AFPChain afpChain, int cp) {
        int ca2len = afpChain.getCa2Length();
        if (ca2len <= 0) {
            throw new IllegalArgumentException("No Ca2Length specified in " + afpChain);
        }
        if (cp == 0) {
            return;
        }
        if (cp <= -ca2len || cp >= ca2len) {
            throw new ArrayIndexOutOfBoundsException(String.format("Permutation point %d must be between %d and %d for %s", cp, 1 - ca2len, ca2len - 1, afpChain.getName2()));
        }
        if (cp < 0) {
            cp += ca2len;
        }
        int[][][] optAln = afpChain.getOptAln();
        int[] optLen = afpChain.getOptLen();
        ArrayList<List<List<Integer>>> blocks = new ArrayList<List<List<Integer>>>(afpChain.getBlockNum() * 2);
        for (int block = 0; block < afpChain.getBlockNum(); ++block) {
            if (optLen[block] < 1) continue;
            ArrayList currBlock = new ArrayList(2);
            currBlock.add(new ArrayList());
            currBlock.add(new ArrayList());
            blocks.add(currBlock);
            ((List)currBlock.get(0)).add(optAln[block][0][0]);
            ((List)currBlock.get(1)).add((optAln[block][1][0] + cp) % ca2len);
            for (int pos = 1; pos < optLen[block]; ++pos) {
                if (optAln[block][1][pos - 1] + cp < ca2len && optAln[block][1][pos] + cp >= ca2len) {
                    currBlock = new ArrayList(2);
                    currBlock.add(new ArrayList());
                    currBlock.add(new ArrayList());
                    blocks.add(currBlock);
                }
                ((List)currBlock.get(0)).add(optAln[block][0][pos]);
                ((List)currBlock.get(1)).add((optAln[block][1][pos] + cp) % ca2len);
            }
        }
        OptimalCECPMain.assignOptAln(afpChain, blocks);
    }

    private static void assignOptAln(AFPChain afpChain, List<List<List<Integer>>> blocks) {
        int[][][] optAln = new int[blocks.size()][][];
        int[] optLen = new int[blocks.size()];
        int optLength = 0;
        int numBlocks = blocks.size();
        for (int block = 0; block < numBlocks; ++block) {
            assert (blocks.get(block).size() == 2);
            assert (blocks.get(block).get(0).size() == blocks.get(block).get(1).size());
            optLen[block] = blocks.get(block).get(0).size();
            optLength += optLen[block];
            optAln[block] = new int[][]{new int[optLen[block]], new int[optLen[block]]};
            for (int pos = 0; pos < optLen[block]; ++pos) {
                optAln[block][0][pos] = blocks.get(block).get(0).get(pos);
                optAln[block][1][pos] = blocks.get(block).get(1).get(pos);
            }
        }
        afpChain.setBlockNum(numBlocks);
        afpChain.setOptAln(optAln);
        afpChain.setOptLen(optLen);
        afpChain.setOptLength(optLength);
    }

    @Override
    public AFPChain align(Atom[] ca1, Atom[] ca2, Object param) throws StructureException {
        if (this.params.isTryAllCPs().booleanValue()) {
            return this.alignOptimal(ca1, ca2, param, null);
        }
        int cpPoint = this.params.getCPPoint();
        return this.alignPermuted(ca1, ca2, param, cpPoint);
    }

    public AFPChain alignOptimal(Atom[] ca1, Atom[] ca2, Object param, AFPChain[] alignments) throws StructureException {
        int cp;
        AFPChain unaligned;
        long startTime = System.currentTimeMillis();
        if (alignments != null && alignments.length != ca2.length) {
            throw new IllegalArgumentException("scores param should have same length as ca2");
        }
        AFPChain bestAlignment = unaligned = super.align(ca1, ca2, param);
        System.out.print("|");
        for (cp = 1; cp < ca2.length - 1; ++cp) {
            System.out.print("=");
        }
        System.out.println("|");
        System.out.print(".");
        if (alignments != null) {
            alignments[0] = unaligned;
        }
        for (cp = 1; cp < ca2.length; ++cp) {
            Atom[] ca2p = StructureTools.cloneAtomArray(ca2);
            AFPChain currentAlignment = this.alignPermuted(ca1, ca2p, param, cp);
            System.out.print(".");
            if (ca2.length != 0 && ca2[0].getGroup().getChain() != null && ca2[0].getGroup().getChain().getStructure() != null) {
                currentAlignment.setName2(ca2[0].getGroup().getChain().getStructure().getName() + " CP=" + cp);
            }
            double currentScore = currentAlignment.getAlignScore();
            if (alignments != null) {
                alignments[cp] = currentAlignment;
            }
            if (!(currentScore > bestAlignment.getAlignScore())) continue;
            bestAlignment = currentAlignment;
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        System.out.println();
        System.out.format("%d alignments took %.4f s (%.1f ms avg)\n", ca2.length, (double)elapsedTime / 1000.0, (double)elapsedTime / (double)ca2.length);
        return bestAlignment;
    }

    public static void main(String[] args) {
        try {
            String name1 = "d1qdmA1";
            String name2 = "d1nklA_";
            name2 = "2LSQ";
            name1 = "2LSQ";
            OptimalCECPMain ce = new OptimalCECPMain();
            CeParameters params = (CeParameters)ce.getParameters();
            ce.setParameters(params);
            AtomCache cache = new AtomCache();
            Atom[] ca1 = cache.getAtoms(name1);
            Atom[] ca2 = cache.getAtoms(name2);
            AFPChain[] alignments = new AFPChain[ca2.length];
            AFPChain afpChain = ce.alignOptimal(ca1, ca2, params, alignments);
            System.out.format("Optimal Score: %.2f\n", afpChain.getAlignScore());
            System.out.println("Pos\tScore\tTMScore\tLen\tRMSD\tBlocks");
            for (int i = 0; i < alignments.length; ++i) {
                double tm = AFPChainScorer.getTMScore(alignments[i], ca1, ca2);
                System.out.format("%d\t%.2f\t%.2f\t%d\t%.2f\t%d\n", i, alignments[i].getAlignScore(), tm, alignments[i].getOptLength(), alignments[i].getTotalRmsdOpt(), alignments[i].getBlockNum());
            }
            CeCPMain cecp = new CeCPMain();
            afpChain = cecp.align(ca1, ca2);
            OptimalCECPMain.displayAlignment(afpChain, ca1, ca2);
            System.out.println("Inspect additional alignments?");
            Scanner scanner = new Scanner(System.in);
            System.out.print("CP location [0," + ca2.length + "): ");
            while (scanner.hasNext()) {
                int cp;
                if (scanner.hasNextInt() && 0 <= (cp = scanner.nextInt()) && cp < ca2.length) {
                    alignments[cp].setName1(name1);
                    alignments[cp].setName2(name2 + "@" + cp);
                    OptimalCECPMain.displayAlignment(alignments[cp], ca1, ca2);
                    Thread.sleep(1000L);
                }
                System.out.print("CP location [0," + ca2.length + "): ");
            }
            scanner.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void displayAlignment(AFPChain afpChain, Atom[] ca1, Atom[] ca2) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, StructureException {
        Atom[] ca1clone = StructureTools.cloneAtomArray(ca1);
        Atom[] ca2clone = StructureTools.cloneAtomArray(ca2);
        if (!GuiWrapper.isGuiModuleInstalled()) {
            System.err.println("The biojava-structure-gui and/or JmolApplet modules are not installed. Please install!");
            System.out.println(afpChain.toCE(ca1clone, ca2clone));
        } else {
            Object jmol = GuiWrapper.display(afpChain, ca1clone, ca2clone);
            GuiWrapper.showAlignmentImage(afpChain, ca1clone, ca2clone, jmol);
        }
    }
}

