/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.util;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.io.FastaReaderHelper;
import org.biojava.nbio.core.sequence.io.FastaWriterHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitFasta {
    private static final Logger logger = LoggerFactory.getLogger(SplitFasta.class);

    public void processNucleotides(File fastaFileName, String uniqueid, File outputDirectory) throws Exception {
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        LinkedHashMap dnaSequenceHashMap = FastaReaderHelper.readFastaDNASequence((File)fastaFileName);
        for (DNASequence dnaSequence : dnaSequenceHashMap.values()) {
            String fileName = outputDirectory.getAbsolutePath() + File.separatorChar;
            fileName = uniqueid.length() > 0 ? fileName + dnaSequence.getAccession().getID() + ".fna" : fileName + uniqueid + dnaSequence.getAccession().getID() + ".fna";
            ArrayList<DNASequence> dnaList = new ArrayList<DNASequence>();
            dnaList.add(dnaSequence);
            FastaWriterHelper.writeNucleotideSequence((File)new File(fileName), dnaList);
        }
    }

    public static void main(String[] args) {
        try {
            SplitFasta splitFasta = new SplitFasta();
            splitFasta.processNucleotides(new File("/Users/Scooter/scripps/dyadic/analysis/454Scaffolds/454Scaffolds.fna"), "", new File("/Users/Scooter/scripps/dyadic/analysis/454Scaffolds/individual"));
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }
}

