/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.util;

import com.google.common.collect.Range;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.core.sequence.DNASequence;
import org.biojava.nbio.core.sequence.template.SequenceView;
import org.biojava.nbio.genome.parsers.genename.ChromPos;
import org.biojava.nbio.genome.parsers.genename.GeneChromosomePosition;
import org.biojava.nbio.genome.parsers.twobit.TwoBitFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromosomeMappingTools {
    private static final Logger logger = LoggerFactory.getLogger(ChromosomeMappingTools.class);
    private static final String newline = System.getProperty("line.separator");
    public static final String CHROMOSOME = "CHROMOSOME";
    public static final String CDS = "CDS";
    private static int base = 1;

    public static void setCoordinateSystem(int baseInt) {
        base = baseInt;
    }

    public static String formatExonStructure(GeneChromosomePosition chromosomePosition) {
        if (chromosomePosition.getOrientation().charValue() == '+') {
            return ChromosomeMappingTools.formatExonStructureForward(chromosomePosition);
        }
        return ChromosomeMappingTools.formatExonStructureReverse(chromosomePosition);
    }

    private static String formatExonStructureForward(GeneChromosomePosition chromPos) {
        StringWriter s = new StringWriter();
        List<Integer> exonStarts = chromPos.getExonStarts();
        List<Integer> exonEnds = chromPos.getExonEnds();
        int cdsStart = chromPos.getCdsStart();
        int cdsEnd = chromPos.getCdsEnd();
        boolean inCoding = false;
        int codingLength = 0;
        for (int i = 0; i < exonStarts.size(); ++i) {
            int start = exonStarts.get(i);
            int end = exonEnds.get(i);
            if (start <= cdsStart + 1 && end >= cdsStart + 1) {
                inCoding = true;
                s.append("     UTR         : ").append(ChromosomeMappingTools.format(start)).append(" - ").append(ChromosomeMappingTools.format(cdsStart));
                s.append(newline);
                s.append(" ->  Exon        : ").append(ChromosomeMappingTools.format(cdsStart + 1)).append(" - ").append(ChromosomeMappingTools.format(end)).append(" | ").append(Integer.toString(end - cdsStart)).append(" | ").append(Integer.toString(codingLength += end - cdsStart)).append(" | ").append(Integer.toString(codingLength % 3));
                s.append(newline);
                continue;
            }
            if (start <= cdsEnd && end >= cdsEnd) {
                inCoding = false;
                s.append(" <-  Exon        : ").append(ChromosomeMappingTools.format(start + 1)).append(" - ").append(ChromosomeMappingTools.format(cdsEnd)).append(" | ").append(Integer.toString(cdsEnd - start)).append(" | ").append(Integer.toString(codingLength += cdsEnd - start)).append(" | ").append(Integer.toString(codingLength % 3));
                s.append(newline);
                s.append("     UTR         : " + (cdsEnd + 1) + " - " + ChromosomeMappingTools.format(end));
                s.append(newline);
                continue;
            }
            if (!inCoding) continue;
            s.append("     Exon        : ").append(ChromosomeMappingTools.format(start + 1)).append(" - ").append(ChromosomeMappingTools.format(end)).append(" | ").append(Integer.toString(end - start)).append(" | ").append(Integer.toString(codingLength += end - start)).append(" | ").append(Integer.toString(codingLength % 3));
            s.append(newline);
        }
        s.append("Coding Length: ");
        s.append(codingLength - 3 + "");
        s.append(newline);
        return s.toString();
    }

    private static String formatExonStructureReverse(GeneChromosomePosition chromPos) {
        StringWriter s = new StringWriter();
        List<Integer> exonStarts = chromPos.getExonStarts();
        List<Integer> exonEnds = chromPos.getExonEnds();
        int cdsStart = chromPos.getCdsStart();
        int cdsEnd = chromPos.getCdsEnd();
        boolean inCoding = false;
        int codingLength = 0;
        if (cdsEnd < cdsStart) {
            int tmp = cdsEnd;
            cdsEnd = cdsStart;
            cdsStart = tmp;
        }
        for (int i = exonStarts.size() - 1; i >= 0; --i) {
            int start;
            int end = exonStarts.get(i);
            if (end < (start = exonEnds.get(i).intValue())) {
                int tmp = end;
                end = start;
                start = tmp;
            }
            if (start <= cdsEnd && end >= cdsEnd) {
                inCoding = true;
                int tmpstart = start;
                if (start < cdsStart) {
                    tmpstart = cdsStart;
                }
                codingLength += cdsEnd - tmpstart;
                s.append("     UTR         :" + ChromosomeMappingTools.format(cdsEnd + 1) + " | " + ChromosomeMappingTools.format(end));
                s.append(newline);
                if (tmpstart == start) {
                    s.append(" ->  ");
                } else {
                    s.append(" <-> ");
                }
                s.append("Exon        :").append(ChromosomeMappingTools.format(tmpstart + 1)).append(" - ").append(ChromosomeMappingTools.format(cdsEnd)).append(" | ").append(Integer.toString(cdsEnd - tmpstart)).append(" | ").append(Integer.toString(codingLength)).append(" | ").append(Integer.toString(codingLength % 3));
                s.append(newline);
                if (tmpstart != start) {
                    s.append("     UTR         :" + ChromosomeMappingTools.format(cdsStart) + " - " + ChromosomeMappingTools.format(start + 1));
                }
                s.append(newline);
                continue;
            }
            if (start <= cdsStart && end >= cdsStart) {
                inCoding = false;
                s.append(" <-  Exon        : " + ChromosomeMappingTools.format(cdsStart + 1) + " - " + ChromosomeMappingTools.format(end) + " | " + (end - cdsStart) + " | " + (codingLength += end - cdsStart) + " | " + codingLength % 3);
                s.append(newline);
                s.append("     UTR         : " + ChromosomeMappingTools.format(start + 1) + " - " + ChromosomeMappingTools.format(cdsStart));
                s.append(newline);
                continue;
            }
            if (inCoding) {
                s.append("     Exon        : " + ChromosomeMappingTools.format(start + 1) + " - " + ChromosomeMappingTools.format(end) + " | " + (end - start) + " | " + (codingLength += end - start) + " | " + codingLength % 3);
                s.append(newline);
                continue;
            }
            s.append(" no translation! UTR: ").append(ChromosomeMappingTools.format(start)).append(" - ").append(ChromosomeMappingTools.format(end));
            s.append(newline);
        }
        s.append("CDS length: ").append(Integer.toString(codingLength - 3));
        s.append(newline);
        return s.toString();
    }

    public static int getCDSLength(GeneChromosomePosition chromPos) {
        List<Integer> exonStarts = chromPos.getExonStarts();
        List<Integer> exonEnds = chromPos.getExonEnds();
        int cdsStart = chromPos.getCdsStart();
        int cdsEnd = chromPos.getCdsEnd();
        int codingLength = chromPos.getOrientation().equals(Character.valueOf('+')) ? ChromosomeMappingTools.getCDSLengthForward(exonStarts, exonEnds, cdsStart, cdsEnd) : ChromosomeMappingTools.getCDSLengthReverse(exonStarts, exonEnds, cdsStart, cdsEnd);
        return codingLength;
    }

    public static ChromPos getChromosomePosForCDScoordinate(int cdsNucleotidePosition, GeneChromosomePosition chromPos) {
        logger.debug(" ? Checking chromosome position for CDS position " + cdsNucleotidePosition);
        List<Integer> exonStarts = chromPos.getExonStarts();
        List<Integer> exonEnds = chromPos.getExonEnds();
        logger.debug(" Exons:" + exonStarts.size());
        int cdsStart = chromPos.getCdsStart();
        int cdsEnd = chromPos.getCdsEnd();
        ChromPos chromosomePos = null;
        chromosomePos = chromPos.getOrientation().equals(Character.valueOf('+')) ? ChromosomeMappingTools.getChromPosForward(cdsNucleotidePosition, exonStarts, exonEnds, cdsStart, cdsEnd) : ChromosomeMappingTools.getChromPosReverse(cdsNucleotidePosition, exonStarts, exonEnds, cdsStart, cdsEnd);
        logger.debug("=> CDS pos " + cdsNucleotidePosition + " for " + chromPos.getGeneName() + " is on chromosome at  " + chromosomePos);
        return chromosomePos;
    }

    private static String format(int chromosomePosition) {
        return String.format("%,d", chromosomePosition);
    }

    public static ChromPos getChromPosReverse(int cdsPos, List<Integer> exonStarts, List<Integer> exonEnds, int cdsStart, int cdsEnd) {
        boolean inCoding = false;
        int codingLength = 0;
        if (cdsEnd < cdsStart) {
            int tmp = cdsEnd;
            cdsEnd = cdsStart;
            cdsStart = tmp;
        }
        int lengthExons = 0;
        for (int i = exonStarts.size() - 1; i >= 0; --i) {
            int tmp;
            logger.debug("Exon #" + (i + 1) + "/" + exonStarts.size());
            int end = exonStarts.get(i);
            int start = exonEnds.get(i);
            if (end < start) {
                tmp = end;
                end = start;
                start = tmp;
            }
            lengthExons += end - start;
            logger.debug("     is " + cdsPos + " part of Reverse exon? " + ChromosomeMappingTools.format(start + 1) + " - " + ChromosomeMappingTools.format(end) + " | " + (end - start + 1));
            logger.debug("     CDS start: " + ChromosomeMappingTools.format(cdsStart + 1) + "-" + ChromosomeMappingTools.format(cdsEnd) + " coding length counter:" + codingLength);
            if (start + 1 <= cdsEnd && end >= cdsEnd) {
                inCoding = true;
                int tmpstart = start;
                if (start < cdsStart) {
                    tmpstart = cdsStart;
                }
                int check = codingLength + cdsEnd - tmpstart;
                logger.debug("First Exon    | " + check + " | " + ChromosomeMappingTools.format(start + 1) + " " + ChromosomeMappingTools.format(end) + " | " + (cdsEnd - tmpstart) + " | " + cdsPos);
                if (check > cdsPos) {
                    int tmp2 = cdsPos - codingLength;
                    logger.debug(" -> found position in UTR exon:  " + ChromosomeMappingTools.format(cdsPos) + " " + ChromosomeMappingTools.format(tmpstart + 1) + " tmp:" + ChromosomeMappingTools.format(tmp2) + " cs:" + ChromosomeMappingTools.format(cdsStart + 1) + " ce:" + ChromosomeMappingTools.format(cdsEnd) + " cl:" + codingLength);
                    return new ChromPos(cdsEnd - tmp2, -1);
                }
                codingLength += cdsEnd - tmpstart;
                boolean debug = logger.isDebugEnabled();
                if (debug) {
                    StringBuffer b = new StringBuffer();
                    b.append("     UTR         :" + ChromosomeMappingTools.format(cdsEnd + 1) + " - " + ChromosomeMappingTools.format(end) + newline);
                    if (tmpstart == start) {
                        b.append(" ->  ");
                    } else {
                        b.append(" <-> ");
                    }
                    b.append("Exon        :" + ChromosomeMappingTools.format(tmpstart + 1) + " - " + cdsEnd + " | " + ChromosomeMappingTools.format(cdsEnd - tmpstart + 1) + " - " + codingLength + " | " + codingLength % 3 + newline);
                    if (tmpstart != start) {
                        b.append("     UTR         :" + ChromosomeMappingTools.format(cdsStart) + " - " + ChromosomeMappingTools.format(start + 1) + newline);
                    }
                    logger.debug(b.toString());
                }
            } else if (start <= cdsStart && end >= cdsStart) {
                inCoding = false;
                if (codingLength + end - cdsStart >= cdsPos) {
                    tmp = codingLength + end - cdsStart - cdsPos;
                    logger.debug("cdl: " + codingLength + " tmp:" + tmp + " cdsStart: " + ChromosomeMappingTools.format(cdsStart));
                    logger.debug(" -> XXX found position noncoding exon:  cdsPos:" + cdsPos + " s:" + ChromosomeMappingTools.format(start + 1) + " tmp:" + ChromosomeMappingTools.format(tmp) + " cdsStart:" + (cdsStart + 1) + " codingLength:" + codingLength + " cdsEnd:" + ChromosomeMappingTools.format(cdsEnd));
                    return new ChromPos(cdsStart + tmp, -1);
                }
                logger.debug(" <-  Exon        : " + ChromosomeMappingTools.format(cdsStart + 1) + " - " + ChromosomeMappingTools.format(end) + " | " + ChromosomeMappingTools.format(end - cdsStart + 1) + " | " + (codingLength += end - cdsStart) + " | " + codingLength % 3);
                logger.debug("     UTR         : " + ChromosomeMappingTools.format(start + 1) + " - " + ChromosomeMappingTools.format(cdsStart));
            } else if (inCoding) {
                if (codingLength + end - start - 1 >= cdsPos) {
                    tmp = cdsPos - codingLength;
                    if (tmp > end - start) {
                        tmp = end - start;
                        logger.debug("changing tmp to " + tmp);
                    }
                    logger.debug("     " + cdsPos + " " + codingLength + " | " + (cdsPos - codingLength) + " | " + (end - start) + " | " + tmp);
                    logger.debug("     Exon        : " + ChromosomeMappingTools.format(start + 1) + " - " + ChromosomeMappingTools.format(end) + " | " + ChromosomeMappingTools.format(end - start) + " | " + codingLength + " | " + codingLength % 3);
                    logger.debug(" ->  RRR found position coding exon:  " + cdsPos + " " + ChromosomeMappingTools.format(start + 1) + " " + ChromosomeMappingTools.format(end) + " " + tmp + " " + ChromosomeMappingTools.format(cdsStart + 1) + " " + codingLength);
                    return new ChromPos(end - tmp, cdsPos % 3);
                }
                logger.debug("     Exon        : " + ChromosomeMappingTools.format(start + 1) + " - " + ChromosomeMappingTools.format(end) + " | " + ChromosomeMappingTools.format(end - start + 1) + " | " + (codingLength += end - start) + " | " + codingLength % 3);
            } else {
                logger.debug(" no translation!");
            }
            logger.debug("     coding length: " + codingLength + "(phase:" + codingLength % 3 + ") CDS POS trying to map:" + cdsPos);
        }
        logger.debug("length exons: " + lengthExons);
        return new ChromPos(-1, -1);
    }

    public static ChromPos getChromPosForward(int cdsPos, List<Integer> exonStarts, List<Integer> exonEnds, int cdsStart, int cdsEnd) {
        boolean inCoding = false;
        int codingLength = 0;
        int lengthExons = 0;
        for (int i = 0; i < exonStarts.size(); ++i) {
            int start = exonStarts.get(i);
            int end = exonEnds.get(i);
            lengthExons += end - start;
            if (start <= cdsStart + 1 && end >= cdsStart + 1) {
                if (codingLength + (end - cdsStart - 1) >= cdsPos) {
                    int tmp = cdsPos - codingLength;
                    logger.debug(cdsStart + " | " + codingLength + " | " + tmp);
                    logger.debug(" -> found position in UTR exon:  #" + (i + 1) + " cdsPos:" + cdsPos + " return:" + (cdsStart + 1 + tmp) + " start:" + ChromosomeMappingTools.format(start + 1) + " " + ChromosomeMappingTools.format(tmp) + " " + cdsStart + " " + codingLength);
                    return new ChromPos(cdsStart + 1 + tmp, -1);
                }
                inCoding = true;
                logger.debug("     UTR         : " + ChromosomeMappingTools.format(start + 1) + " - " + cdsStart);
                logger.debug(" ->  Exon        : " + ChromosomeMappingTools.format(cdsStart + 1) + " - " + ChromosomeMappingTools.format(end) + " | " + ChromosomeMappingTools.format(end - cdsStart) + " | " + (codingLength += end - cdsStart) + " | " + codingLength % 3);
                continue;
            }
            if (start + 1 <= cdsEnd && end >= cdsEnd) {
                inCoding = false;
                if (codingLength + (cdsEnd - start - 1) >= cdsPos) {
                    int tmp = cdsPos - codingLength;
                    logger.debug(" <-  Exon        : " + ChromosomeMappingTools.format(start + 1) + " - " + ChromosomeMappingTools.format(cdsEnd) + " | " + ChromosomeMappingTools.format(cdsEnd - start) + " | " + codingLength + " | " + codingLength % 3);
                    logger.debug("     UTR         : " + ChromosomeMappingTools.format(cdsEnd + 1) + " - " + ChromosomeMappingTools.format(end));
                    logger.debug(codingLength + " | " + tmp + " | " + ChromosomeMappingTools.format(start + 1));
                    logger.debug(" -> chromPosForward found position in non coding exon:  " + cdsPos + " " + ChromosomeMappingTools.format(start + 1) + " " + ChromosomeMappingTools.format(tmp) + " " + ChromosomeMappingTools.format(cdsStart) + " " + codingLength);
                    return new ChromPos(start + 1 + tmp, cdsPos % 3);
                }
                logger.debug(" <-  Exon        : " + ChromosomeMappingTools.format(start + 1) + " - " + ChromosomeMappingTools.format(cdsEnd) + " | " + ChromosomeMappingTools.format(cdsEnd - start) + " | " + (codingLength += cdsEnd - start - 1) + " | " + codingLength % 3);
                logger.debug("     UTR         : " + ChromosomeMappingTools.format(cdsEnd + 1) + " - " + ChromosomeMappingTools.format(end));
                continue;
            }
            if (!inCoding) continue;
            if (codingLength + (end - start - 1) >= cdsPos) {
                int tmp = cdsPos - codingLength;
                logger.debug("     Exon        : " + ChromosomeMappingTools.format(start + 1) + " - " + ChromosomeMappingTools.format(end) + " | " + ChromosomeMappingTools.format(end - start) + " | " + tmp + " | " + codingLength);
                logger.debug(" -> found chr position in coding exon #" + (i + 1) + ":  cdsPos:" + ChromosomeMappingTools.format(cdsPos) + " s:" + ChromosomeMappingTools.format(start) + "-" + ChromosomeMappingTools.format(end) + " tmp:" + ChromosomeMappingTools.format(tmp) + " cdsStart:" + ChromosomeMappingTools.format(cdsStart) + " codingLength:" + codingLength);
                return new ChromPos(start + 1 + tmp, cdsPos % 3);
            }
            logger.debug("     Exon        : " + ChromosomeMappingTools.format(start + 1) + " - " + ChromosomeMappingTools.format(end) + " | " + ChromosomeMappingTools.format(end - start) + " | " + (codingLength += end - start) + " | " + codingLength % 3);
        }
        return new ChromPos(-1, -1);
    }

    public static int getCDSLengthReverse(List<Integer> exonStarts, List<Integer> exonEnds, int cdsStart, int cdsEnd) {
        int codingLength = 0;
        if (cdsEnd < cdsStart) {
            int tmp = cdsEnd;
            cdsEnd = cdsStart;
            cdsStart = tmp;
        }
        cdsStart += base;
        for (int i = exonStarts.size() - 1; i >= 0; --i) {
            int start;
            int end = exonStarts.get(i);
            if (end < (start = exonEnds.get(i).intValue())) {
                int tmp = end;
                end = start;
                start = tmp;
            }
            if ((start += base) < cdsStart && end < cdsStart || start > cdsEnd && end > cdsEnd) continue;
            if (start < cdsStart) {
                start = cdsStart;
            }
            if (end > cdsEnd) {
                end = cdsEnd;
            }
            codingLength += end - start + 1;
        }
        return codingLength - 3;
    }

    public static int getCDSLengthForward(List<Integer> exonStarts, List<Integer> exonEnds, int cdsStart, int cdsEnd) {
        int codingLength = 0;
        for (int i = 0; i < exonStarts.size(); ++i) {
            int start = exonStarts.get(i) + base;
            int end = exonEnds.get(i);
            if (start < cdsStart + base && end < cdsStart || start > cdsEnd && end > cdsEnd) continue;
            if (start < cdsStart + base) {
                start = cdsStart + base;
            }
            if (end > cdsEnd) {
                end = cdsEnd;
            }
            codingLength += end - start + 1;
        }
        return codingLength - 3;
    }

    public static List<Range<Integer>> getCDSExonRanges(GeneChromosomePosition chromPos) {
        if (chromPos.getOrientation().charValue() == '+') {
            return ChromosomeMappingTools.getCDSExonRangesForward(chromPos, CDS);
        }
        return ChromosomeMappingTools.getCDSExonRangesReverse(chromPos, CDS);
    }

    public static List<Range<Integer>> getChromosomalRangesForCDS(GeneChromosomePosition chromPos) {
        if (chromPos.getOrientation().charValue() == '+') {
            return ChromosomeMappingTools.getCDSExonRangesForward(chromPos, CHROMOSOME);
        }
        return ChromosomeMappingTools.getCDSExonRangesReverse(chromPos, CHROMOSOME);
    }

    private static List<Range<Integer>> getCDSExonRangesReverse(GeneChromosomePosition chromPos, String responseType) {
        List<Integer> exonStarts = chromPos.getExonStarts();
        List<Integer> exonEnds = chromPos.getExonEnds();
        ArrayList<Range<Integer>> data = new ArrayList<Range<Integer>>();
        int cdsStart = chromPos.getCdsStart();
        int cdsEnd = chromPos.getCdsEnd();
        boolean inCoding = false;
        int codingLength = 0;
        if (cdsEnd < cdsStart) {
            int tmp = cdsEnd;
            cdsEnd = cdsStart;
            cdsStart = tmp;
        }
        StringBuffer s = null;
        boolean debug = logger.isDebugEnabled();
        if (debug) {
            s = new StringBuffer();
        }
        for (int i = exonStarts.size() - 1; i >= 0; --i) {
            int start;
            int end = exonStarts.get(i);
            if (end < (start = exonEnds.get(i).intValue())) {
                int tmp = end;
                end = start;
                start = tmp;
            }
            if (start <= cdsEnd && end >= cdsEnd) {
                inCoding = true;
                int tmpstart = start;
                if (start < cdsStart) {
                    tmpstart = cdsStart;
                }
                codingLength += cdsEnd - tmpstart;
                if (debug) {
                    s.append("     UTR         :").append(ChromosomeMappingTools.format(cdsEnd + 1)).append(" | ").append(ChromosomeMappingTools.format(end));
                    s.append(newline);
                    if (tmpstart == start) {
                        s.append(" ->  ");
                    } else {
                        s.append(" <-> ");
                    }
                    s.append("Exon        :").append(ChromosomeMappingTools.format(tmpstart + 1)).append(" - ").append(ChromosomeMappingTools.format(cdsEnd)).append(" | ").append(cdsEnd - tmpstart).append(" | ").append(codingLength).append(" | ").append(codingLength % 3);
                    s.append(newline);
                    if (tmpstart != start) {
                        s.append("     UTR         :").append(ChromosomeMappingTools.format(cdsStart)).append(" - ").append(ChromosomeMappingTools.format(start + 1));
                    }
                    s.append(newline);
                }
                Range r = responseType.equals(CDS) ? Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(codingLength)) : Range.closed((Comparable)Integer.valueOf(tmpstart), (Comparable)Integer.valueOf(cdsEnd));
                data.add((Range<Integer>)r);
                continue;
            }
            if (start <= cdsStart && end >= cdsStart) {
                inCoding = false;
                Range r = responseType.equals(CDS) ? Range.closed((Comparable)Integer.valueOf(codingLength), (Comparable)Integer.valueOf(codingLength + (end - cdsStart))) : Range.closed((Comparable)Integer.valueOf(cdsStart + 1), (Comparable)Integer.valueOf(end));
                data.add((Range<Integer>)r);
                codingLength += end - cdsStart;
                if (!debug) continue;
                s.append(" <-  Exon        : " + ChromosomeMappingTools.format(cdsStart + 1) + " - " + ChromosomeMappingTools.format(end) + " | " + (end - cdsStart) + " | " + codingLength + " | " + codingLength % 3);
                s.append(newline);
                s.append("     UTR         : ").append(ChromosomeMappingTools.format(start + 1)).append(" - ").append(ChromosomeMappingTools.format(cdsStart));
                s.append(newline);
                continue;
            }
            if (inCoding) {
                Range r = responseType.equals(CDS) ? Range.closed((Comparable)Integer.valueOf(codingLength), (Comparable)Integer.valueOf(codingLength + (end - start))) : Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end));
                data.add((Range<Integer>)r);
                codingLength += end - start;
                if (!debug) continue;
                s.append("     Exon        : " + ChromosomeMappingTools.format(start + 1) + " - " + ChromosomeMappingTools.format(end) + " | " + (end - start) + " | " + codingLength + " | " + codingLength % 3);
                s.append(newline);
                continue;
            }
            if (!debug) continue;
            s.append(" no translation! UTR: " + ChromosomeMappingTools.format(start) + " - " + ChromosomeMappingTools.format(end));
            s.append(newline);
        }
        if (debug) {
            s.append("CDS length: ").append(Integer.toString(codingLength - 3));
            s.append(newline);
            logger.debug(s.toString());
        }
        return data;
    }

    private static List<Range<Integer>> getCDSExonRangesForward(GeneChromosomePosition chromPos, String responseType) {
        ArrayList<Range<Integer>> data = new ArrayList<Range<Integer>>();
        List<Integer> exonStarts = chromPos.getExonStarts();
        List<Integer> exonEnds = chromPos.getExonEnds();
        int cdsStart = chromPos.getCdsStart();
        int cdsEnd = chromPos.getCdsEnd();
        boolean inCoding = false;
        int codingLength = 0;
        for (int i = 0; i < exonStarts.size(); ++i) {
            Range r;
            int start = exonStarts.get(i);
            int end = exonEnds.get(i);
            if (start <= cdsStart && end >= cdsStart) {
                inCoding = true;
                r = responseType.equals(CDS) ? Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(codingLength += end - cdsStart)) : Range.closed((Comparable)Integer.valueOf(cdsStart), (Comparable)Integer.valueOf(end));
                data.add((Range<Integer>)r);
                continue;
            }
            if (start <= cdsEnd && end >= cdsEnd) {
                inCoding = false;
                r = responseType.equals(CDS) ? Range.closed((Comparable)Integer.valueOf(codingLength), (Comparable)Integer.valueOf(codingLength + (cdsEnd - start))) : Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(cdsEnd));
                data.add((Range<Integer>)r);
                codingLength += cdsEnd - start;
                continue;
            }
            if (!inCoding) continue;
            r = responseType.equals(CDS) ? Range.closed((Comparable)Integer.valueOf(codingLength), (Comparable)Integer.valueOf(codingLength + (end - start))) : Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end));
            data.add((Range<Integer>)r);
            codingLength += end - start;
        }
        return data;
    }

    public static int getCDSPosForChromosomeCoordinate(int coordinate, GeneChromosomePosition chromosomePosition) {
        if (chromosomePosition.getOrientation().charValue() == '+') {
            return ChromosomeMappingTools.getCDSPosForward(coordinate, chromosomePosition.getExonStarts(), chromosomePosition.getExonEnds(), chromosomePosition.getCdsStart(), chromosomePosition.getCdsEnd());
        }
        return ChromosomeMappingTools.getCDSPosReverse(coordinate, chromosomePosition.getExonStarts(), chromosomePosition.getExonEnds(), chromosomePosition.getCdsStart(), chromosomePosition.getCdsEnd());
    }

    public static int getCDSPosForward(int chromPos, List<Integer> exonStarts, List<Integer> exonEnds, int cdsStart, int cdsEnd) {
        if (chromPos < cdsStart + base || chromPos > cdsEnd + base) {
            logger.debug("The " + ChromosomeMappingTools.format(chromPos) + " position is not in a coding region");
            return -1;
        }
        logger.debug("looking for CDS position for " + ChromosomeMappingTools.format(chromPos));
        List<Range<Integer>> cdsRegions = ChromosomeMappingTools.getCDSRegions(exonStarts, exonEnds, cdsStart, cdsEnd);
        int codingLength = 0;
        int lengthExon = 0;
        for (Range<Integer> range : cdsRegions) {
            int start = (Integer)range.lowerEndpoint();
            int end = (Integer)range.upperEndpoint();
            lengthExon = end - start;
            if (start + base <= chromPos && end >= chromPos) {
                return codingLength + (chromPos - start);
            }
            codingLength += lengthExon;
        }
        return -1;
    }

    public static int getCDSPosReverse(int chromPos, List<Integer> exonStarts, List<Integer> exonEnds, int cdsStart, int cdsEnd) {
        if (chromPos < cdsStart + base || chromPos > cdsEnd + base) {
            logger.debug("The " + ChromosomeMappingTools.format(chromPos) + " position is not in a coding region");
            return -1;
        }
        logger.debug("looking for CDS position for " + ChromosomeMappingTools.format(chromPos));
        List<Range<Integer>> cdsRegions = ChromosomeMappingTools.getCDSRegions(exonStarts, exonEnds, cdsStart, cdsEnd);
        int codingLength = 0;
        int lengthExon = 0;
        for (int i = cdsRegions.size() - 1; i >= 0; --i) {
            int start = (Integer)cdsRegions.get(i).lowerEndpoint();
            int end = (Integer)cdsRegions.get(i).upperEndpoint();
            lengthExon = end - start;
            if (start + base <= chromPos && end >= chromPos) {
                return codingLength + (end - chromPos + 1);
            }
            codingLength += lengthExon;
        }
        return -1;
    }

    public static List<Range<Integer>> getCDSRegions(List<Integer> origExonStarts, List<Integer> origExonEnds, int cdsStart, int cdsEnd) {
        ArrayList<Integer> exonStarts = new ArrayList<Integer>(origExonStarts);
        ArrayList<Integer> exonEnds = new ArrayList<Integer>(origExonEnds);
        int j = 0;
        for (int i = 0; i < origExonStarts.size(); ++i) {
            if (origExonEnds.get(i) < cdsStart || origExonStarts.get(i) > cdsEnd) {
                exonStarts.remove(j);
                exonEnds.remove(j);
                continue;
            }
            ++j;
        }
        int nExons = exonStarts.size();
        exonStarts.remove(0);
        exonStarts.add(0, cdsStart);
        exonEnds.remove(nExons - 1);
        exonEnds.add(cdsEnd);
        ArrayList<Range<Integer>> cdsRegion = new ArrayList<Range<Integer>>();
        for (int i = 0; i < nExons; ++i) {
            Range r = Range.closed((Comparable)((Integer)exonStarts.get(i)), (Comparable)((Integer)exonEnds.get(i)));
            cdsRegion.add((Range<Integer>)r);
        }
        return cdsRegion;
    }

    public static DNASequence getTranscriptDNASequence(TwoBitFacade twoBitFacade, GeneChromosomePosition gcp) throws Exception {
        return ChromosomeMappingTools.getTranscriptDNASequence(twoBitFacade, gcp.getChromosome(), gcp.getExonStarts(), gcp.getExonEnds(), gcp.getCdsStart(), gcp.getCdsEnd(), gcp.getOrientation());
    }

    public static DNASequence getTranscriptDNASequence(TwoBitFacade twoBitFacade, String chromosome, List<Integer> exonStarts, List<Integer> exonEnds, int cdsStart, int cdsEnd, Character orientation) throws Exception {
        List<Range<Integer>> cdsRegion = ChromosomeMappingTools.getCDSRegions(exonStarts, exonEnds, cdsStart, cdsEnd);
        String dnaSequence = "";
        for (Range<Integer> range : cdsRegion) {
            String exonSequence = twoBitFacade.getSequence(chromosome, (Integer)range.lowerEndpoint(), (Integer)range.upperEndpoint());
            dnaSequence = dnaSequence + exonSequence;
        }
        if (orientation.equals(Character.valueOf('-'))) {
            dnaSequence = new StringBuilder(dnaSequence).reverse().toString();
            DNASequence dna = new DNASequence(dnaSequence);
            SequenceView compliment = dna.getComplement();
            dnaSequence = compliment.getSequenceAsString();
        }
        return new DNASequence(dnaSequence.toUpperCase());
    }
}

