/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.loader;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.DataSource;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompoundSet;
import org.biojava.nbio.core.sequence.features.DBReferenceInfo;
import org.biojava.nbio.core.sequence.features.DatabaseReferenceInterface;
import org.biojava.nbio.core.sequence.features.FeaturesKeyWordInterface;
import org.biojava.nbio.core.sequence.storage.SequenceAsStringHelper;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.ProxySequenceReader;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.core.sequence.template.SequenceMixin;
import org.biojava.nbio.core.sequence.template.SequenceProxyView;
import org.biojava.nbio.core.sequence.template.SequenceView;
import org.biojava.nbio.core.util.Equals;
import org.biojava.nbio.core.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class UniprotProxySequenceReader<C extends Compound>
implements ProxySequenceReader<C>,
FeaturesKeyWordInterface,
DatabaseReferenceInterface {
    private static final Logger logger = LoggerFactory.getLogger(UniprotProxySequenceReader.class);
    private static final String SPID_PATTERN = "[OPQ][0-9][A-Z0-9]{3}[0-9]";
    private static final String TREMBLID_PATTERN = "[A-NR-Z][0-9]([A-Z][A-Z0-9]{2}[0-9]){1,2}";
    public static final Pattern UP_AC_PATTERN = Pattern.compile("([OPQ][0-9][A-Z0-9]{3}[0-9]|[A-NR-Z][0-9]([A-Z][A-Z0-9]{2}[0-9]){1,2})");
    public static final String DEFAULT_UNIPROT_BASE_URL = "https://www.uniprot.org";
    private static String uniprotbaseURL = "https://www.uniprot.org";
    private static String uniprotDirectoryCache = null;
    private String sequence;
    private CompoundSet<C> compoundSet;
    private List<C> parsedCompounds = new ArrayList<C>();
    Document uniprotDoc;

    public UniprotProxySequenceReader(String accession, CompoundSet<C> compoundSet) throws CompoundNotFoundException, IOException {
        if (!UP_AC_PATTERN.matcher(accession.toUpperCase()).matches()) {
            throw new IllegalArgumentException("Accession provided " + accession + " doesn't comply with the uniprot acession pattern.");
        }
        this.setCompoundSet(compoundSet);
        this.uniprotDoc = this.getUniprotXML(accession);
        String seq = this.getSequence(this.uniprotDoc);
        this.setContents(seq);
    }

    public UniprotProxySequenceReader(Document document, CompoundSet<C> compoundSet) throws CompoundNotFoundException {
        this.setCompoundSet(compoundSet);
        this.uniprotDoc = document;
        String seq = this.getSequence(this.uniprotDoc);
        this.setContents(seq);
    }

    public static <C extends Compound> UniprotProxySequenceReader<C> parseUniprotXMLString(String xml, CompoundSet<C> compoundSet) {
        try {
            Document document = XMLHelper.inputStreamToDocument(new ByteArrayInputStream(xml.getBytes()));
            return new UniprotProxySequenceReader<C>(document, compoundSet);
        }
        catch (Exception e) {
            logger.error("Exception on xml parse of: {}", (Object)xml);
            return null;
        }
    }

    @Override
    public void setCompoundSet(CompoundSet<C> compoundSet) {
        this.compoundSet = compoundSet;
    }

    @Override
    public void setContents(String sequence) throws CompoundNotFoundException {
        String compoundStr;
        this.sequence = sequence.replaceAll("\\s", "").trim();
        this.parsedCompounds.clear();
        for (int i = 0; i < this.sequence.length(); i += compoundStr.length()) {
            compoundStr = null;
            Object compound = null;
            for (int compoundStrLength = 1; compound == null && compoundStrLength <= this.compoundSet.getMaxSingleCompoundStringLength(); ++compoundStrLength) {
                compoundStr = this.sequence.substring(i, i + compoundStrLength);
                compound = this.compoundSet.getCompoundForString(compoundStr);
            }
            if (compound == null) {
                throw new CompoundNotFoundException("Compound " + compoundStr + " not found");
            }
            this.parsedCompounds.add(compound);
        }
    }

    @Override
    public int getLength() {
        return this.parsedCompounds.size();
    }

    @Override
    public C getCompoundAt(int position) {
        return (C)((Compound)this.parsedCompounds.get(position - 1));
    }

    @Override
    public int getIndexOf(C compound) {
        return this.parsedCompounds.indexOf(compound) + 1;
    }

    @Override
    public int getLastIndexOf(C compound) {
        return this.parsedCompounds.lastIndexOf(compound) + 1;
    }

    public String toString() {
        return this.getSequenceAsString();
    }

    @Override
    public String getSequenceAsString() {
        return this.sequence;
    }

    @Override
    public List<C> getAsList() {
        return this.parsedCompounds;
    }

    public boolean equals(Object o) {
        if (!Equals.classEqual(this, o)) {
            return false;
        }
        Sequence other = (Sequence)o;
        if (other.getCompoundSet() != this.getCompoundSet()) {
            return false;
        }
        List<C> rawCompounds = this.getAsList();
        List otherCompounds = other.getAsList();
        if (rawCompounds.size() != otherCompounds.size()) {
            return false;
        }
        for (int i = 0; i < rawCompounds.size(); ++i) {
            Compound otherCompound;
            Compound myCompound = (Compound)rawCompounds.get(i);
            if (myCompound.equalsIgnoreCase(otherCompound = (Compound)otherCompounds.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        String s = this.getSequenceAsString();
        return s.hashCode();
    }

    @Override
    public SequenceView<C> getInverse() {
        return SequenceMixin.inverse(this);
    }

    public String getSequenceAsString(Integer bioBegin, Integer bioEnd, Strand strand) {
        SequenceAsStringHelper<C> sequenceAsStringHelper = new SequenceAsStringHelper<C>();
        return sequenceAsStringHelper.getSequenceAsString(this.parsedCompounds, this.compoundSet, bioBegin, bioEnd, strand);
    }

    @Override
    public SequenceView<C> getSubSequence(Integer bioBegin, Integer bioEnd) {
        return new SequenceProxyView(this, bioBegin, bioEnd);
    }

    @Override
    public Iterator<C> iterator() {
        return this.parsedCompounds.iterator();
    }

    @Override
    public CompoundSet<C> getCompoundSet() {
        return this.compoundSet;
    }

    @Override
    public AccessionID getAccession() {
        AccessionID accessionID = new AccessionID();
        if (this.uniprotDoc == null) {
            return accessionID;
        }
        try {
            Element uniprotElement = this.uniprotDoc.getDocumentElement();
            Element entryElement = XMLHelper.selectSingleElement(uniprotElement, "entry");
            Element nameElement = XMLHelper.selectSingleElement(entryElement, "name");
            accessionID = new AccessionID(nameElement.getTextContent(), DataSource.UNIPROT);
        }
        catch (XPathExpressionException e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return accessionID;
    }

    public ArrayList<AccessionID> getAccessions() throws XPathExpressionException {
        ArrayList<AccessionID> accessionList = new ArrayList<AccessionID>();
        if (this.uniprotDoc == null) {
            return accessionList;
        }
        Element uniprotElement = this.uniprotDoc.getDocumentElement();
        Element entryElement = XMLHelper.selectSingleElement(uniprotElement, "entry");
        ArrayList<Element> keyWordElementList = XMLHelper.selectElements(entryElement, "accession");
        for (Element element : keyWordElementList) {
            AccessionID accessionID = new AccessionID(element.getTextContent(), DataSource.UNIPROT);
            accessionList.add(accessionID);
        }
        return accessionList;
    }

    public ArrayList<String> getAliases() throws XPathExpressionException {
        return this.getProteinAliases();
    }

    public ArrayList<String> getProteinAliases() throws XPathExpressionException {
        String cdAntigenName;
        ArrayList<String> aliasList = new ArrayList<String>();
        if (this.uniprotDoc == null) {
            return aliasList;
        }
        Element uniprotElement = this.uniprotDoc.getDocumentElement();
        Element entryElement = XMLHelper.selectSingleElement(uniprotElement, "entry");
        Element proteinElement = XMLHelper.selectSingleElement(entryElement, "protein");
        this.getProteinAliasesFromNameGroup(aliasList, proteinElement);
        ArrayList<Element> keyWordElementList = XMLHelper.selectElements(proteinElement, "component");
        for (Element element : keyWordElementList) {
            this.getProteinAliasesFromNameGroup(aliasList, element);
        }
        keyWordElementList = XMLHelper.selectElements(proteinElement, "domain");
        for (Element element : keyWordElementList) {
            this.getProteinAliasesFromNameGroup(aliasList, element);
        }
        keyWordElementList = XMLHelper.selectElements(proteinElement, "submittedName");
        for (Element element : keyWordElementList) {
            this.getProteinAliasesFromNameGroup(aliasList, element);
        }
        keyWordElementList = XMLHelper.selectElements(proteinElement, "cdAntigenName");
        for (Element element : keyWordElementList) {
            cdAntigenName = element.getTextContent();
            if (null == cdAntigenName || cdAntigenName.trim().isEmpty()) continue;
            aliasList.add(cdAntigenName);
        }
        keyWordElementList = XMLHelper.selectElements(proteinElement, "innName");
        for (Element element : keyWordElementList) {
            cdAntigenName = element.getTextContent();
            if (null == cdAntigenName || cdAntigenName.trim().isEmpty()) continue;
            aliasList.add(cdAntigenName);
        }
        keyWordElementList = XMLHelper.selectElements(proteinElement, "biotechName");
        for (Element element : keyWordElementList) {
            cdAntigenName = element.getTextContent();
            if (null == cdAntigenName || cdAntigenName.trim().isEmpty()) continue;
            aliasList.add(cdAntigenName);
        }
        keyWordElementList = XMLHelper.selectElements(proteinElement, "allergenName");
        for (Element element : keyWordElementList) {
            cdAntigenName = element.getTextContent();
            if (null == cdAntigenName || cdAntigenName.trim().isEmpty()) continue;
            aliasList.add(cdAntigenName);
        }
        return aliasList;
    }

    private void getProteinAliasesFromNameGroup(ArrayList<String> aliasList, Element proteinElement) throws XPathExpressionException {
        ArrayList<Element> keyWordElementList = XMLHelper.selectElements(proteinElement, "alternativeName");
        for (Element element : keyWordElementList) {
            this.getProteinAliasesFromElement(aliasList, element);
        }
        keyWordElementList = XMLHelper.selectElements(proteinElement, "recommendedName");
        for (Element element : keyWordElementList) {
            this.getProteinAliasesFromElement(aliasList, element);
        }
    }

    private void getProteinAliasesFromElement(ArrayList<String> aliasList, Element element) throws XPathExpressionException {
        String shortName;
        Element fullNameElement = XMLHelper.selectSingleElement(element, "fullName");
        aliasList.add(fullNameElement.getTextContent());
        Element shortNameElement = XMLHelper.selectSingleElement(element, "shortName");
        if (null != shortNameElement && null != (shortName = shortNameElement.getTextContent()) && !shortName.trim().isEmpty()) {
            aliasList.add(shortName);
        }
    }

    public ArrayList<String> getGeneAliases() throws XPathExpressionException {
        ArrayList<String> aliasList = new ArrayList<String>();
        if (this.uniprotDoc == null) {
            return aliasList;
        }
        Element uniprotElement = this.uniprotDoc.getDocumentElement();
        Element entryElement = XMLHelper.selectSingleElement(uniprotElement, "entry");
        ArrayList<Element> proteinElements = XMLHelper.selectElements(entryElement, "gene");
        for (Element proteinElement : proteinElements) {
            ArrayList<Element> keyWordElementList = XMLHelper.selectElements(proteinElement, "name");
            for (Element element : keyWordElementList) {
                aliasList.add(element.getTextContent());
            }
        }
        return aliasList;
    }

    @Override
    public int countCompounds(C ... compounds) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private Document getUniprotXML(String accession) throws IOException, CompoundNotFoundException {
        StringBuilder sb = new StringBuilder();
        if (uniprotDirectoryCache != null && uniprotDirectoryCache.length() > 0) {
            sb = this.fetchFromCache(accession);
        }
        if (sb.length() == 0) {
            String uniprotURL = UniprotProxySequenceReader.getUniprotbaseURL() + "/uniprot/" + accession.toUpperCase() + ".xml";
            logger.info("Loading: {}", (Object)uniprotURL);
            sb = this.fetchUniprotXML(uniprotURL);
            int index = sb.indexOf("xmlns=");
            if (index != -1) {
                int lastIndex = sb.indexOf(">", index);
                sb.replace(index, lastIndex, "");
            }
            if (uniprotDirectoryCache != null && uniprotDirectoryCache.length() > 0) {
                this.writeCache(sb, accession);
            }
        }
        logger.info("Load complete");
        try {
            Document document = XMLHelper.inputStreamToDocument(new ByteArrayInputStream(sb.toString().getBytes()));
            return document;
        }
        catch (SAXException e) {
            logger.error("Exception on xml parse of: {}", (Object)sb.toString());
        }
        catch (ParserConfigurationException e) {
            logger.error("Exception on xml parse of: {}", (Object)sb.toString());
        }
        return null;
    }

    private void writeCache(StringBuilder sb, String accession) throws IOException {
        File f = new File(uniprotDirectoryCache + File.separatorChar + accession + ".xml");
        FileWriter fw = new FileWriter(f);
        fw.write(sb.toString());
        fw.close();
    }

    private static HttpURLConnection openURLConnection(URL url) throws IOException {
        int timeout = 5000;
        String useragent = "BioJava";
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("User-Agent", "BioJava");
        conn.setInstanceFollowRedirects(true);
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        int status = conn.getResponseCode();
        while (status == 302 || status == 301 || status == 303) {
            String newUrl = conn.getHeaderField("Location");
            if (newUrl.equals(url.toString())) {
                throw new IOException("Cyclic redirect detected at " + newUrl);
            }
            String cookies = conn.getHeaderField("Set-Cookie");
            url = new URL(newUrl);
            conn.disconnect();
            conn = (HttpURLConnection)url.openConnection();
            if (cookies != null) {
                conn.setRequestProperty("Cookie", cookies);
            }
            conn.addRequestProperty("User-Agent", "BioJava");
            conn.setInstanceFollowRedirects(true);
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.connect();
            status = conn.getResponseCode();
            logger.info("Redirecting from {} to {}", (Object)url, (Object)newUrl);
        }
        conn.connect();
        return conn;
    }

    private StringBuilder fetchUniprotXML(String uniprotURL) throws IOException, CompoundNotFoundException {
        StringBuilder sb = new StringBuilder();
        URL uniprot = new URL(uniprotURL);
        ArrayList<String> errorCodes = new ArrayList<String>();
        for (int attempt = 5; attempt > 0; --attempt) {
            HttpURLConnection uniprotConnection = UniprotProxySequenceReader.openURLConnection(uniprot);
            int statusCode = uniprotConnection.getResponseCode();
            if (statusCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(uniprotConnection.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    sb.append(inputLine);
                }
                in.close();
                return sb;
            }
            errorCodes.add(String.valueOf(statusCode));
        }
        throw new RemoteException("Couldn't fetch accession from the url " + uniprotURL + " error codes on 5 attempts are " + ((Object)errorCodes).toString());
    }

    private StringBuilder fetchFromCache(String key) throws FileNotFoundException, IOException {
        File f = new File(uniprotDirectoryCache + File.separatorChar + key + ".xml");
        StringBuilder sb = new StringBuilder();
        if (f.exists()) {
            FileReader fr = new FileReader(f);
            int size = (int)f.length();
            char[] data = new char[size];
            fr.read(data);
            fr.close();
            sb.append(data);
            int index = sb.indexOf("xmlns=");
            if (index != -1) {
                int lastIndex = sb.indexOf(">", index);
                sb.replace(index, lastIndex, "");
            }
        }
        return sb;
    }

    private String getSequence(Document uniprotDoc) {
        try {
            Element uniprotElement = uniprotDoc.getDocumentElement();
            Element entryElement = XMLHelper.selectSingleElement(uniprotElement, "entry");
            Element sequenceElement = XMLHelper.selectSingleElement(entryElement, "sequence");
            String seqdata = sequenceElement.getTextContent();
            return seqdata;
        }
        catch (XPathExpressionException e) {
            logger.error("Problems while parsing sequence in UniProt XML: {}. Sequence will be blank.", (Object)e.getMessage());
            return "";
        }
    }

    public static String getUniprotbaseURL() {
        return uniprotbaseURL;
    }

    public static void setUniprotbaseURL(String aUniprotbaseURL) {
        uniprotbaseURL = aUniprotbaseURL;
    }

    public static String getUniprotDirectoryCache() {
        return uniprotDirectoryCache;
    }

    public static void setUniprotDirectoryCache(String aUniprotDirectoryCache) {
        File f = new File(aUniprotDirectoryCache);
        if (!f.exists()) {
            f.mkdirs();
        }
        uniprotDirectoryCache = aUniprotDirectoryCache;
    }

    public static void main(String[] args) {
        try {
            UniprotProxySequenceReader<AminoAcidCompound> uniprotSequence = new UniprotProxySequenceReader<AminoAcidCompound>("YA745_GIBZE", AminoAcidCompoundSet.getAminoAcidCompoundSet());
            ProteinSequence proteinSequence = new ProteinSequence(uniprotSequence);
            logger.info("Accession: {}", (Object)proteinSequence.getAccession().getID());
            logger.info("Sequence: {}", (Object)proteinSequence.getSequenceAsString());
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }

    public String getGeneName() {
        if (this.uniprotDoc == null) {
            return "";
        }
        try {
            Element uniprotElement = this.uniprotDoc.getDocumentElement();
            Element entryElement = XMLHelper.selectSingleElement(uniprotElement, "entry");
            Element geneElement = XMLHelper.selectSingleElement(entryElement, "gene");
            if (geneElement == null) {
                return "";
            }
            Element nameElement = XMLHelper.selectSingleElement(geneElement, "name");
            if (nameElement == null) {
                return "";
            }
            return nameElement.getTextContent();
        }
        catch (XPathExpressionException e) {
            logger.error("Problems while parsing gene name in UniProt XML: {}. Gene name will be blank.", (Object)e.getMessage());
            return "";
        }
    }

    public String getOrganismName() {
        if (this.uniprotDoc == null) {
            return "";
        }
        try {
            Element uniprotElement = this.uniprotDoc.getDocumentElement();
            Element entryElement = XMLHelper.selectSingleElement(uniprotElement, "entry");
            Element organismElement = XMLHelper.selectSingleElement(entryElement, "organism");
            if (organismElement == null) {
                return "";
            }
            Element nameElement = XMLHelper.selectSingleElement(organismElement, "name");
            if (nameElement == null) {
                return "";
            }
            return nameElement.getTextContent();
        }
        catch (XPathExpressionException e) {
            logger.error("Problems while parsing organism name in UniProt XML: {}. Organism name will be blank.", (Object)e.getMessage());
            return "";
        }
    }

    public ArrayList<String> getKeyWords() {
        ArrayList<String> keyWordsList = new ArrayList<String>();
        if (this.uniprotDoc == null) {
            return keyWordsList;
        }
        try {
            Element uniprotElement = this.uniprotDoc.getDocumentElement();
            Element entryElement = XMLHelper.selectSingleElement(uniprotElement, "entry");
            ArrayList<Element> keyWordElementList = XMLHelper.selectElements(entryElement, "keyword");
            for (Element element : keyWordElementList) {
                keyWordsList.add(element.getTextContent());
            }
        }
        catch (XPathExpressionException e) {
            logger.error("Problems while parsing keywords in UniProt XML: {}. No keywords will be available.", (Object)e.getMessage());
            return new ArrayList<String>();
        }
        return keyWordsList;
    }

    @Override
    public Map<String, List<DBReferenceInfo>> getDatabaseReferences() {
        LinkedHashMap<String, List<DBReferenceInfo>> databaseReferencesHashMap = new LinkedHashMap<String, List<DBReferenceInfo>>();
        if (this.uniprotDoc == null) {
            return databaseReferencesHashMap;
        }
        try {
            Element uniprotElement = this.uniprotDoc.getDocumentElement();
            Element entryElement = XMLHelper.selectSingleElement(uniprotElement, "entry");
            ArrayList<Element> dbreferenceElementList = XMLHelper.selectElements(entryElement, "dbReference");
            for (Element element : dbreferenceElementList) {
                String type = element.getAttribute("type");
                String id = element.getAttribute("id");
                ArrayList<DBReferenceInfo> idlist = (ArrayList<DBReferenceInfo>)databaseReferencesHashMap.get(type);
                if (idlist == null) {
                    idlist = new ArrayList<DBReferenceInfo>();
                    databaseReferencesHashMap.put(type, idlist);
                }
                DBReferenceInfo dbreferenceInfo = new DBReferenceInfo(type, id);
                ArrayList<Element> propertyElementList = XMLHelper.selectElements(element, "property");
                for (Element propertyElement : propertyElementList) {
                    String propertyType = propertyElement.getAttribute("type");
                    String propertyValue = propertyElement.getAttribute("value");
                    dbreferenceInfo.addProperty(propertyType, propertyValue);
                }
                idlist.add(dbreferenceInfo);
            }
        }
        catch (XPathExpressionException e) {
            logger.error("Problems while parsing db references in UniProt XML: {}. No db references will be available.", (Object)e.getMessage());
            return new LinkedHashMap<String, List<DBReferenceInfo>>();
        }
        return databaseReferencesHashMap;
    }
}

