/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.io.embl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import org.biojava.nbio.core.sequence.io.embl.EmblId;
import org.biojava.nbio.core.sequence.io.embl.EmblRecord;
import org.biojava.nbio.core.sequence.io.embl.EmblReference;

public class EmblReader {
    public static EmblRecord process(File file) throws IOException {
        EmblRecord emblRecord = new EmblRecord();
        StringBuilder sequence = new StringBuilder("");
        LinkedList<EmblReference> emblReferences = new LinkedList<EmblReference>();
        EmblReference emblReference = new EmblReference();
        LinkedList<String> accessionNumber = new LinkedList<String>();
        LinkedList<String> keyword = new LinkedList<String>();
        if (file == null) {
            throw new NullPointerException("file can't be null");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("the file can't be a directory");
        }
        try (FileReader fileReader = new FileReader(file);){
            String line = "";
            try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.length() <= 1) continue;
                    String lineInfo = line.substring(2, line.length()).trim();
                    String lineIdentifier = line.substring(0, 2);
                    if (lineIdentifier.equals("ID")) {
                        emblRecord.setEmblId(EmblReader.populateID(lineInfo));
                        continue;
                    }
                    if (lineIdentifier.equals("AC")) {
                        EmblReader.populateAccessionNumber(line, accessionNumber);
                        continue;
                    }
                    if (lineIdentifier.equals("DT") && line.contains("Created")) {
                        emblRecord.setCreatedDate(lineInfo);
                        continue;
                    }
                    if (lineIdentifier.equals("DT") && line.contains("updated")) {
                        emblRecord.setLastUpdatedDate(lineInfo);
                        continue;
                    }
                    if (lineIdentifier.equals("DE")) {
                        emblRecord.setSequenceDescription(lineInfo);
                        continue;
                    }
                    if (lineIdentifier.equals("KW")) {
                        keyword.add(lineInfo);
                        continue;
                    }
                    if (lineIdentifier.equals("OS")) {
                        emblRecord.setOrganismSpecies(lineInfo);
                        continue;
                    }
                    if (lineIdentifier.equals("OC")) {
                        emblRecord.setOrganismClassification(lineInfo);
                        continue;
                    }
                    if (lineIdentifier.equals("OG")) {
                        emblRecord.setOrGanelle(lineInfo);
                        continue;
                    }
                    if (lineIdentifier.equals("RN") || lineIdentifier.equals("RP") || lineIdentifier.equals("RX") || lineIdentifier.equals("RG") || lineIdentifier.equals("RA") || lineIdentifier.equals("RT") || lineIdentifier.equals("RL")) {
                        EmblReader.populateEmblReferences(lineIdentifier, lineInfo, emblReference, emblReferences);
                        continue;
                    }
                    if (lineIdentifier.equals("DR")) {
                        emblRecord.setDatabaseCrossReference(lineInfo);
                        continue;
                    }
                    if (lineIdentifier.equals("AH")) {
                        emblRecord.setAssemblyHeader(lineInfo);
                        continue;
                    }
                    if (lineIdentifier.equals("AS")) {
                        emblRecord.setAssemblyInformation(lineInfo);
                        continue;
                    }
                    if (lineIdentifier.equals("CO")) {
                        emblRecord.setConstructedSequence(lineInfo);
                        continue;
                    }
                    if (lineIdentifier.equals("FH")) {
                        emblRecord.setFeatureHeader(lineInfo);
                        continue;
                    }
                    if (lineIdentifier.equals("FT")) {
                        emblRecord.setFeatureTable(lineInfo);
                        continue;
                    }
                    if (lineIdentifier.equals("SQ")) {
                        emblRecord.setSequenceHeader(lineInfo);
                        continue;
                    }
                    if (lineIdentifier.equals("  ") && !lineIdentifier.equals("//")) {
                        EmblReader.populateSequence(line, sequence);
                        continue;
                    }
                    if (!lineIdentifier.equals("//")) continue;
                    emblRecord.setKeyword(keyword);
                    emblRecord.setEmblReference(emblReferences);
                    emblRecord.setAccessionNumber(accessionNumber);
                    emblRecord.setSequence(sequence.toString());
                }
            }
        }
        return emblRecord;
    }

    private static void populateSequence(String line, StringBuilder sequence) {
        String sequenceLine = line.replace(" ", "").replaceAll("[0-9]", "");
        sequence.append(sequenceLine);
    }

    private static void populateEmblReferences(String lineIdentifier, String lineInfo, EmblReference emblReference, LinkedList<EmblReference> emblReferences) {
        if (lineIdentifier.equals("RN")) {
            emblReference.setReferenceNumber(lineInfo);
        } else if (lineIdentifier.equals("RP")) {
            emblReference.setReferencePosition(lineInfo);
        } else if (lineIdentifier.equals("RX")) {
            emblReference.setReferenceCrossReference(lineInfo);
        } else if (lineIdentifier.equals("RG")) {
            emblReference.setReferenceGroup(lineInfo);
        } else if (lineIdentifier.equals("RA")) {
            emblReference.setReferenceAuthor(lineInfo);
        } else if (lineIdentifier.equals("RT")) {
            emblReference.setReferenceTitle(lineInfo);
        } else if (lineIdentifier.equals("RL")) {
            emblReference.setReferenceLocation(lineInfo);
            emblReferences.add(emblReference.copyEmblReference(emblReference));
        }
    }

    private static void populateAccessionNumber(String line, LinkedList<String> accessionNumber) {
        accessionNumber.add(line);
    }

    private static EmblId populateID(String line) {
        String[] strings = line.split(";");
        Arrays.stream(strings).map(String::trim).toArray(unused -> strings);
        EmblId emblId = new EmblId(strings[0], strings[1], strings[2], strings[3], strings[4], strings[5], strings[6]);
        return emblId;
    }
}

