/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.serial;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import java.io.IOException;
import java.util.List;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.impl.AtmosphereSocket;
import org.atmosphere.wasync.impl.ClientUtil;
import org.atmosphere.wasync.impl.DefaultFuture;
import org.atmosphere.wasync.impl.SocketRuntime;
import org.atmosphere.wasync.serial.DefaultSerializedFireStage;
import org.atmosphere.wasync.serial.SerialSocketRuntime;
import org.atmosphere.wasync.serial.SerializedFireStage;
import org.atmosphere.wasync.serial.SerializedOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializedSocket
extends AtmosphereSocket {
    private static final Logger logger = LoggerFactory.getLogger(SerializedSocket.class);
    private SerializedFireStage serializedFireStage;
    private AsyncHttpClient asyncHttpClient;

    public SerializedSocket(SerializedOptions options) {
        super(options);
        if (options.runtime() == null || options.runtime().isClosed()) {
            this.asyncHttpClient = ClientUtil.createDefaultAsyncHttpClient(options);
            options.runtime(this.asyncHttpClient);
        }
        this.serializedFireStage = options.serializedFireStage();
        if (this.serializedFireStage == null) {
            this.serializedFireStage = new DefaultSerializedFireStage();
        }
        this.serializedFireStage.setSocket(this);
    }

    @Override
    public SocketRuntime createRuntime(DefaultFuture future, Options options, List<FunctionWrapper> functions) {
        return new SerialSocketRuntime(this.transportInUse, options, new DefaultFuture(this), this, functions);
    }

    public SerializedFireStage getSerializedFireStage() {
        return this.serializedFireStage;
    }

    public ListenableFuture<Response> directWrite(Object encodedPayload) throws IOException {
        return this.socketRuntime.httpWrite(this.request, encodedPayload, encodedPayload);
    }

    @Override
    public void close() {
        this.serializedFireStage.shutdown();
        if (this.asyncHttpClient != null) {
            this.asyncHttpClient.close();
        }
        super.close();
    }
}

