/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.util.regex.Pattern;
import javax.swing.JProgressBar;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.JComponentDriver;
import org.assertj.swing.driver.JProgressBarIndeterminateQuery;
import org.assertj.swing.driver.JProgressBarMinimumAndMaximumQuery;
import org.assertj.swing.driver.JProgressBarStringQuery;
import org.assertj.swing.driver.JProgressBarValueQuery;
import org.assertj.swing.driver.JProgressBarWaitUntilIsDeterminate;
import org.assertj.swing.driver.JProgressBarWaitUntilValueIsEqualToExpectedTask;
import org.assertj.swing.driver.TextAssert;
import org.assertj.swing.driver.TextDisplayDriver;
import org.assertj.swing.internal.annotation.InternalApi;
import org.assertj.swing.timing.Timeout;
import org.assertj.swing.util.Pair;

@InternalApi
public class JProgressBarDriver
extends JComponentDriver
implements TextDisplayDriver<JProgressBar> {
    private static final Timeout DEFAULT_TIMEOUT = Timeout.timeout();
    private static final String TEXT_PROPERTY = "string";

    public JProgressBarDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull JProgressBar progressBar, @Nullable String expected) {
        ((TextAssert)TextAssert.verifyThat(JProgressBarStringQuery.stringOf(progressBar)).as(JProgressBarDriver.propertyName(progressBar, TEXT_PROPERTY))).isEqualOrMatches(expected);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull JProgressBar progressBar, @Nonnull Pattern pattern) {
        ((TextAssert)TextAssert.verifyThat(JProgressBarStringQuery.stringOf(progressBar)).as(JProgressBarDriver.propertyName(progressBar, TEXT_PROPERTY))).matches(pattern);
    }

    @RunsInEDT
    public void requireValue(@Nonnull JProgressBar progressBar, int value) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)JProgressBarValueQuery.valueOf(progressBar)).as(JProgressBarDriver.propertyName(progressBar, "value"))).isEqualTo(value);
    }

    @RunsInEDT
    public void requireIndeterminate(@Nonnull JProgressBar progressBar) {
        this.requireIndeterminate(progressBar, true);
    }

    @RunsInEDT
    public void requireDeterminate(@Nonnull JProgressBar progressBar) {
        this.requireIndeterminate(progressBar, false);
    }

    @RunsInEDT
    private void requireIndeterminate(@Nonnull JProgressBar progressBar, boolean indeterminate) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)JProgressBarIndeterminateQuery.isIndeterminate(progressBar)).as(JProgressBarDriver.propertyName(progressBar, "indeterminate"))).isEqualTo(indeterminate);
    }

    @RunsInEDT
    public void waitUntilValueIs(@Nonnull JProgressBar progressBar, int value) {
        this.waitUntilValueIs(progressBar, value, DEFAULT_TIMEOUT);
    }

    @RunsInEDT
    public void waitUntilValueIs(@Nonnull JProgressBar progressBar, int value, @Nonnull Timeout timeout) {
        this.checkInBetweenMinAndMax(progressBar, value);
        Preconditions.checkNotNull((Object)timeout);
        JProgressBarWaitUntilValueIsEqualToExpectedTask.waitUntilValueIsEqualToExpected(progressBar, value, timeout);
    }

    @RunsInEDT
    private void checkInBetweenMinAndMax(@Nonnull JProgressBar progressBar, int value) {
        Pair<Integer, Integer> minAndMax = JProgressBarMinimumAndMaximumQuery.minimumAndMaximumOf(progressBar);
        this.assertIsInBetweenMinAndMax(value, (Integer)minAndMax.first, (Integer)minAndMax.second);
    }

    private void assertIsInBetweenMinAndMax(int value, int min, int max) {
        if (value >= min && value <= max) {
            return;
        }
        String msg = String.format("Value <%d> should be between <[%d, %d]>", value, min, max);
        throw new IllegalArgumentException(msg);
    }

    @RunsInEDT
    public void waitUntilIsDeterminate(@Nonnull JProgressBar progressBar) {
        this.waitUntilIsDeterminate(progressBar, DEFAULT_TIMEOUT);
    }

    @RunsInEDT
    public void waitUntilIsDeterminate(@Nonnull JProgressBar progressBar, @Nonnull Timeout timeout) {
        Preconditions.checkNotNull((Object)timeout);
        JProgressBarWaitUntilIsDeterminate.waitUntilValueIsDeterminate(progressBar, timeout);
    }

    @Override
    @Nullable
    @RunsInEDT
    public String textOf(@Nonnull JProgressBar progressBar) {
        return JProgressBarStringQuery.stringOf(progressBar);
    }
}

