/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.junit.runner;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.assertj.core.util.Strings;
import org.assertj.swing.image.ScreenshotTaker;

public class FailureScreenshotTaker {
    private static Logger logger = Logger.getAnonymousLogger();
    private final File imageFolder;
    private final ScreenshotTaker screenshotTaker;

    public FailureScreenshotTaker(File imageFolder) {
        this(imageFolder, new ScreenshotTaker());
    }

    FailureScreenshotTaker(File imageFolder, ScreenshotTaker screenshotTaker) {
        this.imageFolder = imageFolder;
        this.screenshotTaker = screenshotTaker;
    }

    public void saveScreenshot(String failedTest) {
        try {
            String fileName = Strings.concat((Object[])new Object[]{this.imageFolder.getCanonicalPath(), File.separator, failedTest, ".", "png"});
            this.screenshotTaker.saveDesktopAsPng(fileName);
            logger.info(Strings.concat((Object[])new Object[]{"Screenshot of failed test saved as ", Strings.quote((String)fileName)}));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, Strings.concat((Object[])new Object[]{"Unable to take screenshot of failed test ", Strings.quote((String)failedTest)}), e);
        }
    }
}

