/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.ajdt.internal.compiler.CompilationResultDestinationManager;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.asm.AsmManager;

public class IncrementalStateManager {
    public static boolean recordIncrementalStates = false;
    public static boolean debugIncrementalStates = false;
    private static Hashtable incrementalStates = new Hashtable();

    public static void recordSuccessfulBuild(String buildConfig, AjState state) {
        if (!recordIncrementalStates) {
            return;
        }
        incrementalStates.put(buildConfig, state);
    }

    public static boolean removeIncrementalStateInformationFor(String buildConfig) {
        return incrementalStates.remove(buildConfig) != null;
    }

    public static void clearIncrementalStates() {
        Iterator iter = incrementalStates.values().iterator();
        while (iter.hasNext()) {
            AjState element = (AjState)iter.next();
            element.wipeAllKnowledge();
        }
        incrementalStates.clear();
        AsmManager.getDefault().createNewASM();
    }

    public static Set getConfigFilesKnown() {
        return incrementalStates.keySet();
    }

    public static AjState retrieveStateFor(String configFile) {
        return (AjState)incrementalStates.get(configFile);
    }

    public static AjState findStateManagingOutputLocation(File location) {
        Collection allStates = incrementalStates.values();
        if (debugIncrementalStates) {
            System.err.println("> findStateManagingOutputLocation(" + location + ") has " + allStates.size() + " states to look through");
        }
        Iterator iter = allStates.iterator();
        while (iter.hasNext()) {
            AjState element = (AjState)iter.next();
            AjBuildConfig ajbc = element.getBuildConfig();
            if (ajbc == null) {
                if (!debugIncrementalStates) continue;
                System.err.println("  No build configuration for state " + element);
                continue;
            }
            File outputDir = ajbc.getOutputDir();
            if (outputDir != null && outputDir.equals(location)) {
                if (debugIncrementalStates) {
                    System.err.println("< findStateManagingOutputLocation(" + location + ") returning " + element);
                }
                return element;
            }
            CompilationResultDestinationManager outputManager = ajbc.getCompilationResultDestinationManager();
            if (outputManager != null) {
                List outputDirs = outputManager.getAllOutputLocations();
                Iterator iterator = outputDirs.iterator();
                while (iterator.hasNext()) {
                    File dir = (File)iterator.next();
                    if (!dir.equals(location)) continue;
                    if (debugIncrementalStates) {
                        System.err.println("< findStateManagingOutputLocation(" + location + ") returning " + element);
                    }
                    return element;
                }
            }
            if (outputDir != null || outputManager != null || !debugIncrementalStates) continue;
            System.err.println("  output directory and output location manager for " + ajbc + " are null");
        }
        if (debugIncrementalStates) {
            System.err.println("< findStateManagingOutputLocation(" + location + ") returning null");
        }
        return null;
    }
}

