/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.asciidoctor.jruby.AbstractDirectoryWalker;
import org.asciidoctor.jruby.AsciiDocDirectoryWalker;
import org.asciidoctor.jruby.AsciidoctorJRuby;
import org.asciidoctor.jruby.internal.JRubyRuntimeContext;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.Severity;
import org.asciidoctor.maven.AsciidoctorHelper;
import org.asciidoctor.maven.Synchronization;
import org.asciidoctor.maven.extensions.AsciidoctorJExtensionRegistry;
import org.asciidoctor.maven.extensions.ExtensionConfiguration;
import org.asciidoctor.maven.io.AsciidoctorFileScanner;
import org.asciidoctor.maven.log.LogHandler;
import org.asciidoctor.maven.log.LogRecordHelper;
import org.asciidoctor.maven.log.MemoryLogHandler;
import org.jruby.Ruby;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="process-asciidoc", threadSafe=true)
public class AsciidoctorMojo
extends AbstractMojo {
    protected static final String ASCIIDOC_REG_EXP_EXTENSION = ".*\\.a((sc(iidoc)?)|d(oc)?)$";
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(property="asciidoctor.sourceDirectory", defaultValue="${basedir}/src/main/asciidoc", required=true)
    protected File sourceDirectory;
    @Parameter(property="asciidoctor.outputDirectory", defaultValue="${project.build.directory}/generated-docs", required=true)
    protected File outputDirectory;
    @Parameter(property="asciidoctor.outputFile", required=false)
    protected File outputFile;
    @Parameter(property="asciidoctor.preserveDirectories", defaultValue="false", required=false)
    protected boolean preserveDirectories = false;
    @Parameter(property="asciidoctor.relativeBaseDir", defaultValue="false", required=false)
    protected boolean relativeBaseDir = false;
    @Parameter(property="asciidoctor.projectDirectory", defaultValue="${basedir}", required=false, readonly=false)
    protected File projectDirectory;
    @Parameter(property="asciidoctor.rootDir", defaultValue="${basedir}", required=false, readonly=false)
    protected File rootDir;
    @Parameter(property="asciidoctor.baseDir", required=false)
    protected File baseDir;
    @Parameter(property="asciidoctor.skip", required=false)
    protected boolean skip = false;
    @Parameter(property="asciidoctor.gemPath", defaultValue="", required=false)
    protected String gemPath = "";
    @Parameter(property="asciidoctor.requires")
    protected List<String> requires = new ArrayList<String>();
    @Parameter(required=false)
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    @Parameter(property="asciidoctor.attributes", required=false)
    protected String attributesChain = "";
    @Parameter(property="asciidoctor.backend", defaultValue="docbook", required=true)
    protected String backend = "";
    @Parameter(property="asciidoctor.doctype", required=false)
    protected String doctype;
    @Parameter(property="asciidoctor.eruby", required=false)
    protected String eruby = "";
    @Parameter(property="asciidoctor.headerFooter", required=false)
    protected boolean headerFooter = true;
    @Parameter(property="asciidoctor.templateDir", required=false)
    protected File templateDir;
    @Parameter(property="asciidoctor.templateDirs", required=false)
    protected List<File> templateDirs = new ArrayList<File>();
    @Parameter(property="asciidoctor.templateEngine", required=false)
    protected String templateEngine;
    @Parameter(property="asciidoctor.templateCache")
    protected boolean templateCache = true;
    @Parameter(property="asciidoctor.imagesDir", required=false)
    protected String imagesDir = "images@";
    @Parameter(property="asciidoctor.sourceHighlighter", required=false)
    protected String sourceHighlighter;
    @Parameter(property="asciidoctor.title", required=false)
    protected String title = "";
    @Parameter(property="asciidoctor.sourceDocumentName", required=false)
    protected String sourceDocumentName;
    @Parameter(property="asciidoctor.sourceDocumentExtensions")
    protected List<String> sourceDocumentExtensions = new ArrayList<String>();
    @Parameter(property="asciidoctor.sourcemap")
    protected boolean sourcemap = false;
    @Parameter(property="asciidoctor.catalogAssets")
    protected boolean catalogAssets = false;
    @Parameter(property="asciidoctor.synchronizations", required=false)
    protected List<Synchronization> synchronizations = new ArrayList<Synchronization>();
    @Parameter(property="asciidoctor.extensions")
    protected List<ExtensionConfiguration> extensions = new ArrayList<ExtensionConfiguration>();
    @Parameter(property="asciidoctor.embedAssets")
    protected boolean embedAssets = false;
    @Parameter(property="asciidoctor.attributeMissing")
    protected String attributeMissing = "skip";
    @Parameter(property="asciidoctor.attributeUndefined")
    protected String attributeUndefined = "drop-line";
    @Parameter(property="asciidoctor.sources")
    protected List<Resource> resources;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(property="asciidoctor.verbose")
    protected boolean enableVerbose = false;
    @Parameter
    private LogHandler logHandler = new LogHandler();
    @Component
    protected MavenResourcesFiltering outputResourcesFiltering;
    @Component
    protected BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"AsciiDoc processing is skipped.");
            return;
        }
        if (this.sourceDirectory == null) {
            throw new MojoExecutionException("Required parameter 'asciidoctor.sourceDirectory' not set.");
        }
        if (!this.sourceDirectory.exists()) {
            this.getLog().info((CharSequence)("sourceDirectory " + this.sourceDirectory.getPath() + " does not exist. Skip processing"));
            return;
        }
        this.ensureOutputExists();
        if (this.resources != null) {
            for (Resource resource : this.resources) {
                if (resource.getDirectory() != null && !resource.getDirectory().isEmpty()) continue;
                throw new MojoExecutionException("Found empty resource directory");
            }
        }
        Asciidoctor asciidoctor = this.getAsciidoctorInstance(this.gemPath);
        if (this.enableVerbose) {
            asciidoctor.requireLibrary(new String[]{"enable_verbose.rb"});
        }
        asciidoctor.requireLibraries(this.requires);
        OptionsBuilder optionsBuilder = OptionsBuilder.options();
        this.setOptionsOnBuilder(optionsBuilder);
        AttributesBuilder attributesBuilder = AttributesBuilder.attributes();
        this.setAttributesOnBuilder(attributesBuilder);
        optionsBuilder.attributes(attributesBuilder);
        AsciidoctorJExtensionRegistry extensionRegistry = new AsciidoctorJExtensionRegistry(asciidoctor);
        for (ExtensionConfiguration extension : this.extensions) {
            try {
                extensionRegistry.register(extension.getClassName(), extension.getBlockName());
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        this.prepareResources();
        this.copyResources();
        List<File> sourceFiles = this.sourceDocumentName == null ? this.scanSourceFiles() : Arrays.asList(new File(this.sourceDirectory, this.sourceDocumentName));
        HashSet<File> dirs = new HashSet<File>();
        Boolean outputToConsole = this.logHandler.getOutputToConsole() == null ? Boolean.TRUE : this.logHandler.getOutputToConsole();
        MemoryLogHandler memoryLogHandler = new MemoryLogHandler(outputToConsole, this.sourceDirectory, this.getLog());
        if (!sourceFiles.isEmpty()) {
            asciidoctor.registerLogHandler((org.asciidoctor.log.LogHandler)memoryLogHandler);
            Logger.getLogger("asciidoctor").setUseParentHandlers(false);
        }
        for (File source : sourceFiles) {
            String textToSearch;
            List<LogRecord> records;
            Severity severity;
            File destinationPath = this.setDestinationPaths(optionsBuilder, source);
            if (!dirs.add(destinationPath)) {
                this.getLog().warn((CharSequence)("Duplicated destination found: overwriting file: " + destinationPath.getAbsolutePath()));
            }
            this.renderFile(asciidoctor, optionsBuilder.asMap(), source);
            if (this.logHandler.isSeveritySet() && this.logHandler.isContainsTextNotBlank()) {
                String textToSearch2;
                severity = this.logHandler.getFailIf().getSeverity();
                List<LogRecord> records2 = memoryLogHandler.filter(severity, textToSearch2 = this.logHandler.getFailIf().getContainsText());
                if (records2.size() <= 0) continue;
                for (LogRecord record : records2) {
                    this.getLog().error((CharSequence)LogRecordHelper.format(record, this.sourceDirectory));
                }
                throw new MojoExecutionException(String.format("Found %s issue(s) matching severity %s or higher and text '%s'", records2.size(), severity, textToSearch2));
            }
            if (this.logHandler.isSeveritySet()) {
                severity = this.logHandler.getFailIf().getSeverity();
                records = memoryLogHandler.filter(severity);
                if (records.size() <= 0) continue;
                for (LogRecord record : records) {
                    this.getLog().error((CharSequence)LogRecordHelper.format(record, this.sourceDirectory));
                }
                throw new MojoExecutionException(String.format("Found %s issue(s) of severity %s or higher during rendering", records.size(), severity));
            }
            if (!this.logHandler.isContainsTextNotBlank() || (records = memoryLogHandler.filter(textToSearch = this.logHandler.getFailIf().getContainsText())).size() <= 0) continue;
            for (LogRecord record : records) {
                this.getLog().error((CharSequence)LogRecordHelper.format(record, this.sourceDirectory));
            }
            throw new MojoExecutionException(String.format("Found %s issue(s) containing '%s'", records.size(), textToSearch));
        }
        if (this.synchronizations != null && !this.synchronizations.isEmpty()) {
            this.synchronize();
        }
    }

    private void prepareResources() {
        if (this.resources == null || this.resources.isEmpty()) {
            this.resources = new ArrayList<Resource>();
            Resource resource = new Resource();
            resource.setDirectory(this.sourceDirectory.getAbsolutePath());
            resource.setExcludes(new ArrayList());
            if (this.sourceDocumentName != null && this.sourceDocumentName.isEmpty()) {
                resource.getExcludes().add(this.sourceDocumentName);
            }
            this.resources.add(resource);
        }
        for (Resource resource : this.resources) {
            if (resource.getExcludes() == null || resource.getExcludes().isEmpty()) {
                resource.setExcludes(new ArrayList());
            }
            ArrayList<String> excludes = new ArrayList<String>();
            for (String value : AsciidoctorFileScanner.IGNORED_FOLDERS_AND_FILES) {
                excludes.add(value);
            }
            for (String value : AsciidoctorFileScanner.DEFAULT_FILE_EXTENSIONS) {
                excludes.add(value);
            }
            for (String docExtension : this.sourceDocumentExtensions) {
                resource.getExcludes().add("**/*." + docExtension);
            }
            excludes.removeAll(resource.getIncludes());
            resource.getExcludes().addAll(excludes);
        }
    }

    private void copyResources() throws MojoExecutionException {
        try {
            MavenResourcesExecution resourcesExecution = new MavenResourcesExecution(this.resources, this.outputDirectory, this.project, this.encoding, Collections.emptyList(), Collections.emptyList(), this.session);
            resourcesExecution.setIncludeEmptyDirs(true);
            resourcesExecution.setAddDefaultExcludes(true);
            this.outputResourcesFiltering.filterResources(resourcesExecution);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("Could not copy resources", (Exception)((Object)e));
        }
    }

    private File setDestinationPaths(OptionsBuilder optionsBuilder, File sourceFile) throws MojoExecutionException {
        try {
            if (this.baseDir != null) {
                optionsBuilder.baseDir(this.baseDir);
            } else if (this.relativeBaseDir) {
                optionsBuilder.baseDir(sourceFile.getParentFile());
            } else {
                optionsBuilder.baseDir(this.sourceDirectory);
            }
            if (this.preserveDirectories) {
                String candidatePath = sourceFile.getParentFile().getCanonicalPath().substring(this.sourceDirectory.getCanonicalPath().length());
                File relativePath = new File(this.outputDirectory.getCanonicalPath() + candidatePath);
                optionsBuilder.toDir(relativePath).destinationDir(relativePath);
            } else {
                optionsBuilder.toDir(this.outputDirectory).destinationDir(this.outputDirectory);
            }
            if (this.outputFile != null) {
                optionsBuilder.toFile(this.outputFile);
            }
            if (this.outputFile != null) {
                return this.outputFile.isAbsolute() ? this.outputFile : new File((String)optionsBuilder.asMap().get("destination_dir"), this.outputFile.getPath());
            }
            return new File((String)optionsBuilder.asMap().get("destination_dir"), sourceFile.getName());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to locate output directory", (Exception)e);
        }
    }

    protected Asciidoctor getAsciidoctorInstance(String gemPath) throws MojoExecutionException {
        String gemHomeExpected;
        Ruby rubyInstance;
        AsciidoctorJRuby asciidoctor;
        block8: {
            asciidoctor = null;
            if (gemPath == null) {
                asciidoctor = AsciidoctorJRuby.Factory.create();
            } else {
                String normalizedGemPath = File.separatorChar == '\\' ? gemPath.replaceAll("\\\\", "/") : gemPath;
                asciidoctor = AsciidoctorJRuby.Factory.create((String)normalizedGemPath);
            }
            rubyInstance = null;
            try {
                rubyInstance = (Ruby)JRubyRuntimeContext.class.getMethod("get", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                if (rubyInstance != null) break block8;
                try {
                    rubyInstance = (Ruby)JRubyRuntimeContext.class.getMethod("get", Asciidoctor.class).invoke(null, asciidoctor);
                }
                catch (Exception e1) {
                    throw new MojoExecutionException("Failed to invoke get(AsciiDoctor) for JRubyRuntimeContext", e1);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to invoke get for JRubyRuntimeContext", e);
            }
        }
        String gemHome = rubyInstance.evalScriptlet("ENV['GEM_HOME']").toString();
        String string = gemHomeExpected = gemPath == null || "".equals(gemPath) ? "" : gemPath.split(File.pathSeparator)[0];
        if (!"".equals(gemHome) && !gemHomeExpected.equals(gemHome)) {
            this.getLog().warn((CharSequence)("Using inherited external environment to resolve gems (" + gemHome + "), i.e. build is platform dependent!"));
        }
        return asciidoctor;
    }

    private List<File> scanSourceFiles() {
        List asciidoctorFiles;
        Object directoryWalker;
        if (this.sourceDocumentExtensions == null || this.sourceDocumentExtensions.isEmpty()) {
            directoryWalker = new AsciiDocDirectoryWalker(this.sourceDirectory.getAbsolutePath());
            asciidoctorFiles = directoryWalker.scan();
        } else {
            directoryWalker = new CustomExtensionDirectoryWalker(this.sourceDirectory.getAbsolutePath(), this.sourceDocumentExtensions);
            asciidoctorFiles = directoryWalker.scan();
        }
        String absoluteSourceDirectory = this.sourceDirectory.getAbsolutePath();
        Iterator iter = asciidoctorFiles.iterator();
        block0: while (iter.hasNext()) {
            File f = (File)iter.next();
            while (!absoluteSourceDirectory.equals(f.getAbsolutePath())) {
                if (f.getName().startsWith("_")) {
                    iter.remove();
                    continue block0;
                }
                if ((f = f.getParentFile()) != null) continue;
                continue block0;
            }
        }
        return asciidoctorFiles;
    }

    private void synchronize() {
        for (Synchronization synchronization : this.synchronizations) {
            this.synchronize(synchronization);
        }
    }

    protected void renderFile(Asciidoctor asciidoctor, Map<String, Object> options, File f) {
        asciidoctor.convertFile(f, options);
        this.logRenderedFile(f);
    }

    protected void logRenderedFile(File f) {
        this.getLog().info((CharSequence)("Rendered " + f.getAbsolutePath()));
    }

    protected void synchronize(Synchronization synchronization) {
        if (synchronization.getSource().isDirectory()) {
            try {
                FileUtils.copyDirectory((File)synchronization.getSource(), (File)synchronization.getTarget());
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)String.format("Can't synchronize %s -> %s", synchronization.getSource(), synchronization.getTarget()));
            }
        } else {
            try {
                FileUtils.copyFile((File)synchronization.getSource(), (File)synchronization.getTarget());
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)String.format("Can't synchronize %s -> %s", synchronization.getSource(), synchronization.getTarget()));
            }
        }
    }

    protected void ensureOutputExists() {
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            this.getLog().error((CharSequence)("Can't create " + this.outputDirectory.getPath()));
        }
    }

    protected void setOptionsOnBuilder(OptionsBuilder optionsBuilder) {
        optionsBuilder.backend(this.backend).safe(SafeMode.UNSAFE).headerFooter(this.headerFooter).eruby(this.eruby).mkDirs(true);
        if (this.sourcemap) {
            optionsBuilder.option("sourcemap", (Object)true);
        }
        if (this.catalogAssets) {
            optionsBuilder.option("catalog_assets", (Object)true);
        }
        if (!this.templateCache) {
            optionsBuilder.option("template_cache", (Object)false);
        }
        if (this.doctype != null) {
            optionsBuilder.docType(this.doctype);
        }
        if (this.templateEngine != null) {
            optionsBuilder.templateEngine(this.templateEngine);
        }
        if (this.templateDir != null) {
            optionsBuilder.templateDir(this.templateDir);
        }
        if (this.templateDirs != null) {
            optionsBuilder.templateDirs(this.templateDirs.toArray(new File[0]));
        }
    }

    protected void setAttributesOnBuilder(AttributesBuilder attributesBuilder) throws MojoExecutionException {
        if (this.sourceHighlighter != null) {
            attributesBuilder.sourceHighlighter(this.sourceHighlighter);
        }
        if (this.embedAssets) {
            attributesBuilder.linkCss(false);
            attributesBuilder.dataUri(true);
        }
        if (this.imagesDir != null) {
            attributesBuilder.imagesDir(this.imagesDir);
        }
        if (!("skip".equals(this.attributeMissing) || "drop".equals(this.attributeMissing) || "drop-line".equals(this.attributeMissing))) {
            throw new MojoExecutionException(this.attributeMissing + " is not valid. Must be one of 'skip', 'drop' or 'drop-line'");
        }
        attributesBuilder.attributeMissing(this.attributeMissing);
        if (!"drop".equals(this.attributeUndefined) && !"drop-line".equals(this.attributeUndefined)) {
            throw new MojoExecutionException(this.attributeUndefined + " is not valid. Must be one of 'drop' or 'drop-line'");
        }
        attributesBuilder.attributeUndefined(this.attributeUndefined);
        AsciidoctorHelper.addAttributes(this.attributes, attributesBuilder);
        if (!this.attributesChain.isEmpty()) {
            this.getLog().info((CharSequence)("Attributes: " + this.attributesChain));
            attributesBuilder.arguments(this.attributesChain);
        }
    }

    public File getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = new File(outputFile);
    }

    public String getBackend() {
        return this.backend;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public String getDoctype() {
        return this.doctype;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public boolean isHeaderFooter() {
        return this.headerFooter;
    }

    public void setHeaderFooter(boolean headerFooter) {
        this.headerFooter = headerFooter;
    }

    public String getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(String templateEngine) {
        this.templateEngine = templateEngine;
    }

    public String getImagesDir() {
        return this.imagesDir;
    }

    public void setImagesDir(String imagesDir) {
        this.imagesDir = imagesDir;
    }

    public String getSourceHighlighter() {
        return this.sourceHighlighter;
    }

    public void setSourceHighlighter(String sourceHighlighter) {
        this.sourceHighlighter = sourceHighlighter;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getSourceDocumentExtensions() {
        return this.sourceDocumentExtensions;
    }

    public void setSourceDocumentExtensions(List<String> sourceDocumentExtensions) {
        this.sourceDocumentExtensions = sourceDocumentExtensions;
    }

    public String getEruby() {
        return this.eruby;
    }

    public void setEruby(String eruby) {
        this.eruby = eruby;
    }

    public String getSourceDocumentName() {
        return this.sourceDocumentName;
    }

    public void setSourceDocumentName(String sourceDocumentName) {
        this.sourceDocumentName = sourceDocumentName;
    }

    public List<Synchronization> getSynchronizations() {
        return this.synchronizations;
    }

    public void setSynchronizations(List<Synchronization> synchronizations) {
        this.synchronizations = synchronizations;
    }

    public boolean isEmbedAssets() {
        return this.embedAssets;
    }

    public void setEmbedAssets(boolean embedAssets) {
        this.embedAssets = embedAssets;
    }

    public String getAttributeMissing() {
        return this.attributeMissing;
    }

    public void setAttributeMissing(String attributeMissing) {
        this.attributeMissing = attributeMissing;
    }

    public String getAttributeUndefined() {
        return this.attributeUndefined;
    }

    public void setAttributeUndefined(String attributeUndefined) {
        this.attributeUndefined = attributeUndefined;
    }

    public File getProjectDirectory() {
        return this.projectDirectory;
    }

    public void setProjectDirectory(File projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    public String getGemPath() {
        return this.gemPath;
    }

    public void setGemPath(String gemPath) {
        this.gemPath = gemPath;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setPreserveDirectories(boolean preserveDirectories) {
        this.preserveDirectories = preserveDirectories;
    }

    public void setRelativeBaseDir(boolean relativeBaseDir) {
        this.relativeBaseDir = relativeBaseDir;
    }

    public List<ExtensionConfiguration> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<ExtensionConfiguration> extensions) {
        this.extensions = extensions;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    private static class CustomExtensionDirectoryWalker
    extends AbstractDirectoryWalker {
        private final List<String> fileExtensions;

        public CustomExtensionDirectoryWalker(String absolutePath, List<String> fileExtensions) {
            super(absolutePath);
            this.fileExtensions = fileExtensions;
        }

        protected boolean isAcceptedFile(File filename) {
            String name = filename.getName();
            for (String extension : this.fileExtensions) {
                if (!name.endsWith(extension)) continue;
                return true;
            }
            return false;
        }
    }
}

