/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.xmlgraphics.image.GraphicsUtil;
import org.apache.xmlgraphics.ps.ImageEncoder;

public class ImageEncodingHelper {
    private static final ColorModel DEFAULT_RGB_COLOR_MODEL = new ComponentColorModel(ColorSpace.getInstance(1004), false, false, 1, 0);
    private RenderedImage image;
    private ColorModel encodedColorModel;
    private boolean firstTileDump;

    public ImageEncodingHelper(RenderedImage image) {
        this.image = image;
        this.determineEncodedColorModel();
    }

    public RenderedImage getImage() {
        return this.image;
    }

    public ColorModel getNativeColorModel() {
        return this.getImage().getColorModel();
    }

    public ColorModel getEncodedColorModel() {
        return this.encodedColorModel;
    }

    public boolean hasAlpha() {
        return this.image.getColorModel().hasAlpha();
    }

    public boolean isConverted() {
        return this.getNativeColorModel() != this.getEncodedColorModel();
    }

    private void writeRGBTo(OutputStream out) throws IOException {
        ImageEncodingHelper.encodeRenderedImageAsRGB(this.image, out);
    }

    /*
     * WARNING - void declaration
     */
    public static void encodeRenderedImageAsRGB(RenderedImage image, OutputStream out) throws IOException {
        Raster raster = image.getData();
        int nbands = raster.getNumBands();
        int dataType = raster.getDataBuffer().getDataType();
        switch (dataType) {
            case 0: {
                Object[] data = new byte[nbands];
                break;
            }
            case 1: {
                Object[] data = new short[nbands];
                break;
            }
            case 3: {
                Object[] data = new int[nbands];
                break;
            }
            case 4: {
                Object[] data = new float[nbands];
                break;
            }
            case 5: {
                Object[] data = new double[nbands];
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown data buffer type: " + dataType);
            }
        }
        ColorModel colorModel = image.getColorModel();
        int w = image.getWidth();
        int h = image.getHeight();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                void var3_5;
                int rgb = colorModel.getRGB(raster.getDataElements(x, y, var3_5));
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                out.write(r);
                out.write(g);
                out.write(b);
            }
        }
    }

    private boolean optimizedWriteTo(OutputStream out) throws IOException {
        Raster raster;
        DataBuffer buffer;
        if (this.firstTileDump && (buffer = (raster = this.image.getTile(0, 0)).getDataBuffer()) instanceof DataBufferByte) {
            out.write(((DataBufferByte)buffer).getData());
            return true;
        }
        return false;
    }

    protected boolean isMultiTile() {
        int tilesX = this.image.getNumXTiles();
        int tilesY = this.image.getNumYTiles();
        return tilesX != 1 || tilesY != 1;
    }

    protected void determineEncodedColorModel() {
        this.firstTileDump = false;
        this.encodedColorModel = DEFAULT_RGB_COLOR_MODEL;
        ColorModel cm = this.image.getColorModel();
        ColorSpace cs = cm.getColorSpace();
        int numComponents = cm.getNumComponents();
        if (!this.isMultiTile()) {
            if (numComponents == 1 && cs.getType() == 6) {
                if (cm.getTransferType() == 0) {
                    this.firstTileDump = true;
                    this.encodedColorModel = cm;
                }
            } else if (cm instanceof IndexColorModel) {
                if (cm.getTransferType() == 0) {
                    this.firstTileDump = true;
                    this.encodedColorModel = cm;
                }
            } else if (cm instanceof ComponentColorModel && numComponents == 3 && !cm.hasAlpha()) {
                Raster raster = this.image.getTile(0, 0);
                DataBuffer buffer = raster.getDataBuffer();
                if (cm.getTransferType() == 0 && buffer.getOffset() == 0 && buffer.getNumBanks() == 1) {
                    this.firstTileDump = true;
                    this.encodedColorModel = cm;
                }
            }
        }
    }

    public void encode(OutputStream out) throws IOException {
        if (!this.isConverted()) {
            this.optimizedWriteTo(out);
        } else {
            this.writeRGBTo(out);
        }
    }

    public void encodeAlpha(OutputStream out) throws IOException {
        if (!this.hasAlpha()) {
            throw new IllegalStateException("Image doesn't have an alpha channel");
        }
        Raster alpha = GraphicsUtil.getAlphaRaster(this.image);
        DataBuffer buffer = alpha.getDataBuffer();
        if (!(buffer instanceof DataBufferByte)) {
            throw new UnsupportedOperationException("Alpha raster not supported: " + buffer.getClass().getName());
        }
        out.write(((DataBufferByte)buffer).getData());
    }

    public static void encodePackedColorComponents(RenderedImage image, OutputStream out) throws IOException {
        ImageEncodingHelper helper = new ImageEncodingHelper(image);
        helper.encode(out);
    }

    public static ImageEncoder createRenderedImageEncoder(RenderedImage img) {
        return new RenderedImageEncoder(img);
    }

    private static class RenderedImageEncoder
    implements ImageEncoder {
        private RenderedImage img;

        public RenderedImageEncoder(RenderedImage img) {
            this.img = img;
        }

        public void writeTo(OutputStream out) throws IOException {
            ImageEncodingHelper.encodePackedColorComponents(this.img, out);
        }

        public String getImplicitFilter() {
            return null;
        }
    }
}

