/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFObject;
import org.apache.xmlgraphics.java2d.color.profile.ColorProfileUtil;

public class PDFICCBasedColorSpace
extends PDFObject
implements PDFColorSpace {
    private PDFICCStream iccStream;
    private String explicitName;
    private int numComponents;

    public PDFICCBasedColorSpace(String explicitName, PDFICCStream iccStream) {
        this.explicitName = explicitName;
        this.iccStream = iccStream;
        this.numComponents = iccStream.getICCProfile().getNumComponents();
    }

    public PDFICCBasedColorSpace(PDFICCStream iccStream) {
        this(null, iccStream);
    }

    public PDFICCStream getICCStream() {
        return this.iccStream;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public String getName() {
        if (this.explicitName != null) {
            return this.explicitName;
        }
        return "ICC" + this.iccStream.getObjectNumber();
    }

    public boolean isDeviceColorSpace() {
        return false;
    }

    public boolean isRGBColorSpace() {
        return this.getNumComponents() == 3;
    }

    public boolean isCMYKColorSpace() {
        return this.getNumComponents() == 4;
    }

    public boolean isGrayColorSpace() {
        return this.getNumComponents() == 1;
    }

    protected String toPDFString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("[/ICCBased ").append(this.getICCStream().referencePDF()).append("]");
        return sb.toString();
    }

    public static PDFICCBasedColorSpace setupsRGBAsDefaultRGBColorSpace(PDFDocument pdfDoc) {
        PDFICCStream sRGBProfile = PDFICCBasedColorSpace.setupsRGBColorProfile(pdfDoc);
        return pdfDoc.getFactory().makeICCBasedColorSpace(null, "DefaultRGB", sRGBProfile);
    }

    public static PDFICCBasedColorSpace setupsRGBColorSpace(PDFDocument pdfDoc) {
        PDFICCStream sRGBProfile = PDFICCBasedColorSpace.setupsRGBColorProfile(pdfDoc);
        return pdfDoc.getFactory().makeICCBasedColorSpace(null, null, sRGBProfile);
    }

    public static PDFICCStream setupsRGBColorProfile(PDFDocument pdfDoc) {
        ICC_Profile profile;
        PDFICCStream sRGBProfile = pdfDoc.getFactory().makePDFICCStream();
        InputStream in = PDFDocument.class.getResourceAsStream("sRGB Color Space Profile.icm");
        if (in != null) {
            try {
                profile = ColorProfileUtil.getICC_Profile((InputStream)in);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unexpected IOException loading the sRGB profile: " + ioe.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        } else {
            profile = ColorProfileUtil.getICC_Profile((int)1000);
        }
        sRGBProfile.setColorSpace(profile, null);
        return sRGBProfile;
    }
}

