/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.base14;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.Typeface;

public class Helvetica
extends Typeface {
    private static final String fontName = "Helvetica";
    private static final String fullName = "Helvetica";
    private static final Set familyNames;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 718;
    private static final int xHeight = 523;
    private static final int ascender = 718;
    private static final int descender = -207;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private static final Map kerning;
    private boolean enableKerning = false;

    public Helvetica() {
        this(false);
    }

    public Helvetica(boolean enableKerning) {
        this.enableKerning = enableKerning;
    }

    public String getEncoding() {
        return encoding;
    }

    public String getFontName() {
        return "Helvetica";
    }

    public String getEmbedFontName() {
        return this.getFontName();
    }

    public String getFullName() {
        return "Helvetica";
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    public FontType getFontType() {
        return FontType.TYPE1;
    }

    public int getAscender(int size) {
        return size * 718;
    }

    public int getCapHeight(int size) {
        return size * 718;
    }

    public int getDescender(int size) {
        return size * -207;
    }

    public int getXHeight(int size) {
        return size * 523;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    public int getWidth(int i, int size) {
        return size * width[i];
    }

    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    public boolean hasKerningInfo() {
        return this.enableKerning;
    }

    public Map getKerningInfo() {
        return kerning;
    }

    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        return '#';
    }

    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        width = new int[256];
        Helvetica.width[65] = 667;
        Helvetica.width[198] = 1000;
        Helvetica.width[193] = 667;
        Helvetica.width[194] = 667;
        Helvetica.width[196] = 667;
        Helvetica.width[192] = 667;
        Helvetica.width[197] = 667;
        Helvetica.width[195] = 667;
        Helvetica.width[66] = 667;
        Helvetica.width[67] = 722;
        Helvetica.width[199] = 722;
        Helvetica.width[68] = 722;
        Helvetica.width[69] = 667;
        Helvetica.width[201] = 667;
        Helvetica.width[202] = 667;
        Helvetica.width[203] = 667;
        Helvetica.width[200] = 667;
        Helvetica.width[208] = 722;
        Helvetica.width[128] = 556;
        Helvetica.width[70] = 611;
        Helvetica.width[71] = 778;
        Helvetica.width[72] = 722;
        Helvetica.width[73] = 278;
        Helvetica.width[205] = 278;
        Helvetica.width[206] = 278;
        Helvetica.width[207] = 278;
        Helvetica.width[204] = 278;
        Helvetica.width[74] = 500;
        Helvetica.width[75] = 667;
        Helvetica.width[76] = 556;
        Helvetica.width[77] = 833;
        Helvetica.width[78] = 722;
        Helvetica.width[209] = 722;
        Helvetica.width[79] = 778;
        Helvetica.width[140] = 1000;
        Helvetica.width[211] = 778;
        Helvetica.width[212] = 778;
        Helvetica.width[214] = 778;
        Helvetica.width[210] = 778;
        Helvetica.width[216] = 778;
        Helvetica.width[213] = 778;
        Helvetica.width[80] = 667;
        Helvetica.width[81] = 778;
        Helvetica.width[82] = 722;
        Helvetica.width[83] = 667;
        Helvetica.width[138] = 667;
        Helvetica.width[84] = 611;
        Helvetica.width[222] = 667;
        Helvetica.width[85] = 722;
        Helvetica.width[218] = 722;
        Helvetica.width[219] = 722;
        Helvetica.width[220] = 722;
        Helvetica.width[217] = 722;
        Helvetica.width[86] = 667;
        Helvetica.width[87] = 944;
        Helvetica.width[88] = 667;
        Helvetica.width[89] = 667;
        Helvetica.width[221] = 667;
        Helvetica.width[159] = 667;
        Helvetica.width[90] = 611;
        Helvetica.width[142] = 611;
        Helvetica.width[97] = 556;
        Helvetica.width[225] = 556;
        Helvetica.width[226] = 556;
        Helvetica.width[180] = 333;
        Helvetica.width[228] = 556;
        Helvetica.width[230] = 889;
        Helvetica.width[224] = 556;
        Helvetica.width[38] = 667;
        Helvetica.width[229] = 556;
        Helvetica.width[94] = 469;
        Helvetica.width[126] = 584;
        Helvetica.width[42] = 389;
        Helvetica.width[64] = 1015;
        Helvetica.width[227] = 556;
        Helvetica.width[98] = 556;
        Helvetica.width[92] = 278;
        Helvetica.width[124] = 260;
        Helvetica.width[123] = 334;
        Helvetica.width[125] = 334;
        Helvetica.width[91] = 278;
        Helvetica.width[93] = 278;
        Helvetica.width[166] = 260;
        Helvetica.width[149] = 350;
        Helvetica.width[99] = 500;
        Helvetica.width[231] = 500;
        Helvetica.width[184] = 333;
        Helvetica.width[162] = 556;
        Helvetica.width[136] = 333;
        Helvetica.width[58] = 278;
        Helvetica.width[44] = 278;
        Helvetica.width[169] = 737;
        Helvetica.width[164] = 556;
        Helvetica.width[100] = 556;
        Helvetica.width[134] = 556;
        Helvetica.width[135] = 556;
        Helvetica.width[176] = 400;
        Helvetica.width[168] = 333;
        Helvetica.width[247] = 584;
        Helvetica.width[36] = 556;
        Helvetica.width[101] = 556;
        Helvetica.width[233] = 556;
        Helvetica.width[234] = 556;
        Helvetica.width[235] = 556;
        Helvetica.width[232] = 556;
        Helvetica.width[56] = 556;
        Helvetica.width[133] = 1000;
        Helvetica.width[151] = 1000;
        Helvetica.width[150] = 556;
        Helvetica.width[61] = 584;
        Helvetica.width[240] = 556;
        Helvetica.width[33] = 278;
        Helvetica.width[161] = 333;
        Helvetica.width[102] = 278;
        Helvetica.width[53] = 556;
        Helvetica.width[131] = 556;
        Helvetica.width[52] = 556;
        Helvetica.width[103] = 556;
        Helvetica.width[223] = 611;
        Helvetica.width[96] = 333;
        Helvetica.width[62] = 584;
        Helvetica.width[171] = 556;
        Helvetica.width[187] = 556;
        Helvetica.width[139] = 333;
        Helvetica.width[155] = 333;
        Helvetica.width[104] = 556;
        Helvetica.width[45] = 333;
        Helvetica.width[105] = 222;
        Helvetica.width[237] = 278;
        Helvetica.width[238] = 278;
        Helvetica.width[239] = 278;
        Helvetica.width[236] = 278;
        Helvetica.width[106] = 222;
        Helvetica.width[107] = 500;
        Helvetica.width[108] = 222;
        Helvetica.width[60] = 584;
        Helvetica.width[172] = 584;
        Helvetica.width[109] = 833;
        Helvetica.width[175] = 333;
        Helvetica.width[181] = 556;
        Helvetica.width[215] = 584;
        Helvetica.width[110] = 556;
        Helvetica.width[57] = 556;
        Helvetica.width[241] = 556;
        Helvetica.width[35] = 556;
        Helvetica.width[111] = 556;
        Helvetica.width[243] = 556;
        Helvetica.width[244] = 556;
        Helvetica.width[246] = 556;
        Helvetica.width[156] = 944;
        Helvetica.width[242] = 556;
        Helvetica.width[49] = 556;
        Helvetica.width[189] = 834;
        Helvetica.width[188] = 834;
        Helvetica.width[185] = 333;
        Helvetica.width[170] = 370;
        Helvetica.width[186] = 365;
        Helvetica.width[248] = 611;
        Helvetica.width[245] = 556;
        Helvetica.width[112] = 556;
        Helvetica.width[182] = 537;
        Helvetica.width[40] = 333;
        Helvetica.width[41] = 333;
        Helvetica.width[37] = 889;
        Helvetica.width[46] = 278;
        Helvetica.width[183] = 278;
        Helvetica.width[137] = 1000;
        Helvetica.width[43] = 584;
        Helvetica.width[177] = 584;
        Helvetica.width[113] = 556;
        Helvetica.width[63] = 556;
        Helvetica.width[191] = 611;
        Helvetica.width[34] = 355;
        Helvetica.width[132] = 333;
        Helvetica.width[147] = 333;
        Helvetica.width[148] = 333;
        Helvetica.width[145] = 222;
        Helvetica.width[146] = 222;
        Helvetica.width[130] = 222;
        Helvetica.width[39] = 191;
        Helvetica.width[114] = 333;
        Helvetica.width[174] = 737;
        Helvetica.width[115] = 500;
        Helvetica.width[154] = 500;
        Helvetica.width[167] = 556;
        Helvetica.width[59] = 278;
        Helvetica.width[55] = 556;
        Helvetica.width[54] = 556;
        Helvetica.width[47] = 278;
        Helvetica.width[32] = 278;
        Helvetica.width[163] = 556;
        Helvetica.width[116] = 278;
        Helvetica.width[254] = 556;
        Helvetica.width[51] = 556;
        Helvetica.width[190] = 834;
        Helvetica.width[179] = 333;
        Helvetica.width[152] = 333;
        Helvetica.width[153] = 1000;
        Helvetica.width[50] = 556;
        Helvetica.width[178] = 333;
        Helvetica.width[117] = 556;
        Helvetica.width[250] = 556;
        Helvetica.width[251] = 556;
        Helvetica.width[252] = 556;
        Helvetica.width[249] = 556;
        Helvetica.width[95] = 556;
        Helvetica.width[118] = 500;
        Helvetica.width[119] = 722;
        Helvetica.width[120] = 500;
        Helvetica.width[121] = 500;
        Helvetica.width[253] = 500;
        Helvetica.width[255] = 500;
        Helvetica.width[165] = 556;
        Helvetica.width[122] = 500;
        Helvetica.width[158] = 500;
        Helvetica.width[48] = 556;
        kerning = new HashMap();
        Integer first = new Integer(107);
        Map<Integer, Integer> pairs = (HashMap<Integer, Integer>)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap<Integer, Integer>();
            kerning.put(first, pairs);
        }
        Integer second = new Integer(111);
        pairs.put(second, new Integer(-20));
        second = new Integer(101);
        pairs.put(second, new Integer(-20));
        first = new Integer(79);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-20));
        second = new Integer(87);
        pairs.put(second, new Integer(-30));
        second = new Integer(89);
        pairs.put(second, new Integer(-70));
        second = new Integer(84);
        pairs.put(second, new Integer(-40));
        second = new Integer(46);
        pairs.put(second, new Integer(-40));
        second = new Integer(86);
        pairs.put(second, new Integer(-50));
        second = new Integer(88);
        pairs.put(second, new Integer(-60));
        second = new Integer(44);
        pairs.put(second, new Integer(-40));
        first = new Integer(104);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(121);
        pairs.put(second, new Integer(-30));
        first = new Integer(87);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-30));
        second = new Integer(45);
        pairs.put(second, new Integer(-40));
        second = new Integer(79);
        pairs.put(second, new Integer(-20));
        second = new Integer(97);
        pairs.put(second, new Integer(-40));
        second = new Integer(65);
        pairs.put(second, new Integer(-50));
        second = new Integer(117);
        pairs.put(second, new Integer(-30));
        second = new Integer(121);
        pairs.put(second, new Integer(-20));
        second = new Integer(46);
        pairs.put(second, new Integer(-80));
        second = new Integer(101);
        pairs.put(second, new Integer(-30));
        second = new Integer(44);
        pairs.put(second, new Integer(-80));
        first = new Integer(99);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(107);
        pairs.put(second, new Integer(-20));
        second = new Integer(44);
        pairs.put(second, new Integer(-15));
        first = new Integer(112);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(121);
        pairs.put(second, new Integer(-30));
        second = new Integer(46);
        pairs.put(second, new Integer(-35));
        second = new Integer(44);
        pairs.put(second, new Integer(-35));
        first = new Integer(80);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-50));
        second = new Integer(97);
        pairs.put(second, new Integer(-40));
        second = new Integer(65);
        pairs.put(second, new Integer(-120));
        second = new Integer(46);
        pairs.put(second, new Integer(-180));
        second = new Integer(101);
        pairs.put(second, new Integer(-50));
        second = new Integer(44);
        pairs.put(second, new Integer(-180));
        first = new Integer(86);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-80));
        second = new Integer(45);
        pairs.put(second, new Integer(-80));
        second = new Integer(79);
        pairs.put(second, new Integer(-40));
        second = new Integer(58);
        pairs.put(second, new Integer(-40));
        second = new Integer(97);
        pairs.put(second, new Integer(-70));
        second = new Integer(65);
        pairs.put(second, new Integer(-80));
        second = new Integer(117);
        pairs.put(second, new Integer(-70));
        second = new Integer(46);
        pairs.put(second, new Integer(-125));
        second = new Integer(71);
        pairs.put(second, new Integer(-40));
        second = new Integer(101);
        pairs.put(second, new Integer(-80));
        second = new Integer(59);
        pairs.put(second, new Integer(-40));
        second = new Integer(44);
        pairs.put(second, new Integer(-125));
        first = new Integer(118);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-25));
        second = new Integer(97);
        pairs.put(second, new Integer(-25));
        second = new Integer(46);
        pairs.put(second, new Integer(-80));
        second = new Integer(101);
        pairs.put(second, new Integer(-25));
        second = new Integer(44);
        pairs.put(second, new Integer(-80));
        first = new Integer(59);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(32);
        pairs.put(second, new Integer(-50));
        first = new Integer(32);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(87);
        pairs.put(second, new Integer(-40));
        second = new Integer(147);
        pairs.put(second, new Integer(-30));
        second = new Integer(89);
        pairs.put(second, new Integer(-90));
        second = new Integer(84);
        pairs.put(second, new Integer(-50));
        second = new Integer(145);
        pairs.put(second, new Integer(-60));
        second = new Integer(86);
        pairs.put(second, new Integer(-50));
        first = new Integer(97);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-20));
        second = new Integer(121);
        pairs.put(second, new Integer(-30));
        second = new Integer(118);
        pairs.put(second, new Integer(-20));
        first = new Integer(65);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(79);
        pairs.put(second, new Integer(-30));
        second = new Integer(119);
        pairs.put(second, new Integer(-40));
        second = new Integer(87);
        pairs.put(second, new Integer(-50));
        second = new Integer(67);
        pairs.put(second, new Integer(-30));
        second = new Integer(81);
        pairs.put(second, new Integer(-30));
        second = new Integer(71);
        pairs.put(second, new Integer(-30));
        second = new Integer(86);
        pairs.put(second, new Integer(-70));
        second = new Integer(118);
        pairs.put(second, new Integer(-40));
        second = new Integer(85);
        pairs.put(second, new Integer(-50));
        second = new Integer(117);
        pairs.put(second, new Integer(-30));
        second = new Integer(89);
        pairs.put(second, new Integer(-100));
        second = new Integer(84);
        pairs.put(second, new Integer(-120));
        second = new Integer(121);
        pairs.put(second, new Integer(-40));
        first = new Integer(70);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-30));
        second = new Integer(114);
        pairs.put(second, new Integer(-45));
        second = new Integer(97);
        pairs.put(second, new Integer(-50));
        second = new Integer(65);
        pairs.put(second, new Integer(-80));
        second = new Integer(46);
        pairs.put(second, new Integer(-150));
        second = new Integer(101);
        pairs.put(second, new Integer(-30));
        second = new Integer(44);
        pairs.put(second, new Integer(-150));
        first = new Integer(85);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-40));
        second = new Integer(46);
        pairs.put(second, new Integer(-40));
        second = new Integer(44);
        pairs.put(second, new Integer(-40));
        first = new Integer(115);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-30));
        second = new Integer(46);
        pairs.put(second, new Integer(-15));
        second = new Integer(44);
        pairs.put(second, new Integer(-15));
        first = new Integer(122);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-15));
        second = new Integer(101);
        pairs.put(second, new Integer(-15));
        first = new Integer(83);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(46);
        pairs.put(second, new Integer(-20));
        second = new Integer(44);
        pairs.put(second, new Integer(-20));
        first = new Integer(111);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-15));
        second = new Integer(121);
        pairs.put(second, new Integer(-30));
        second = new Integer(46);
        pairs.put(second, new Integer(-40));
        second = new Integer(120);
        pairs.put(second, new Integer(-30));
        second = new Integer(118);
        pairs.put(second, new Integer(-15));
        second = new Integer(44);
        pairs.put(second, new Integer(-40));
        first = new Integer(68);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(65);
        pairs.put(second, new Integer(-40));
        second = new Integer(87);
        pairs.put(second, new Integer(-40));
        second = new Integer(89);
        pairs.put(second, new Integer(-90));
        second = new Integer(46);
        pairs.put(second, new Integer(-70));
        second = new Integer(86);
        pairs.put(second, new Integer(-70));
        second = new Integer(44);
        pairs.put(second, new Integer(-70));
        first = new Integer(146);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(100);
        pairs.put(second, new Integer(-50));
        second = new Integer(32);
        pairs.put(second, new Integer(-70));
        second = new Integer(146);
        pairs.put(second, new Integer(-57));
        second = new Integer(114);
        pairs.put(second, new Integer(-50));
        second = new Integer(115);
        pairs.put(second, new Integer(-50));
        first = new Integer(82);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(79);
        pairs.put(second, new Integer(-20));
        second = new Integer(87);
        pairs.put(second, new Integer(-30));
        second = new Integer(85);
        pairs.put(second, new Integer(-40));
        second = new Integer(89);
        pairs.put(second, new Integer(-50));
        second = new Integer(84);
        pairs.put(second, new Integer(-30));
        second = new Integer(86);
        pairs.put(second, new Integer(-50));
        first = new Integer(75);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-40));
        second = new Integer(79);
        pairs.put(second, new Integer(-50));
        second = new Integer(117);
        pairs.put(second, new Integer(-30));
        second = new Integer(121);
        pairs.put(second, new Integer(-50));
        second = new Integer(101);
        pairs.put(second, new Integer(-40));
        first = new Integer(119);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-10));
        second = new Integer(97);
        pairs.put(second, new Integer(-15));
        second = new Integer(46);
        pairs.put(second, new Integer(-60));
        second = new Integer(101);
        pairs.put(second, new Integer(-10));
        second = new Integer(44);
        pairs.put(second, new Integer(-60));
        first = new Integer(58);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(32);
        pairs.put(second, new Integer(-50));
        first = new Integer(114);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(107);
        pairs.put(second, new Integer(15));
        second = new Integer(58);
        pairs.put(second, new Integer(30));
        second = new Integer(112);
        pairs.put(second, new Integer(30));
        second = new Integer(108);
        pairs.put(second, new Integer(15));
        second = new Integer(118);
        pairs.put(second, new Integer(30));
        second = new Integer(44);
        pairs.put(second, new Integer(-50));
        second = new Integer(59);
        pairs.put(second, new Integer(30));
        second = new Integer(105);
        pairs.put(second, new Integer(15));
        second = new Integer(109);
        pairs.put(second, new Integer(25));
        second = new Integer(97);
        pairs.put(second, new Integer(-10));
        second = new Integer(117);
        pairs.put(second, new Integer(15));
        second = new Integer(116);
        pairs.put(second, new Integer(40));
        second = new Integer(121);
        pairs.put(second, new Integer(30));
        second = new Integer(46);
        pairs.put(second, new Integer(-50));
        second = new Integer(110);
        pairs.put(second, new Integer(25));
        first = new Integer(67);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(46);
        pairs.put(second, new Integer(-30));
        second = new Integer(44);
        pairs.put(second, new Integer(-30));
        first = new Integer(145);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(145);
        pairs.put(second, new Integer(-57));
        first = new Integer(103);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(114);
        pairs.put(second, new Integer(-10));
        first = new Integer(66);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(85);
        pairs.put(second, new Integer(-10));
        second = new Integer(46);
        pairs.put(second, new Integer(-20));
        second = new Integer(44);
        pairs.put(second, new Integer(-20));
        first = new Integer(81);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(85);
        pairs.put(second, new Integer(-10));
        first = new Integer(76);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(-140));
        second = new Integer(146);
        pairs.put(second, new Integer(-160));
        second = new Integer(87);
        pairs.put(second, new Integer(-70));
        second = new Integer(89);
        pairs.put(second, new Integer(-140));
        second = new Integer(121);
        pairs.put(second, new Integer(-30));
        second = new Integer(84);
        pairs.put(second, new Integer(-110));
        second = new Integer(86);
        pairs.put(second, new Integer(-110));
        first = new Integer(98);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(-20));
        second = new Integer(121);
        pairs.put(second, new Integer(-20));
        second = new Integer(46);
        pairs.put(second, new Integer(-40));
        second = new Integer(108);
        pairs.put(second, new Integer(-20));
        second = new Integer(98);
        pairs.put(second, new Integer(-10));
        second = new Integer(118);
        pairs.put(second, new Integer(-20));
        second = new Integer(44);
        pairs.put(second, new Integer(-40));
        first = new Integer(44);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(-100));
        second = new Integer(146);
        pairs.put(second, new Integer(-100));
        first = new Integer(148);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(32);
        pairs.put(second, new Integer(-40));
        first = new Integer(109);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(-10));
        second = new Integer(121);
        pairs.put(second, new Integer(-15));
        first = new Integer(248);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(107);
        pairs.put(second, new Integer(-55));
        second = new Integer(104);
        pairs.put(second, new Integer(-55));
        second = new Integer(99);
        pairs.put(second, new Integer(-55));
        second = new Integer(112);
        pairs.put(second, new Integer(-55));
        second = new Integer(113);
        pairs.put(second, new Integer(-55));
        second = new Integer(118);
        pairs.put(second, new Integer(-70));
        second = new Integer(105);
        pairs.put(second, new Integer(-55));
        second = new Integer(97);
        pairs.put(second, new Integer(-55));
        second = new Integer(117);
        pairs.put(second, new Integer(-55));
        second = new Integer(116);
        pairs.put(second, new Integer(-55));
        second = new Integer(106);
        pairs.put(second, new Integer(-55));
        second = new Integer(115);
        pairs.put(second, new Integer(-55));
        second = new Integer(122);
        pairs.put(second, new Integer(-55));
        second = new Integer(100);
        pairs.put(second, new Integer(-55));
        second = new Integer(111);
        pairs.put(second, new Integer(-55));
        second = new Integer(119);
        pairs.put(second, new Integer(-70));
        second = new Integer(114);
        pairs.put(second, new Integer(-55));
        second = new Integer(103);
        pairs.put(second, new Integer(-55));
        second = new Integer(108);
        pairs.put(second, new Integer(-55));
        second = new Integer(98);
        pairs.put(second, new Integer(-55));
        second = new Integer(44);
        pairs.put(second, new Integer(-95));
        second = new Integer(109);
        pairs.put(second, new Integer(-55));
        second = new Integer(102);
        pairs.put(second, new Integer(-55));
        second = new Integer(121);
        pairs.put(second, new Integer(-70));
        second = new Integer(46);
        pairs.put(second, new Integer(-95));
        second = new Integer(110);
        pairs.put(second, new Integer(-55));
        second = new Integer(120);
        pairs.put(second, new Integer(-85));
        second = new Integer(101);
        pairs.put(second, new Integer(-55));
        first = new Integer(102);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(60));
        second = new Integer(111);
        pairs.put(second, new Integer(-30));
        second = new Integer(146);
        pairs.put(second, new Integer(50));
        second = new Integer(97);
        pairs.put(second, new Integer(-30));
        second = new Integer(46);
        pairs.put(second, new Integer(-30));
        second = new Integer(101);
        pairs.put(second, new Integer(-30));
        second = new Integer(44);
        pairs.put(second, new Integer(-30));
        first = new Integer(74);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(97);
        pairs.put(second, new Integer(-20));
        second = new Integer(65);
        pairs.put(second, new Integer(-20));
        second = new Integer(117);
        pairs.put(second, new Integer(-20));
        second = new Integer(46);
        pairs.put(second, new Integer(-30));
        second = new Integer(44);
        pairs.put(second, new Integer(-30));
        first = new Integer(89);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-140));
        second = new Integer(45);
        pairs.put(second, new Integer(-140));
        second = new Integer(105);
        pairs.put(second, new Integer(-20));
        second = new Integer(79);
        pairs.put(second, new Integer(-85));
        second = new Integer(58);
        pairs.put(second, new Integer(-60));
        second = new Integer(97);
        pairs.put(second, new Integer(-140));
        second = new Integer(65);
        pairs.put(second, new Integer(-110));
        second = new Integer(117);
        pairs.put(second, new Integer(-110));
        second = new Integer(46);
        pairs.put(second, new Integer(-140));
        second = new Integer(101);
        pairs.put(second, new Integer(-140));
        second = new Integer(59);
        pairs.put(second, new Integer(-60));
        second = new Integer(44);
        pairs.put(second, new Integer(-140));
        first = new Integer(121);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-20));
        second = new Integer(97);
        pairs.put(second, new Integer(-20));
        second = new Integer(46);
        pairs.put(second, new Integer(-100));
        second = new Integer(101);
        pairs.put(second, new Integer(-20));
        second = new Integer(44);
        pairs.put(second, new Integer(-100));
        first = new Integer(84);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(111);
        pairs.put(second, new Integer(-120));
        second = new Integer(79);
        pairs.put(second, new Integer(-40));
        second = new Integer(58);
        pairs.put(second, new Integer(-20));
        second = new Integer(119);
        pairs.put(second, new Integer(-120));
        second = new Integer(114);
        pairs.put(second, new Integer(-120));
        second = new Integer(44);
        pairs.put(second, new Integer(-120));
        second = new Integer(59);
        pairs.put(second, new Integer(-20));
        second = new Integer(45);
        pairs.put(second, new Integer(-140));
        second = new Integer(65);
        pairs.put(second, new Integer(-120));
        second = new Integer(97);
        pairs.put(second, new Integer(-120));
        second = new Integer(117);
        pairs.put(second, new Integer(-120));
        second = new Integer(121);
        pairs.put(second, new Integer(-120));
        second = new Integer(46);
        pairs.put(second, new Integer(-120));
        second = new Integer(101);
        pairs.put(second, new Integer(-120));
        first = new Integer(46);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(148);
        pairs.put(second, new Integer(-100));
        second = new Integer(32);
        pairs.put(second, new Integer(-60));
        second = new Integer(146);
        pairs.put(second, new Integer(-100));
        first = new Integer(110);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(117);
        pairs.put(second, new Integer(-10));
        second = new Integer(121);
        pairs.put(second, new Integer(-15));
        second = new Integer(118);
        pairs.put(second, new Integer(-20));
        first = new Integer(120);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(101);
        pairs.put(second, new Integer(-30));
        first = new Integer(101);
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = new Integer(119);
        pairs.put(second, new Integer(-20));
        second = new Integer(121);
        pairs.put(second, new Integer(-20));
        second = new Integer(46);
        pairs.put(second, new Integer(-15));
        second = new Integer(120);
        pairs.put(second, new Integer(-30));
        second = new Integer(118);
        pairs.put(second, new Integer(-30));
        second = new Integer(44);
        pairs.put(second, new Integer(-15));
        familyNames = new HashSet();
        familyNames.add("Helvetica");
    }
}

