/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.apache.wink.common.internal.MultivaluedMapImpl;
import org.apache.wink.common.internal.PathSegmentImpl;
import org.apache.wink.common.internal.uri.UriEncoder;
import org.apache.wink.common.internal.uritemplate.JaxRsUriTemplateProcessor;
import org.apache.wink.common.internal.utils.UriHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriBuilderImpl
extends UriBuilder
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(UriBuilderImpl.class);
    private String scheme;
    private String userInfo;
    private String host;
    private int port;
    private String fragment;
    private List<PathSegment> segments;
    private MultivaluedMap<String, String> query;
    private String schemeSpecificPart;
    private boolean isFirstCall;

    public UriBuilderImpl() {
        this.reset();
        this.isFirstCall = true;
    }

    public void reset() {
        logger.debug("Entered reset");
        this.scheme = null;
        this.resetSchemeSpecificPart();
        this.query = null;
        this.fragment = null;
        logger.debug("Exit reset");
    }

    private void resetSchemeSpecificPart() {
        logger.debug("Entered resetSchemeSpecificPart");
        this.schemeSpecificPart = null;
        this.userInfo = null;
        this.host = null;
        this.port = -1;
        this.segments = null;
        logger.debug("Exit resetSchemeSpecificPart");
    }

    private List<PathSegment> getPathSegments() {
        if (this.segments == null) {
            this.segments = new ArrayList<PathSegment>();
        }
        logger.debug("getPathSegments returning {}", this.segments);
        return this.segments;
    }

    private MultivaluedMap<String, String> getQuery() {
        if (this.query == null) {
            this.query = new MultivaluedMapImpl<String, String>();
        }
        logger.debug("getQuery returning {}", this.query);
        return this.query;
    }

    private String constructPathString() {
        if (this.segments == null) {
            logger.debug("constructPathString() returning null because null segments");
            return null;
        }
        StringBuilder path = new StringBuilder();
        for (PathSegment segment : this.segments) {
            String segmentStr = segment.toString();
            path.append("/");
            path.append(segmentStr);
            logger.debug("appending {} from path segment to path", (Object)segmentStr);
        }
        String str = path.toString();
        logger.debug("constructPathString() returning {}", (Object)str);
        return str;
    }

    private String constructQueryString() {
        if (this.query == null) {
            logger.debug("constructQueryString returning null beause null");
            return null;
        }
        if (this.query.size() == 0) {
            logger.debug("constructQueryString returning empty string because string size is 0");
            return "";
        }
        String queryStr = "?" + MultivaluedMapImpl.toString(this.query, "&");
        logger.debug("constructQueryString returning {}", (Object)queryStr);
        return queryStr;
    }

    private Set<String> getVariableNamesList() {
        logger.debug("getVariableNamesList() entry");
        String constructedPath = this.constructPathString();
        String constructedQuery = this.constructQueryString();
        String uriStr = UriHelper.contructUri(this.scheme, this.userInfo, this.host, this.port, constructedPath, constructedQuery, this.fragment);
        JaxRsUriTemplateProcessor uriTemplate = new JaxRsUriTemplateProcessor(uriStr);
        Set<String> ret = uriTemplate.getVariableNames();
        logger.debug("getVariableNamesList() returning {}", ret);
        return ret;
    }

    private URI buildInternal(Map<String, ? extends Object> values) throws IllegalArgumentException, UriBuilderException {
        if (logger.isDebugEnabled()) {
            logger.debug("buildInternal({}) entry", values);
        }
        StringBuilder out = new StringBuilder();
        this.buildScheme(values, out);
        this.buildAuthority(values, out);
        this.buildPath(values, out);
        this.buildQuery(values, out);
        this.buildFragment(values, out);
        String uriString = out.toString();
        try {
            logger.debug("buildInternal() exit", (Object)uriString);
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new UriBuilderException((Throwable)e);
        }
    }

    private void buildScheme(Map<String, ? extends Object> values, StringBuilder out) {
        logger.debug("buildScheme({}, {}) entry", values, (Object)out);
        if (this.scheme == null) {
            logger.debug("buildScheme() is null so returning");
            return;
        }
        JaxRsUriTemplateProcessor.expand(this.scheme, MultivaluedMapImpl.toMultivaluedMapString(values), out);
        out.append(':');
        logger.debug("buildScheme() exit changed out to {}", (Object)out);
    }

    private void buildAuthority(Map<String, ? extends Object> values, StringBuilder out) {
        logger.debug("buildAuthority({}, {}) entry", values, (Object)out);
        if (this.userInfo == null && this.host == null && this.port == -1) {
            logger.debug("buildAuthority() is null so returning");
            return;
        }
        out.append("//");
        if (this.userInfo != null) {
            String eUserInfo = JaxRsUriTemplateProcessor.expand(this.userInfo, MultivaluedMapImpl.toMultivaluedMapString(values));
            eUserInfo = UriEncoder.encodeUserInfo(eUserInfo, true);
            out.append(eUserInfo);
            out.append('@');
        }
        if (this.host != null) {
            JaxRsUriTemplateProcessor.expand(this.host, MultivaluedMapImpl.toMultivaluedMapString(values), out);
        }
        if (this.port != -1) {
            out.append(':');
            out.append(this.port);
        }
        logger.debug("buildAuthority() exit changed out to {}", (Object)out);
    }

    private void buildPath(Map<String, ? extends Object> values, StringBuilder out) {
        if (logger.isDebugEnabled()) {
            logger.debug("buildPath({}, {}) entry", new Object[]{values, out});
        }
        if (this.segments == null || this.segments.size() == 0) {
            logger.debug("buildPath() segments is null or empty so returning");
            return;
        }
        boolean first = true;
        for (PathSegment segment : this.segments) {
            String segmentPath = segment.getPath();
            String eSegmentPath = JaxRsUriTemplateProcessor.expand(segmentPath, MultivaluedMapImpl.toMultivaluedMapString(values));
            eSegmentPath = UriEncoder.encodePath(eSegmentPath, true);
            if (out.length() > 0 && out.charAt(out.length() - 1) != '/' || out.length() == 0 && !first) {
                out.append('/');
            }
            first = false;
            out.append(eSegmentPath);
            MultivaluedMap matrixParameters = segment.getMatrixParameters();
            for (String matrix : matrixParameters.keySet()) {
                String eMatrix = JaxRsUriTemplateProcessor.expand(matrix, MultivaluedMapImpl.toMultivaluedMapString(values));
                eMatrix = UriEncoder.encodeMatrix(eMatrix, true);
                for (String matrixValue : (List)matrixParameters.get((Object)matrix)) {
                    String eValue = JaxRsUriTemplateProcessor.expand(matrixValue, MultivaluedMapImpl.toMultivaluedMapString(values));
                    eValue = UriEncoder.encodeMatrix(eValue, true);
                    out.append(';');
                    out.append(eMatrix);
                    out.append('=');
                    out.append(eValue);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("buildPath() exit changes out to {} ", (Object)out);
        }
    }

    private void buildQuery(Map<String, ? extends Object> values, StringBuilder out) {
        if (logger.isDebugEnabled()) {
            logger.debug("buildQuery({}, {}) entry", values, (Object)out);
        }
        if (this.query == null || this.query.size() == 0) {
            logger.debug("buildQuery() exit - query is null");
            return;
        }
        int delim = 63;
        for (String queryParam : this.query.keySet()) {
            String eQueryParam = JaxRsUriTemplateProcessor.expand(queryParam, MultivaluedMapImpl.toMultivaluedMapString(values));
            eQueryParam = UriEncoder.encodeQueryParam(eQueryParam, true);
            for (String queryValue : (List)this.query.get((Object)queryParam)) {
                String eQueryValue = JaxRsUriTemplateProcessor.expand(queryValue, MultivaluedMapImpl.toMultivaluedMapString(values));
                eQueryValue = UriEncoder.encodeQueryParam(eQueryValue, true);
                out.append((char)delim);
                out.append(eQueryParam);
                delim = 38;
                if (eQueryValue == null) continue;
                out.append('=');
                out.append(eQueryValue);
            }
        }
        logger.debug("buildQuery() exit - changes out to {}", (Object)out);
    }

    private void buildFragment(Map<String, ? extends Object> values, StringBuilder out) {
        logger.debug("buildFragment({}, {})", values, (Object)out);
        if (this.fragment == null) {
            return;
        }
        String eFragment = JaxRsUriTemplateProcessor.expand(this.fragment, MultivaluedMapImpl.toMultivaluedMapString(values));
        eFragment = UriEncoder.encodeFragment(eFragment, true);
        out.append('#');
        out.append(eFragment);
        logger.debug("buildFragment() exit - changes out to {}", (Object)out);
    }

    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return this.build(true, values);
    }

    public URI buildFromEncoded(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return this.build(false, values);
    }

    private URI build(boolean escapePercent, Object ... values) throws IllegalArgumentException, UriBuilderException {
        if (logger.isDebugEnabled()) {
            logger.debug("build({}, {}) enFtry", (Object)escapePercent, Arrays.asList(values));
        }
        if (this.schemeSpecificPart != null) {
            try {
                URI uri = new URI(this.scheme, this.schemeSpecificPart, this.fragment);
                if (logger.isDebugEnabled()) {
                    logger.debug("build() returning {}", (Object)uri.toString());
                }
                return uri;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("schemeSpecificPart is invalid", e);
            }
        }
        Set<String> names = this.getVariableNamesList();
        if (values == null || names.size() > values.length) {
            throw new IllegalArgumentException("missing variable values");
        }
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        int i = 0;
        for (String name : names) {
            if (values[i] == null) {
                throw new IllegalArgumentException("value for variable " + name + " is null");
            }
            if (valuesMap.get(name) == null) {
                String value = values[i].toString();
                if (escapePercent) {
                    value = this.escapePercent(value);
                }
                valuesMap.put(name, value);
                logger.debug("name: {} has value : {}", (Object)name, (Object)value);
            }
            ++i;
        }
        while (i < values.length) {
            if (values[i] == null) {
                throw new IllegalArgumentException("value argument at " + i + "index is null");
            }
            ++i;
        }
        return this.buildInternal(valuesMap);
    }

    public URI buildFromMap(Map<String, ? extends Object> values) throws IllegalArgumentException, UriBuilderException {
        return this.buildFromMap(true, values);
    }

    public URI buildFromEncodedMap(Map<String, ? extends Object> values) throws IllegalArgumentException, UriBuilderException {
        return this.buildFromMap(false, values);
    }

    private URI buildFromMap(boolean escapePercent, Map<String, ? extends Object> values) throws IllegalArgumentException, UriBuilderException {
        if (logger.isDebugEnabled()) {
            logger.debug("buildFromMap({}, {})", (Object)escapePercent, values);
        }
        Set<String> names = this.getVariableNamesList();
        if (values == null || names.size() > values.size()) {
            throw new IllegalArgumentException("missing variable values");
        }
        logger.debug("names are {}", names);
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        for (String name : names) {
            Object value = values.get(name);
            if (value == null) {
                throw new IllegalArgumentException("value for variable " + name + " is null");
            }
            if (valuesMap.get(name) != null) continue;
            String valueToPut = value.toString();
            if (escapePercent) {
                valueToPut = this.escapePercent(valueToPut);
            }
            valuesMap.put(name, valueToPut);
            logger.debug("name {} set to value {}", (Object)name, (Object)valueToPut);
        }
        return this.buildInternal(valuesMap);
    }

    private String escapePercent(String string) {
        logger.debug("escapePercent({}) entry", (Object)string);
        StringBuilder out = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                out.append("%25");
                continue;
            }
            out.append(c);
        }
        String ret = out.toString();
        logger.debug("escapePercent() return {}", (Object)ret);
        return ret;
    }

    public UriBuilder clone() {
        logger.debug("clone() entry");
        UriBuilderImpl uriBuilder = new UriBuilderImpl();
        uriBuilder.scheme(this.scheme);
        uriBuilder.userInfo(this.userInfo);
        uriBuilder.host(this.host);
        uriBuilder.port(this.port);
        uriBuilder.fragment(this.fragment);
        uriBuilder.segments(this.segments);
        uriBuilder.query(this.query);
        logger.debug("clone() exit");
        return uriBuilder;
    }

    private void query(MultivaluedMap<String, String> query) {
        logger.debug("query({}) entry", query);
        if (query == null) {
            logger.debug("query exit");
            return;
        }
        this.query = ((MultivaluedMapImpl)query).clone();
        logger.debug("query exit");
    }

    private void segments(List<PathSegment> pathSegments) {
        logger.debug("segments({}) entry", pathSegments);
        if (pathSegments == null) {
            logger.debug("segments() exit");
            return;
        }
        this.segments = new ArrayList<PathSegment>();
        for (PathSegment segment : pathSegments) {
            this.segments.add(((PathSegmentImpl)segment).clone());
        }
        logger.debug("segments() exit");
    }

    public UriBuilder fragment(String fragment) {
        logger.debug("fragment({}) entry", (Object)fragment);
        this.fragment = fragment;
        logger.debug("fragment() exit");
        return this;
    }

    public UriBuilder host(String host) throws IllegalArgumentException {
        logger.debug("host({}) entry", (Object)host);
        if ("".equals(host)) {
            throw new IllegalArgumentException("host is empty");
        }
        this.host = host;
        logger.debug("host() exit");
        return this;
    }

    public UriBuilder matrixParam(String name, Object ... values) throws IllegalArgumentException {
        if (logger.isDebugEnabled()) {
            logger.debug("matrixParam({}, {}) entry", (Object)name, values == null ? null : Arrays.asList(values));
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("values is null");
        }
        PathSegmentImpl lastSegment = this.getLastPathSegment();
        for (Object value : values) {
            lastSegment.getMatrixParameters().add((Object)name, (Object)value.toString());
            if (!logger.isDebugEnabled()) continue;
            logger.debug("lastSegment add({}, {})", (Object)name, (Object)value.toString());
        }
        logger.debug("matrixParam exit");
        return this;
    }

    private PathSegmentImpl getLastPathSegment() {
        logger.debug("getLastPathSegment() entry");
        List<PathSegment> pathSegments = this.getPathSegments();
        logger.debug("getPathSegments() is {}", pathSegments);
        PathSegmentImpl lastSegment = null;
        int lastSegmentIndex = pathSegments.size() - 1;
        if (lastSegmentIndex >= 0) {
            lastSegment = (PathSegmentImpl)pathSegments.get(lastSegmentIndex);
        } else {
            lastSegment = new PathSegmentImpl("");
            pathSegments.add(lastSegment);
        }
        logger.debug("getLastPathSegment() returning {}", (Object)lastSegment);
        return lastSegment;
    }

    public UriBuilder path(String path) throws IllegalArgumentException {
        logger.debug("path({}) entry", (Object)path);
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if ("".equals(path)) {
            return this;
        }
        if (this.isFirstCall) {
            String[] segments;
            if (path.indexOf(":") != -1 && (segments = path.split(":", 2)).length == 2 && segments[0].length() > 0 && segments[0].indexOf("{") == -1) {
                String scheme = segments[0];
                if ((segments = segments[1].split("#", 2))[0].length() > 0) {
                    String schemeSpecificPart = segments[0];
                    String fragment = null;
                    if (segments.length == 2) {
                        fragment = segments[1];
                    }
                    this.scheme(scheme);
                    this.schemeSpecificPart(schemeSpecificPart);
                    this.fragment(fragment);
                    logger.debug("replacePath() exit");
                    return this;
                }
            }
            this.isFirstCall = false;
        }
        String _path = path;
        if (path.startsWith("//")) {
            if (path.length() > 2) {
                _path = path.substring(2);
                this.getPathSegments().add(new PathSegmentImpl("/"));
            } else {
                logger.debug("path() exit");
                return this;
            }
        }
        List<PathSegment> list = UriHelper.parsePath(_path);
        logger.debug("path is {}", list);
        for (PathSegment segment : list) {
            this.segment(segment.getPath());
            MultivaluedMap matrixParameters = segment.getMatrixParameters();
            for (String matrix : matrixParameters.keySet()) {
                this.matrixParam(matrix, ((List)matrixParameters.get((Object)matrix)).toArray());
            }
        }
        logger.debug("path() exit");
        return this;
    }

    public UriBuilder path(Class resource) throws IllegalArgumentException {
        logger.debug("path({}) entry", (Object)resource);
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        this.isFirstCall = false;
        Path pathAnnotation = resource.getAnnotation(Path.class);
        if (pathAnnotation == null) {
            throw new IllegalArgumentException("resource is not annotated with Path");
        }
        String path = pathAnnotation.value();
        logger.debug("path annotation value is {}", (Object)path);
        this.path(path);
        logger.debug("path() exit");
        return this;
    }

    public UriBuilder path(Method method) throws IllegalArgumentException {
        logger.debug("path({}) entry", (Object)method);
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        Path pathAnnotation = method.getAnnotation(Path.class);
        if (pathAnnotation == null) {
            throw new IllegalArgumentException("method is not annotated with Path");
        }
        String path = pathAnnotation.value();
        logger.debug("path method annotation is {}", (Object)path);
        this.path(path);
        logger.debug("path() exit");
        return this;
    }

    public UriBuilder path(Class resource, String method) throws IllegalArgumentException {
        Method[] methods;
        logger.debug("path({}, {}) entry", (Object)resource, (Object)method);
        if (resource == null) {
            throw new IllegalArgumentException("resource is null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        Method foundMethod = null;
        for (Method m : methods = resource.getDeclaredMethods()) {
            Path pathAnnotation;
            if (!m.getName().equals(method) || (pathAnnotation = m.getAnnotation(Path.class)) == null) continue;
            if (foundMethod != null) {
                throw new IllegalArgumentException("more than one method with Path annotation exists");
            }
            foundMethod = m;
        }
        if (foundMethod == null) {
            throw new IllegalArgumentException("no method with Path annotation exists");
        }
        this.path(foundMethod);
        logger.debug("path() exit");
        return this;
    }

    public UriBuilder port(int port) throws IllegalArgumentException {
        if (logger.isDebugEnabled()) {
            logger.debug("port({}) entry", (Object)port);
        }
        if (port < -1) {
            throw new IllegalArgumentException("port is not valid");
        }
        this.port = port;
        logger.debug("port() exit");
        return this;
    }

    public UriBuilder queryParam(String name, Object ... values) throws IllegalArgumentException {
        if (logger.isDebugEnabled()) {
            logger.debug("queryParam({}, {}) entry", (Object)name, values == null ? null : Arrays.asList(values));
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("values is null");
        }
        MultivaluedMap<String, String> query = this.getQuery();
        logger.debug("query map is {}", query);
        for (Object value : values) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            query.add((Object)name, (Object)(value != null ? value.toString() : null));
        }
        logger.debug("queryParam() exit");
        return this;
    }

    public UriBuilder replaceMatrix(String matrix) throws IllegalArgumentException {
        logger.debug("replaceMatrix({}) entry", (Object)matrix);
        PathSegmentImpl lastPathSegment = this.getLastPathSegment();
        lastPathSegment.clearAllMatrixParameters();
        PathSegmentImpl tmpPathSegment = new PathSegmentImpl("", matrix);
        MultivaluedMap<String, String> matrixParameters = tmpPathSegment.getMatrixParameters();
        for (String param : matrixParameters.keySet()) {
            List matrixValues = (List)matrixParameters.get((Object)param);
            this.matrixParam(param, matrixValues.toArray());
        }
        logger.debug("replaceMatrix() exit");
        return this;
    }

    public UriBuilder replaceMatrixParam(String name, Object ... values) throws IllegalArgumentException {
        if (logger.isDebugEnabled()) {
            logger.debug("replaceMatrixParam({}, {})", (Object)name, values == null ? null : Arrays.asList(values));
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        PathSegmentImpl lastPathSegment = this.getLastPathSegment();
        if (values == null || values.length == 0) {
            lastPathSegment.clearMatrixParameter(name);
        } else {
            List valuesList = (List)lastPathSegment.getMatrixParameters().get((Object)name);
            if (valuesList != null) {
                valuesList.clear();
            }
            this.matrixParam(name, values);
        }
        logger.debug("replaceMatrixParam() exit");
        return this;
    }

    public UriBuilder replacePath(String path) {
        String[] segments;
        logger.debug("replacePath({}) entry", (Object)path);
        if (this.isFirstCall) {
            if (path == null) {
                throw new IllegalArgumentException("path is null");
            }
            this.isFirstCall = false;
        }
        if (path == null) {
            logger.debug("path is null. resetting");
            this.reset();
            logger.debug("replacePath() exit");
            return this;
        }
        this.getPathSegments().clear();
        if (path.indexOf(":") != -1 && (segments = path.split(":", 2)).length == 2 && segments[0].length() > 0 && segments[0].indexOf("{") == -1) {
            String scheme = segments[0];
            if ((segments = segments[1].split("#", 2))[0].length() > 0) {
                String schemeSpecificPart = segments[0];
                String fragment = null;
                if (segments.length == 2) {
                    fragment = segments[1];
                }
                this.scheme(scheme);
                this.schemeSpecificPart(schemeSpecificPart);
                this.fragment(fragment);
                logger.debug("replacePath() exit");
                return this;
            }
        }
        if (path != null && !"".equals(path)) {
            this.path(path);
        }
        logger.debug("replacePath() exit");
        return this;
    }

    public UriBuilder replaceQuery(String query) throws IllegalArgumentException {
        logger.debug("replaceQuery({}) entry", (Object)query);
        this.getQuery().clear();
        if (query != null) {
            query = query.replaceAll(" ", "%20");
            MultivaluedMap<String, String> queries = UriHelper.parseQuery(query);
            logger.debug("queries after parsing: {}", queries);
            MultivaluedMap<String, String> queryValues = this.getQuery();
            for (String name : queries.keySet()) {
                List values = (List)queries.get((Object)name);
                for (String v : values) {
                    if (v == null) {
                        queryValues.add((Object)name, null);
                        continue;
                    }
                    this.queryParam(name, v);
                }
            }
        }
        logger.debug("replaceQuery() exit");
        return this;
    }

    public UriBuilder replaceQueryParam(String name, Object ... values) throws IllegalArgumentException {
        if (logger.isDebugEnabled()) {
            logger.debug("replaceQueryParam({}, {}) entry", (Object)name, values == null ? null : Arrays.asList(values));
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.getQuery().remove((Object)name);
        if (values != null) {
            this.queryParam(name, values);
        }
        logger.debug("replaceQueryParam() exit");
        return this;
    }

    public UriBuilder scheme(String scheme) throws IllegalArgumentException {
        logger.debug("scheme({}) entry", (Object)scheme);
        this.scheme = scheme;
        logger.debug("scheme() exit");
        return this;
    }

    public UriBuilder schemeSpecificPart(String ssp) throws IllegalArgumentException {
        logger.debug("schemeSpecificPart({}) entry", (Object)ssp);
        if (ssp == null) {
            throw new IllegalArgumentException("schemeSpecificPart is null");
        }
        if (!ssp.startsWith("/")) {
            this.schemeSpecificPart = ssp;
            return this;
        }
        URI uri = null;
        try {
            uri = new URI(this.scheme, ssp, this.fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("schemeSpecificPart is invalid", e);
        }
        this.resetSchemeSpecificPart();
        if (uri.getRawUserInfo() != null) {
            this.userInfo(UriEncoder.decodeString(uri.getRawUserInfo()));
        }
        if (uri.getHost() != null) {
            this.host(UriEncoder.decodeString(uri.getHost()));
        }
        if (uri.getPort() != -1) {
            this.port(uri.getPort());
        }
        if (uri.getRawPath() != null) {
            String path = uri.getRawPath();
            if (this.host == null && uri.getRawAuthority() != null) {
                path = UriEncoder.decodeString(uri.getRawAuthority()) + "/" + path;
            }
            this.path(UriEncoder.decodeString(path));
        }
        logger.debug("schemeSpecificPart() exit");
        return this;
    }

    public UriBuilder segment(String ... segments) throws IllegalArgumentException {
        if (logger.isDebugEnabled()) {
            logger.debug("segment({}) entry", segments == null ? null : Arrays.asList(segments));
        }
        if (segments == null) {
            throw new IllegalArgumentException("segments is null");
        }
        List<PathSegment> pathSegments = this.getPathSegments();
        for (int i = 0; i < segments.length; ++i) {
            if (segments[i] == null) {
                throw new IllegalArgumentException("segment at index " + i + " is null");
            }
            if (segments[i].contains("/")) {
                String segValue = segments[i].replace("/", "%2F");
                pathSegments.add(new PathSegmentImpl(segValue));
                continue;
            }
            pathSegments.add(new PathSegmentImpl(segments[i]));
        }
        logger.debug("segment() exit");
        return this;
    }

    public UriBuilder userInfo(String ui) {
        logger.debug("userInfo({}) entry", (Object)ui);
        this.userInfo = ui;
        logger.debug("userInfo() exit");
        return this;
    }

    public UriBuilder uri(URI uri) throws IllegalArgumentException {
        logger.debug("Entering uri({})", (Object)uri);
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        this.isFirstCall = false;
        if (uri.getScheme() != null) {
            logger.debug("Constructing scheme");
            this.scheme(uri.getScheme());
        }
        if (uri.getRawUserInfo() != null) {
            logger.debug("Constructing userInfo");
            this.userInfo(uri.getRawUserInfo());
        }
        if (uri.getHost() != null) {
            logger.debug("Constructing host");
            this.host(uri.getHost());
        }
        if (uri.getPort() != -1) {
            logger.debug("Constructing port");
            this.port(uri.getPort());
        }
        if (uri.getRawPath() != null) {
            logger.debug("Constructing rawPath");
            this.path(uri.getRawPath());
        }
        if (uri.getRawQuery() != null) {
            logger.debug("Constructing rawQuery");
            this.replaceQuery(uri.getRawQuery());
        }
        if (uri.getRawFragment() != null) {
            logger.debug("Constructing fragment");
            this.fragment(uri.getRawFragment());
        }
        if (uri.getRawSchemeSpecificPart() != null) {
            logger.debug("Constructing schemeSpecificPart");
            this.schemeSpecificPart(uri.getRawSchemeSpecificPart());
        }
        logger.debug("uri() exit");
        return this;
    }
}

