/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.basic;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.extensions.markup.html.basic.ILinkParser;
import org.apache.wicket.extensions.markup.html.basic.ILinkRenderStrategy;
import org.apache.wicket.util.string.Strings;

public class LinkParser
implements ILinkParser {
    private final Map<String, ILinkRenderStrategy> renderStrategies = new HashMap<String, ILinkRenderStrategy>();

    public ILinkParser addLinkRenderStrategy(String pattern, ILinkRenderStrategy renderStrategy) {
        this.renderStrategies.put(pattern, renderStrategy);
        return this;
    }

    public String parse(String text) {
        if (Strings.isEmpty((CharSequence)text)) {
            return text;
        }
        String work = text;
        if (work.indexOf(60) == -1) {
            for (String pattern : this.renderStrategies.keySet()) {
                ILinkRenderStrategy strategy = this.renderStrategies.get(pattern);
                Matcher matcher = Pattern.compile(pattern, 32).matcher(work);
                StringBuffer buffer = new StringBuffer();
                while (matcher.find()) {
                    String str = matcher.group();
                    matcher.appendReplacement(buffer, strategy.buildLink(str));
                }
                matcher.appendTail(buffer);
                work = buffer.toString();
            }
        }
        return work;
    }
}

