/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.OrderByBorder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IStyledColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadersToolbar
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;

    public HeadersToolbar(DataTable<?> table, ISortStateLocator stateLocator) {
        super(table);
        IColumn<?>[] columns;
        RepeatingView headers = new RepeatingView("headers");
        this.add(new Component[]{headers});
        for (final IColumn<?> column : columns = table.getColumns()) {
            WebMarkupContainer item = new WebMarkupContainer(headers.newChildId());
            headers.add(new Component[]{item});
            WebMarkupContainer header = null;
            header = column.isSortable() ? this.newSortableHeader("header", column.getSortProperty(), stateLocator) : new WebMarkupContainer("header");
            if (column instanceof IStyledColumn) {
                header.add(new IBehavior[]{new DataTable.CssAttributeBehavior(){
                    private static final long serialVersionUID = 1L;

                    protected String getCssClass() {
                        return ((IStyledColumn)column).getCssClass();
                    }
                }});
            }
            item.add(new Component[]{header});
            item.setRenderBodyOnly(true);
            header.add(new Component[]{column.getHeader("label")});
        }
    }

    protected WebMarkupContainer newSortableHeader(String headerId, String property, ISortStateLocator locator) {
        return new OrderByBorder(headerId, property, locator){
            private static final long serialVersionUID = 1L;

            protected void onSortChanged() {
                HeadersToolbar.this.getTable().setCurrentPage(0);
            }
        };
    }
}

