/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.breadcrumb.panel;

import java.lang.reflect.Constructor;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbModel;
import org.apache.wicket.extensions.breadcrumb.panel.BreadCrumbPanel;
import org.apache.wicket.extensions.breadcrumb.panel.IBreadCrumbPanelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BreadCrumbPanelFactory
implements IBreadCrumbPanelFactory {
    private static final long serialVersionUID = 1L;
    private final Class<? extends BreadCrumbPanel> panelClass;

    public BreadCrumbPanelFactory(Class<? extends BreadCrumbPanel> panelClass) {
        if (panelClass == null) {
            throw new IllegalArgumentException("argument panelClass must be not null");
        }
        if (!BreadCrumbPanel.class.isAssignableFrom(panelClass)) {
            throw new IllegalArgumentException("argument panelClass (" + panelClass + ") must extend class " + BreadCrumbPanel.class.getName());
        }
        this.panelClass = panelClass;
        this.getConstructor();
    }

    @Override
    public final BreadCrumbPanel create(String componentId, IBreadCrumbModel breadCrumbModel) {
        Constructor<? extends BreadCrumbPanel> ctor = this.getConstructor();
        try {
            return ctor.newInstance(componentId, breadCrumbModel);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private final Constructor<? extends BreadCrumbPanel> getConstructor() {
        try {
            Constructor<? extends BreadCrumbPanel> ctor = this.panelClass.getConstructor(String.class, IBreadCrumbModel.class);
            return ctor;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

