/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.palette.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;

public class Recorder
extends HiddenField {
    private static final long serialVersionUID = 1L;
    private static final String[] EMPTY_IDS = new String[0];
    private String[] ids;
    private Palette palette;
    private boolean attached = false;

    public Palette getPalette() {
        return this.palette;
    }

    public Recorder(String id, Palette palette) {
        super(id);
        this.palette = palette;
        this.setModel((IModel)new Model());
        this.setOutputMarkupId(true);
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        if (!this.getForm().hasError()) {
            this.initIds();
        }
        this.attached = true;
    }

    private void initIds() {
        IChoiceRenderer renderer = this.getPalette().getChoiceRenderer();
        StringBuffer modelStringBuffer = new StringBuffer();
        Iterator selection = this.getPalette().getModelCollection().iterator();
        int i = 0;
        while (selection.hasNext()) {
            modelStringBuffer.append(renderer.getIdValue(selection.next(), i++));
            if (!selection.hasNext()) continue;
            modelStringBuffer.append(",");
        }
        String modelString = modelStringBuffer.toString();
        this.setModel((IModel)new Model((Serializable)((Object)modelString)));
        this.updateIds(modelString);
    }

    protected void onValid() {
        super.onValid();
        if (this.attached) {
            this.updateIds();
        }
    }

    public Iterator getSelectedChoices() {
        IChoiceRenderer renderer = this.getPalette().getChoiceRenderer();
        if (this.ids.length == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList selected = new ArrayList(this.ids.length);
        block0: for (int i = 0; i < this.ids.length; ++i) {
            Iterator it = this.getPalette().getChoices().iterator();
            while (it.hasNext()) {
                Object choice = it.next();
                if (!renderer.getIdValue(choice, 0).equals(this.ids[i])) continue;
                selected.add(choice);
                continue block0;
            }
        }
        return selected.iterator();
    }

    public Iterator getUnselectedChoices() {
        IChoiceRenderer renderer = this.getPalette().getChoiceRenderer();
        Collection choices = this.getPalette().getChoices();
        if (choices.size() - this.ids.length == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList unselected = new ArrayList(Math.max(1, choices.size() - this.ids.length));
        Iterator it = choices.iterator();
        while (it.hasNext()) {
            Object choice = it.next();
            String choiceId = renderer.getIdValue(choice, 0);
            boolean selected = false;
            for (int i = 0; i < this.ids.length; ++i) {
                if (!this.ids[i].equals(choiceId)) continue;
                selected = true;
                break;
            }
            if (selected) continue;
            unselected.add(choice);
        }
        return unselected.iterator();
    }

    protected void onInvalid() {
        super.onInvalid();
        if (this.attached) {
            this.updateIds();
        }
    }

    private void updateIds() {
        this.updateIds(this.getValue());
    }

    private void updateIds(String value) {
        this.ids = Strings.isEmpty((CharSequence)value) ? EMPTY_IDS : value.split(",");
    }
}

