/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.breadcrumb.panel;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.extensions.breadcrumb.IBreadCrumbParticipant;

public abstract class BreadCrumbParticipantDelegate
implements IBreadCrumbParticipant {
    private static final long serialVersionUID = 1L;
    private final Component component;

    public BreadCrumbParticipantDelegate(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("component must be not null");
        }
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public void onActivate(IBreadCrumbParticipant previous) {
        if (previous != null) {
            MarkupContainer parent = previous.getComponent().getParent();
            if (parent != null) {
                final String thisId = this.component.getId();
                if (parent.get(thisId) != null) {
                    parent.replace(this.component);
                } else {
                    Component c = (Component)parent.visitChildren(new Component.IVisitor(){

                        public Object component(Component component) {
                            if (component.getId().equals(thisId)) {
                                return component;
                            }
                            return Component.IVisitor.CONTINUE_TRAVERSAL;
                        }
                    });
                    if (c == null) {
                        c = (Component)parent.visitParents(Component.class, new Component.IVisitor(){

                            public Object component(Component component) {
                                if (component.getId().equals(thisId)) {
                                    return component;
                                }
                                return Component.IVisitor.CONTINUE_TRAVERSAL;
                            }
                        });
                    }
                    if (c != null) {
                        c.replaceWith(this.component);
                    }
                }
            }
        } else if (this.component.getParent() != null) {
            this.component.getParent().replace(this.component);
        }
    }
}

