/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.catalina.startup.UserConfig;
import org.apache.catalina.startup.UserDatabase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.StringManager;

public final class PasswdUserDatabase
implements UserDatabase {
    private static final Log log = LogFactory.getLog(PasswdUserDatabase.class);
    private static final StringManager sm = StringManager.getManager(PasswdUserDatabase.class);
    private static final String PASSWORD_FILE = "/etc/passwd";
    private Hashtable<String, String> homes = new Hashtable();
    private UserConfig userConfig = null;

    @Override
    public UserConfig getUserConfig() {
        return this.userConfig;
    }

    @Override
    public void setUserConfig(UserConfig userConfig) {
        this.userConfig = userConfig;
        this.init();
    }

    @Override
    public String getHome(String user) {
        return this.homes.get(user);
    }

    @Override
    public Enumeration<String> getUsers() {
        return this.homes.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(PASSWORD_FILE));
            String line = reader.readLine();
            while (line != null) {
                String[] tokens = line.split(":");
                if (tokens.length > 5 && tokens[0].length() > 0 && tokens[5].length() > 0) {
                    this.homes.put(tokens[0], tokens[5]);
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            log.warn((Object)sm.getString("passwdUserDatabase.readFail"), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

