/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.security.Principal;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.SingleSignOn;

public class SingleSignOnEntry {
    protected String authType = null;
    protected String password = null;
    protected Principal principal = null;
    protected Session[] sessions = new Session[0];
    protected String username = null;
    protected boolean canReauthenticate = false;

    public SingleSignOnEntry(Principal principal, String authType, String username, String password) {
        this.updateCredentials(principal, authType, username, password);
    }

    public synchronized void addSession(SingleSignOn sso, Session session) {
        for (int i = 0; i < this.sessions.length; ++i) {
            if (session != this.sessions[i]) continue;
            return;
        }
        Session[] results = new Session[this.sessions.length + 1];
        System.arraycopy(this.sessions, 0, results, 0, this.sessions.length);
        results[this.sessions.length] = session;
        this.sessions = results;
        session.addSessionListener(sso);
    }

    public synchronized void removeSession(Session session) {
        Session[] nsessions = new Session[this.sessions.length - 1];
        int j = 0;
        for (int i = 0; i < this.sessions.length; ++i) {
            if (session == this.sessions[i]) continue;
            nsessions[j++] = this.sessions[i];
        }
        this.sessions = nsessions;
    }

    public synchronized Session[] findSessions() {
        return this.sessions;
    }

    public String getAuthType() {
        return this.authType;
    }

    public boolean getCanReauthenticate() {
        return this.canReauthenticate;
    }

    public String getPassword() {
        return this.password;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public String getUsername() {
        return this.username;
    }

    public void updateCredentials(Principal principal, String authType, String username, String password) {
        this.principal = principal;
        this.authType = authType;
        this.username = username;
        this.password = password;
        this.canReauthenticate = "BASIC".equals(authType) || "FORM".equals(authType);
    }
}

