/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.naming.NamingException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.xml.ws.WebServiceRef;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.security.SecurityUtil;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class DefaultInstanceManager
implements InstanceManager {
    private final javax.naming.Context context;
    private final Map<String, Map<String, String>> injectionMap;
    protected final ClassLoader classLoader;
    protected final ClassLoader containerClassLoader;
    protected boolean privileged;
    protected boolean ignoreAnnotations;
    private Properties restrictedFilters = new Properties();
    private Properties restrictedListeners = new Properties();
    private Properties restrictedServlets = new Properties();
    private final Map<Class<?>, WeakReference<List<AnnotationCacheEntry>>> annotationCache = new WeakHashMap();

    public DefaultInstanceManager(javax.naming.Context context, Map<String, Map<String, String>> injectionMap, Context catalinaContext, ClassLoader containerClassLoader) {
        InputStream is;
        this.classLoader = catalinaContext.getLoader().getClassLoader();
        this.privileged = catalinaContext.getPrivileged();
        this.containerClassLoader = containerClassLoader;
        this.ignoreAnnotations = catalinaContext.getIgnoreAnnotations();
        StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/core/RestrictedServlets.properties");
            if (is != null) {
                this.restrictedServlets.load(is);
            } else {
                catalinaContext.getLogger().error((Object)sm.getString("defaultInstanceManager.restrictedServletsResource"));
            }
        }
        catch (IOException e) {
            catalinaContext.getLogger().error((Object)sm.getString("defaultInstanceManager.restrictedServletsResource"), (Throwable)e);
        }
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/core/RestrictedListeners.properties");
            if (is != null) {
                this.restrictedListeners.load(is);
            } else {
                catalinaContext.getLogger().error((Object)sm.getString("defaultInstanceManager.restrictedListenersResources"));
            }
        }
        catch (IOException e) {
            catalinaContext.getLogger().error((Object)sm.getString("defaultInstanceManager.restrictedListenersResources"), (Throwable)e);
        }
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/core/RestrictedFilters.properties");
            if (is != null) {
                this.restrictedFilters.load(is);
            } else {
                catalinaContext.getLogger().error((Object)sm.getString("defaultInstanceManager.restrictedFiltersResources"));
            }
        }
        catch (IOException e) {
            catalinaContext.getLogger().error((Object)sm.getString("defaultInstanceManager.restrictedServletsResources"), (Throwable)e);
        }
        this.context = context;
        this.injectionMap = injectionMap;
    }

    public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = this.loadClassMaybePrivileged(className, this.classLoader);
        return this.newInstance(clazz.newInstance(), clazz);
    }

    public Object newInstance(String className, ClassLoader classLoader) throws IllegalAccessException, NamingException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = classLoader.loadClass(className);
        return this.newInstance(clazz.newInstance(), clazz);
    }

    public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
        this.newInstance(o, o.getClass());
    }

    private Object newInstance(Object instance, Class<?> clazz) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (!this.ignoreAnnotations) {
            Map<String, String> injections = this.injectionMap.get(clazz.getName());
            this.populateAnnotationsCache(clazz, injections);
            this.processAnnotations(instance, injections);
            this.postConstruct(instance, clazz);
        }
        return instance;
    }

    public void destroyInstance(Object instance) throws IllegalAccessException, InvocationTargetException {
        if (!this.ignoreAnnotations) {
            this.preDestroy(instance, instance.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postConstruct(Object instance, Class<?> clazz) throws IllegalAccessException, InvocationTargetException {
        List annotations;
        if (this.context == null) {
            return;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class) {
            this.postConstruct(instance, superClass);
        }
        Map<Class<?>, WeakReference<List<AnnotationCacheEntry>>> map = this.annotationCache;
        synchronized (map) {
            annotations = (List)this.annotationCache.get(clazz).get();
        }
        for (AnnotationCacheEntry entry : annotations) {
            if (entry.getType() != AnnotationCacheEntryType.POST_CONSTRUCT) continue;
            Method postConstruct = (Method)entry.getAccessibleObject();
            boolean accessibility = postConstruct.isAccessible();
            Method method = postConstruct;
            synchronized (method) {
                postConstruct.setAccessible(true);
                postConstruct.invoke(instance, new Object[0]);
                postConstruct.setAccessible(accessibility);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preDestroy(Object instance, Class<?> clazz) throws IllegalAccessException, InvocationTargetException {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class) {
            this.preDestroy(instance, superClass);
        }
        List annotations = null;
        Map<Class<?>, WeakReference<List<AnnotationCacheEntry>>> map = this.annotationCache;
        synchronized (map) {
            WeakReference<List<AnnotationCacheEntry>> ref = this.annotationCache.get(clazz);
            if (ref != null) {
                annotations = (List)ref.get();
            }
        }
        if (annotations == null) {
            return;
        }
        for (AnnotationCacheEntry entry : annotations) {
            if (entry.getType() != AnnotationCacheEntryType.PRE_DESTROY) continue;
            Method preDestroy = (Method)entry.getAccessibleObject();
            boolean accessibility = preDestroy.isAccessible();
            Method method = preDestroy;
            synchronized (method) {
                preDestroy.setAccessible(true);
                preDestroy.invoke(instance, new Object[0]);
                preDestroy.setAccessible(accessibility);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateAnnotationsCache(Class<?> clazz, Map<String, String> injections) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (this.context == null) {
            return;
        }
        while (clazz != null) {
            List<Object> annotations = null;
            Map<Class<?>, WeakReference<List<AnnotationCacheEntry>>> map = this.annotationCache;
            synchronized (map) {
                WeakReference<List<AnnotationCacheEntry>> ref = this.annotationCache.get(clazz);
                if (ref != null) {
                    annotations = (ArrayList<AnnotationCacheEntry>)ref.get();
                }
            }
            if (annotations != null) break;
            annotations = new ArrayList<AnnotationCacheEntry>();
            Field[] fields = null;
            if (Globals.IS_SECURITY_ENABLED) {
                final Class<?> clazz2 = clazz;
                fields = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

                    @Override
                    public Field[] run() {
                        return clazz2.getDeclaredFields();
                    }
                });
            } else {
                fields = clazz.getDeclaredFields();
            }
            for (Field field : fields) {
                Resource annotation;
                if (injections != null && injections.containsKey(field.getName())) {
                    annotations.add(new AnnotationCacheEntry(field, injections.get(field.getName()), AnnotationCacheEntryType.FIELD));
                    continue;
                }
                if (field.isAnnotationPresent(Resource.class)) {
                    annotation = field.getAnnotation(Resource.class);
                    annotations.add(new AnnotationCacheEntry(field, annotation.name(), AnnotationCacheEntryType.FIELD));
                    continue;
                }
                if (field.isAnnotationPresent(EJB.class)) {
                    annotation = field.getAnnotation(EJB.class);
                    annotations.add(new AnnotationCacheEntry(field, annotation.name(), AnnotationCacheEntryType.FIELD));
                    continue;
                }
                if (field.isAnnotationPresent(WebServiceRef.class)) {
                    annotation = field.getAnnotation(WebServiceRef.class);
                    annotations.add(new AnnotationCacheEntry(field, annotation.name(), AnnotationCacheEntryType.FIELD));
                    continue;
                }
                if (field.isAnnotationPresent(PersistenceContext.class)) {
                    annotation = field.getAnnotation(PersistenceContext.class);
                    annotations.add(new AnnotationCacheEntry(field, annotation.name(), AnnotationCacheEntryType.FIELD));
                    continue;
                }
                if (!field.isAnnotationPresent(PersistenceUnit.class)) continue;
                annotation = field.getAnnotation(PersistenceUnit.class);
                annotations.add(new AnnotationCacheEntry(field, annotation.name(), AnnotationCacheEntryType.FIELD));
            }
            Method[] methods = null;
            if (Globals.IS_SECURITY_ENABLED) {
                final Class<?> clazz2 = clazz;
                methods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                    @Override
                    public Method[] run() {
                        return clazz2.getDeclaredMethods();
                    }
                });
            } else {
                methods = clazz.getDeclaredMethods();
            }
            Method postConstruct = null;
            Method preDestroy = null;
            for (Method method : methods) {
                Resource annotation;
                String fieldName;
                String methodName = method.getName();
                if (injections != null && methodName.startsWith("set") && methodName.length() > 3 && injections.containsKey(fieldName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4))) {
                    annotations.add(new AnnotationCacheEntry(method, injections.get(method.getName()), AnnotationCacheEntryType.FIELD));
                    break;
                }
                if (method.isAnnotationPresent(Resource.class)) {
                    annotation = method.getAnnotation(Resource.class);
                    annotations.add(new AnnotationCacheEntry(method, annotation.name(), AnnotationCacheEntryType.FIELD));
                } else if (method.isAnnotationPresent(EJB.class)) {
                    annotation = method.getAnnotation(EJB.class);
                    annotations.add(new AnnotationCacheEntry(method, annotation.name(), AnnotationCacheEntryType.FIELD));
                } else if (method.isAnnotationPresent(WebServiceRef.class)) {
                    annotation = method.getAnnotation(WebServiceRef.class);
                    annotations.add(new AnnotationCacheEntry(method, annotation.name(), AnnotationCacheEntryType.FIELD));
                } else if (method.isAnnotationPresent(PersistenceContext.class)) {
                    annotation = method.getAnnotation(PersistenceContext.class);
                    annotations.add(new AnnotationCacheEntry(method, annotation.name(), AnnotationCacheEntryType.FIELD));
                } else if (method.isAnnotationPresent(PersistenceUnit.class)) {
                    annotation = method.getAnnotation(PersistenceUnit.class);
                    annotations.add(new AnnotationCacheEntry(method, annotation.name(), AnnotationCacheEntryType.FIELD));
                }
                if (method.isAnnotationPresent(PostConstruct.class)) {
                    if (postConstruct != null || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                        throw new IllegalArgumentException("Invalid PostConstruct annotation");
                    }
                    postConstruct = method;
                }
                if (!method.isAnnotationPresent(PreDestroy.class)) continue;
                if (preDestroy != null || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                    throw new IllegalArgumentException("Invalid PreDestroy annotation");
                }
                preDestroy = method;
            }
            if (postConstruct != null) {
                annotations.add(new AnnotationCacheEntry(postConstruct, null, AnnotationCacheEntryType.POST_CONSTRUCT));
            }
            if (preDestroy != null) {
                annotations.add(new AnnotationCacheEntry(preDestroy, null, AnnotationCacheEntryType.PRE_DESTROY));
            }
            if (annotations.size() == 0) {
                annotations = Collections.emptyList();
            }
            Map<Class<?>, WeakReference<List<AnnotationCacheEntry>>> map2 = this.annotationCache;
            synchronized (map2) {
                this.annotationCache.put(clazz, new WeakReference<List<Object>>(annotations));
            }
            clazz = clazz.getSuperclass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAnnotations(Object instance, Map<String, String> injections) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (this.context == null) {
            return;
        }
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            List annotations;
            Map<Class<?>, WeakReference<List<AnnotationCacheEntry>>> map = this.annotationCache;
            synchronized (map) {
                annotations = (List)this.annotationCache.get(clazz).get();
            }
            for (AnnotationCacheEntry entry : annotations) {
                if (entry.getType() != AnnotationCacheEntryType.FIELD) continue;
                if (entry.getAccessibleObject() instanceof Method) {
                    DefaultInstanceManager.lookupMethodResource(this.context, instance, (Method)entry.getAccessibleObject(), entry.getName(), clazz);
                    continue;
                }
                DefaultInstanceManager.lookupFieldResource(this.context, instance, (Field)entry.getAccessibleObject(), entry.getName(), clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getAnnotationCacheSize() {
        Map<Class<?>, WeakReference<List<AnnotationCacheEntry>>> map = this.annotationCache;
        synchronized (map) {
            return this.annotationCache.size();
        }
    }

    protected Class<?> loadClassMaybePrivileged(final String className, final ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws Exception {
                        return DefaultInstanceManager.this.loadClass(className, classLoader);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)t;
                }
                throw new RuntimeException(t);
            }
        } else {
            clazz = this.loadClass(className, classLoader);
        }
        this.checkAccess(clazz);
        return clazz;
    }

    protected Class<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (className.startsWith("org.apache.catalina")) {
            return this.containerClassLoader.loadClass(className);
        }
        try {
            Class<?> clazz = this.containerClassLoader.loadClass(className);
            if (ContainerServlet.class.isAssignableFrom(clazz)) {
                return clazz;
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
        }
        return classLoader.loadClass(className);
    }

    private void checkAccess(Class<?> clazz) {
        if (this.privileged) {
            return;
        }
        if (Filter.class.isAssignableFrom(clazz)) {
            this.checkAccess(clazz, this.restrictedFilters);
        } else if (Servlet.class.isAssignableFrom(clazz)) {
            if (ContainerServlet.class.isAssignableFrom(clazz)) {
                throw new SecurityException("Restricted (ContainerServlet) " + clazz);
            }
            this.checkAccess(clazz, this.restrictedServlets);
        } else {
            this.checkAccess(clazz, this.restrictedListeners);
        }
    }

    private void checkAccess(Class<?> clazz, Properties restricted) {
        while (clazz != null) {
            if ("restricted".equals(restricted.getProperty(clazz.getName()))) {
                throw new SecurityException("Restricted " + clazz);
            }
            clazz = clazz.getSuperclass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void lookupFieldResource(javax.naming.Context context, Object instance, Field field, String name, Class<?> clazz) throws NamingException, IllegalAccessException {
        String normalizedName = DefaultInstanceManager.normalize(name);
        Object lookedupResource = normalizedName != null && normalizedName.length() > 0 ? context.lookup(normalizedName) : context.lookup(clazz.getName() + "/" + field.getName());
        boolean accessibility = field.isAccessible();
        Field field2 = field;
        synchronized (field2) {
            field.setAccessible(true);
            field.set(instance, lookedupResource);
            field.setAccessible(accessibility);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void lookupMethodResource(javax.naming.Context context, Object instance, Method method, String name, Class<?> clazz) throws NamingException, IllegalAccessException, InvocationTargetException {
        if (!method.getName().startsWith("set") || method.getName().length() < 4 || method.getParameterTypes().length != 1 || !method.getReturnType().getName().equals("void")) {
            throw new IllegalArgumentException("Invalid method resource injection annotation");
        }
        String normalizedName = DefaultInstanceManager.normalize(name);
        Object lookedupResource = normalizedName != null && normalizedName.length() > 0 ? context.lookup(normalizedName) : context.lookup(clazz.getName() + "/" + DefaultInstanceManager.getName(method));
        boolean accessibility = method.isAccessible();
        Method method2 = method;
        synchronized (method2) {
            method.setAccessible(true);
            method.invoke(instance, lookedupResource);
            method.setAccessible(accessibility);
        }
    }

    public static String getName(Method setter) {
        StringBuilder name = new StringBuilder(setter.getName());
        name.delete(0, 3);
        name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
        return name.toString();
    }

    private static String normalize(String jndiName) {
        if (jndiName != null && jndiName.startsWith("java:comp/env/")) {
            return jndiName.substring(14);
        }
        return jndiName;
    }

    private static enum AnnotationCacheEntryType {
        FIELD,
        POST_CONSTRUCT,
        PRE_DESTROY;

    }

    private static final class AnnotationCacheEntry {
        private final AccessibleObject accessibleObject;
        private final String name;
        private final AnnotationCacheEntryType type;

        public AnnotationCacheEntry(AccessibleObject accessibleObject, String name, AnnotationCacheEntryType type) {
            this.accessibleObject = accessibleObject;
            this.name = name;
            this.type = type;
        }

        public AccessibleObject getAccessibleObject() {
            return this.accessibleObject;
        }

        public String getName() {
            return this.name;
        }

        public AnnotationCacheEntryType getType() {
            return this.type;
        }
    }
}

