/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.Util;
import java.util.Objects;
import java.util.Optional;

public class OptionalELResolver
extends ELResolver {
    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof Optional) {
            context.setPropertyResolved(base, property);
            if (((Optional)base).isPresent()) {
                if (property == null) {
                    return ((Optional)base).get();
                }
                Object resolvedBase = ((Optional)base).get();
                return context.getELResolver().getValue(context, resolvedBase, property);
            }
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof Optional) {
            context.setPropertyResolved(base, property);
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        Objects.requireNonNull(context);
        if (base instanceof Optional) {
            throw new PropertyNotWritableException(Util.message(context, "resolverNotWritable", base.getClass().getName()));
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof Optional) {
            context.setPropertyResolved(base, property);
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base instanceof Optional) {
            return Object.class;
        }
        return null;
    }

    @Override
    public <T> T convertToType(ELContext context, Object obj, Class<T> type) {
        Objects.requireNonNull(context);
        if (obj instanceof Optional) {
            Object value = null;
            if (((Optional)obj).isPresent() && type.isAssignableFrom((value = (Object)((Optional)obj).get()).getClass())) {
                context.setPropertyResolved(true);
                Object result = value;
                return (T)result;
            }
            try {
                T convertedValue = context.convertToType(value, type);
                context.setPropertyResolved(true);
                T result = convertedValue;
                return result;
            }
            catch (ELException eLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        Objects.requireNonNull(context);
        if (base instanceof Optional && method != null) {
            context.setPropertyResolved(base, method);
            if (((Optional)base).isEmpty()) {
                return null;
            }
            Object resolvedBase = ((Optional)base).get();
            return context.getELResolver().invoke(context, resolvedBase, method, paramTypes, params);
        }
        return null;
    }
}

