/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.test;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.testng.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtils
extends Assert {
    public static void unreachable() {
        TestUtils.fail((String)"This code should not be reachable.");
    }

    public static void assertMessageContains(Throwable t, String ... substrings) {
        String message = t.getMessage();
        for (String substring : substrings) {
            TestUtils.assertTrue((boolean)message.contains(substring), (String)String.format("String '%s' not found in '%s'.", substring, message));
        }
    }

    public static <T> void assertListsEquals(List<T> actual, List<T> expected) {
        int count = Math.min(actual.size(), expected.size());
        try {
            for (int i = 0; i < count; ++i) {
                TestUtils.assertEquals(actual.get(i), expected.get(i), (String)String.format("Element #%d.", i));
            }
            TestUtils.assertEquals((int)actual.size(), (int)expected.size(), (String)"List size.");
        }
        catch (AssertionError ae) {
            TestUtils.showLists(actual, expected);
            throw ae;
        }
    }

    protected static <T> void showLists(List<T> actual, List<T> expected) {
        List<String> actualStrings = TestUtils.toStrings(actual);
        List<String> expectedStrings = TestUtils.toStrings(expected);
        String format = String.format("%%3d: [%%-%ds] [%%-%ds]\n", TestUtils.maxLength(actualStrings), TestUtils.maxLength(expectedStrings));
        int count = Math.max(actual.size(), expected.size());
        System.out.flush();
        System.err.flush();
        System.err.println("List results differ (actual  vs. expected):");
        for (int i = 0; i < count; ++i) {
            System.err.printf(format, i, TestUtils.get(actualStrings, i), TestUtils.get(expectedStrings, i));
        }
    }

    private static String get(List<String> list, int index) {
        if (index < list.size()) {
            return list.get(index);
        }
        return "";
    }

    private static int maxLength(List<String> list) {
        int result = 0;
        for (String s : list) {
            result = Math.max(result, s.length());
        }
        return result;
    }

    private static <T> List<String> toStrings(List<T> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (T t : list) {
            result.add(String.valueOf(t));
        }
        return result;
    }

    public static <T> void assertListsEquals(List<T> actual, T ... expected) {
        TestUtils.assertListsEquals(actual, Arrays.asList(expected));
    }

    public static <T> void assertArraysEqual(T[] actual, T ... expected) {
        TestUtils.assertListsEquals(Arrays.asList(actual), expected);
    }

    public static <T> T set(T object, Object ... fieldValues) {
        assert (object != null);
        Class<?> objectClass = object.getClass();
        for (int i = 0; i < fieldValues.length; i += 2) {
            String fieldName = (String)fieldValues[i];
            Object fieldValue = fieldValues[i + 1];
            try {
                Field field = TestUtils.findField(objectClass, fieldName);
                field.setAccessible(true);
                field.set(object, fieldValue);
                continue;
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Unable to set field '%s' of %s to %s: %s", fieldName, object, fieldValue, InternalUtils.toMessage(ex)), ex);
            }
        }
        return object;
    }

    public static Object get(Object object, String fieldName) {
        assert (object != null);
        assert (InternalUtils.isNonBlank(fieldName));
        try {
            Field field = TestUtils.findField(object.getClass(), fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to read field '%s' of %s: %s", fieldName, object, InternalUtils.toMessage(ex)), ex);
        }
    }

    private static Field findField(Class objectClass, String fieldName) {
        for (Class cursor = objectClass; cursor != null; cursor = cursor.getSuperclass()) {
            try {
                return cursor.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new RuntimeException(String.format("Class %s does not contain a field named '%s'.", objectClass.getName(), fieldName));
    }

    public static <T> T create(Class<T> objectType, Object ... fieldValues) {
        T result = null;
        try {
            result = objectType.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Unable to instantiate instance of %s: %s", objectType.getName(), InternalUtils.toMessage(ex)), ex);
        }
        return TestUtils.set(result, fieldValues);
    }
}

