/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import org.apache.tapestry5.ioc.internal.services.FilterMethodAnalyzer;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ClassFab;
import org.apache.tapestry5.ioc.services.ClassFactory;
import org.apache.tapestry5.ioc.services.MethodIterator;
import org.apache.tapestry5.ioc.services.MethodSignature;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BridgeBuilder<S, F> {
    private final Logger logger;
    private final Class<S> serviceInterface;
    private final Class<F> filterInterface;
    private final ClassFab classFab;
    private final FilterMethodAnalyzer filterMethodAnalyzer;
    private Constructor constructor;

    BridgeBuilder(Logger logger, Class<S> serviceInterface, Class<F> filterInterface, ClassFactory classFactory) {
        this.logger = logger;
        this.serviceInterface = serviceInterface;
        this.filterInterface = filterInterface;
        this.classFab = classFactory.newClass(this.serviceInterface);
        this.filterMethodAnalyzer = new FilterMethodAnalyzer(serviceInterface);
    }

    private void createClass() {
        List serviceMethods = CollectionFactory.newList();
        List filterMethods = CollectionFactory.newList();
        this.createInfrastructure();
        MethodIterator mi = new MethodIterator(this.serviceInterface);
        while (mi.hasNext()) {
            serviceMethods.add(mi.next());
        }
        boolean toStringMethodExists = mi.getToString();
        mi = new MethodIterator(this.filterInterface);
        while (mi.hasNext()) {
            filterMethods.add(mi.next());
        }
        while (!serviceMethods.isEmpty()) {
            MethodSignature ms = (MethodSignature)serviceMethods.remove(0);
            this.addBridgeMethod(ms, filterMethods);
        }
        this.reportExtraFilterMethods(filterMethods);
        if (!toStringMethodExists) {
            String toString = String.format("<PipelineBridge from %s to %s>", this.serviceInterface.getName(), this.filterInterface.getName());
            this.classFab.addToString(toString);
        }
        Class bridgeClass = this.classFab.createClass();
        this.constructor = bridgeClass.getConstructors()[0];
    }

    private void createInfrastructure() {
        this.classFab.addField("_next", 18, this.serviceInterface);
        this.classFab.addField("_filter", 18, this.filterInterface);
        this.classFab.addConstructor(new Class[]{this.serviceInterface, this.filterInterface}, null, "{ _next = $1; _filter = $2; }");
        this.classFab.addInterface(this.serviceInterface);
    }

    public S instantiateBridge(S nextBridge, F filter) {
        if (this.constructor == null) {
            this.createClass();
        }
        try {
            Object instance = this.constructor.newInstance(nextBridge, filter);
            return this.serviceInterface.cast(instance);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void reportExtraFilterMethods(List filterMethods) {
        for (MethodSignature ms : filterMethods) {
            this.logger.error(ServiceMessages.extraFilterMethod(ms, this.filterInterface, this.serviceInterface));
        }
    }

    private void addBridgeMethod(MethodSignature ms, List filterMethods) {
        Iterator i = filterMethods.iterator();
        while (i.hasNext()) {
            MethodSignature fms = (MethodSignature)i.next();
            int position = this.filterMethodAnalyzer.findServiceInterfacePosition(ms, fms);
            if (position < 0) continue;
            this.addBridgeMethod(position, ms, fms);
            i.remove();
            return;
        }
        String message = ServiceMessages.unmatchedServiceMethod(ms, this.filterInterface);
        this.logger.error(message);
        String code = String.format("throw new %s(\"%s\");", RuntimeException.class.getName(), message);
        this.classFab.addMethod(1, ms, code);
    }

    private void addBridgeMethod(int position, MethodSignature ms, MethodSignature fms) {
        int i;
        StringBuilder buffer = new StringBuilder(100);
        buffer.append("return ($r) _filter.");
        buffer.append(ms.getName());
        buffer.append("(");
        boolean comma = false;
        int filterParameterCount = fms.getParameterTypes().length;
        for (i = 0; i < position; ++i) {
            if (comma) {
                buffer.append(", ");
            }
            buffer.append("$");
            buffer.append(i + 1);
            comma = true;
        }
        if (comma) {
            buffer.append(", ");
        }
        buffer.append("_next");
        for (i = position + 1; i < filterParameterCount; ++i) {
            buffer.append(", $");
            buffer.append(i);
        }
        buffer.append(");");
        this.classFab.addMethod(1, ms, buffer.toString());
    }
}

