/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.net.URL;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.AbstractResource;
import org.apache.tapestry5.ioc.internal.util.Defense;

public final class ClasspathResource
extends AbstractResource {
    private final ClassLoader classLoader;
    private URL url;
    private boolean urlResolved;

    public ClasspathResource(String path) {
        this(Thread.currentThread().getContextClassLoader(), path);
    }

    public ClasspathResource(ClassLoader classLoader, String path) {
        super(path);
        Defense.notNull(classLoader, "classLoader");
        this.classLoader = classLoader;
    }

    protected Resource newResource(String path) {
        return new ClasspathResource(this.classLoader, path);
    }

    public synchronized URL toURL() {
        if (!this.urlResolved) {
            this.url = this.classLoader.getResource(this.getPath());
            this.urlResolved = true;
        }
        return this.url;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ClasspathResource other = (ClasspathResource)obj;
        return other.classLoader == this.classLoader && other.getPath().equals(this.getPath());
    }

    public int hashCode() {
        return 0xE3 ^ this.getPath().hashCode();
    }

    public String toString() {
        return "classpath:" + this.getPath();
    }
}

