/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.tapestry5.ioc.internal.services.CompoundCoercion;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.Defense;
import org.apache.tapestry5.ioc.internal.util.InheritanceSearch;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.ClassFabUtils;
import org.apache.tapestry5.ioc.services.Coercion;
import org.apache.tapestry5.ioc.services.CoercionTuple;
import org.apache.tapestry5.ioc.services.TypeCoercer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCoercerImpl
implements TypeCoercer {
    private final Map<Class, List<CoercionTuple>> sourceTypeToTuple = CollectionFactory.newMap();
    private final Map<Class, TargetCoercion> typeToTargetCoercion = new WeakHashMap<Class, TargetCoercion>();
    private static final Coercion COERCION_NULL_TO_OBJECT = new Coercion<Void, Object>(){

        @Override
        public Object coerce(Void input) {
            return null;
        }

        public String toString() {
            return "null --> null";
        }
    };

    public TypeCoercerImpl(Collection<CoercionTuple> tuples) {
        for (CoercionTuple tuple : tuples) {
            Class key = tuple.getSourceType();
            InternalUtils.addToMapList(this.sourceTypeToTuple, key, tuple);
        }
    }

    public Object coerce(Object input, Class targetType) {
        Defense.notNull(targetType, "targetType");
        Class effectiveTargetType = ClassFabUtils.getWrapperType(targetType);
        if (effectiveTargetType.isInstance(input)) {
            return input;
        }
        return this.getTargetCoercion(effectiveTargetType).coerce(input);
    }

    @Override
    public <S, T> String explain(Class<S> inputType, Class<T> targetType) {
        Defense.notNull(inputType, "inputType");
        Defense.notNull(targetType, "targetType");
        Class effectiveTargetType = ClassFabUtils.getWrapperType(targetType);
        if (effectiveTargetType.isAssignableFrom(inputType)) {
            return "";
        }
        return this.getTargetCoercion(targetType).explain(inputType);
    }

    private synchronized TargetCoercion getTargetCoercion(Class targetType) {
        TargetCoercion tc = this.typeToTargetCoercion.get(targetType);
        if (tc == null) {
            tc = new TargetCoercion(targetType);
            this.typeToTargetCoercion.put(targetType, tc);
        }
        return tc;
    }

    @Override
    public synchronized void clearCache() {
        for (TargetCoercion tc : this.typeToTargetCoercion.values()) {
            tc.clearCache();
        }
    }

    private Coercion findOrCreateCoercion(Class sourceType, Class targetType) {
        if (sourceType == Void.TYPE) {
            return this.searchForNullCoercion(targetType);
        }
        Set<CoercionTuple> consideredTuples = CollectionFactory.newSet();
        LinkedList<CoercionTuple> queue = CollectionFactory.newLinkedList();
        this.seedQueue(sourceType, consideredTuples, queue);
        while (!queue.isEmpty()) {
            CoercionTuple tuple = queue.removeFirst();
            Class tupleTargetType = tuple.getTargetType();
            if (targetType.isAssignableFrom(tupleTargetType)) {
                return tuple.getCoercion();
            }
            this.queueIntermediates(sourceType, tuple, consideredTuples, queue);
        }
        throw new IllegalArgumentException(ServiceMessages.noCoercionFound(sourceType, targetType, this.buildCoercionCatalog()));
    }

    private Coercion searchForNullCoercion(Class targetType) {
        List<CoercionTuple> tuples = this.sourceTypeToTuple.get(Void.TYPE);
        if (tuples != null) {
            for (CoercionTuple tuple : tuples) {
                Class tupleTargetType = tuple.getTargetType();
                if (!targetType.equals(tupleTargetType)) continue;
                return tuple.getCoercion();
            }
        }
        return COERCION_NULL_TO_OBJECT;
    }

    private String buildCoercionCatalog() {
        List descriptions = CollectionFactory.newList();
        for (List<CoercionTuple> list : this.sourceTypeToTuple.values()) {
            for (CoercionTuple tuple : list) {
                descriptions.add(tuple.toString());
            }
        }
        return InternalUtils.joinSorted(descriptions);
    }

    private void seedQueue(Class sourceType, Set<CoercionTuple> consideredTuples, LinkedList<CoercionTuple> queue) {
        for (Class c : new InheritanceSearch(sourceType)) {
            List<CoercionTuple> tuples = this.sourceTypeToTuple.get(c);
            if (tuples == null) continue;
            for (CoercionTuple tuple : tuples) {
                queue.addLast(tuple);
                consideredTuples.add(tuple);
            }
            if (sourceType != Void.TYPE) continue;
            return;
        }
    }

    private void queueIntermediates(Class sourceType, CoercionTuple intermediateTuple, Set<CoercionTuple> consideredTuples, LinkedList<CoercionTuple> queue) {
        Class intermediateType = intermediateTuple.getTargetType();
        for (Class c : new InheritanceSearch(intermediateType)) {
            List<CoercionTuple> tuples = this.sourceTypeToTuple.get(c);
            if (tuples == null) continue;
            for (CoercionTuple tuple : tuples) {
                Class newIntermediateType;
                if (consideredTuples.contains(tuple) || sourceType.isAssignableFrom(newIntermediateType = tuple.getTargetType())) continue;
                CompoundCoercion compoundCoercer = new CompoundCoercion(intermediateTuple.getCoercion(), tuple.getCoercion());
                CoercionTuple compoundTuple = new CoercionTuple(sourceType, newIntermediateType, compoundCoercer, false);
                queue.addLast(compoundTuple);
                consideredTuples.add(tuple);
            }
        }
    }

    private class TargetCoercion {
        private final Class type;
        private final Map<Class, Coercion> cache = CollectionFactory.newConcurrentMap();

        TargetCoercion(Class type) {
            this.type = type;
        }

        void clearCache() {
            this.cache.clear();
        }

        Object coerce(Object input) {
            Class<Void> sourceType;
            Class<Void> clazz = sourceType = input != null ? input.getClass() : Void.TYPE;
            if (this.type.isAssignableFrom(sourceType)) {
                return input;
            }
            Coercion c = this.getCoercion(sourceType);
            try {
                return this.type.cast(c.coerce(input));
            }
            catch (Exception ex) {
                throw new RuntimeException(ServiceMessages.failedCoercion(input, this.type, c, ex), ex);
            }
        }

        String explain(Class sourceType) {
            return this.getCoercion(sourceType).toString();
        }

        private Coercion getCoercion(Class sourceType) {
            Coercion c = this.cache.get(sourceType);
            if (c == null) {
                c = TypeCoercerImpl.this.findOrCreateCoercion(sourceType, this.type);
                this.cache.put(sourceType, c);
            }
            return c;
        }
    }
}

