/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.internal.EagerLoadServiceProxy;
import org.apache.tapestry5.ioc.internal.ServiceActivityTracker;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.apache.tapestry5.ioc.services.Status;

public class JustInTimeObjectCreator
implements ObjectCreator,
EagerLoadServiceProxy,
RegistryShutdownListener {
    private final ServiceActivityTracker tracker;
    private volatile ObjectCreator creator;
    private volatile Object object;
    private final String serviceId;

    public JustInTimeObjectCreator(ServiceActivityTracker tracker, ObjectCreator creator, String serviceId) {
        this.tracker = tracker;
        this.creator = creator;
        this.serviceId = serviceId;
    }

    public Object createObject() {
        if (this.object == null) {
            this.obtainObjectFromCreator();
        }
        return this.object;
    }

    private synchronized void obtainObjectFromCreator() {
        if (this.object != null) {
            return;
        }
        try {
            this.object = this.creator.createObject();
            this.tracker.setStatus(this.serviceId, Status.REAL);
            this.creator = null;
        }
        catch (RuntimeException ex) {
            throw new RuntimeException(ServiceMessages.serviceBuildFailure(this.serviceId, ex), ex);
        }
    }

    public void eagerLoadService() {
        this.createObject();
    }

    public void registryDidShutdown() {
        this.creator = new ObjectCreator(){

            public Object createObject() {
                throw new IllegalStateException(ServiceMessages.registryShutdown(JustInTimeObjectCreator.this.serviceId));
            }
        };
        this.object = null;
    }
}

