/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import javassist.CtClass;
import org.apache.tapestry5.ioc.internal.services.CtClassSource;
import org.apache.tapestry5.ioc.internal.util.OneShotLock;
import org.slf4j.Logger;

public class AbstractFab {
    protected final OneShotLock lock = new OneShotLock();
    private final CtClass ctClass;
    private final CtClassSource source;
    private final Logger logger;

    public AbstractFab(CtClassSource source, CtClass ctClass, Logger logger) {
        this.ctClass = ctClass;
        this.source = source;
        this.logger = logger;
    }

    public void addInterface(Class interfaceClass) {
        this.lock.check();
        CtClass ctInterfaceClass = this.source.toCtClass(interfaceClass);
        try {
            for (CtClass existing : this.ctClass.getInterfaces()) {
                if (existing != ctInterfaceClass) continue;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ctClass.addInterface(ctInterfaceClass);
    }

    protected CtClass[] toCtClasses(Class[] inputClasses) {
        if (inputClasses == null || inputClasses.length == 0) {
            return null;
        }
        int count = inputClasses.length;
        CtClass[] result = new CtClass[count];
        for (int i = 0; i < count; ++i) {
            CtClass ctClass;
            result[i] = ctClass = this.toCtClass(inputClasses[i]);
        }
        return result;
    }

    protected CtClass toCtClass(Class inputClass) {
        return this.source.toCtClass(inputClass);
    }

    public Class createClass() {
        this.lock.lock();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Creating class from %s", this));
        }
        return this.source.createClass(this.ctClass);
    }

    protected CtClass getCtClass() {
        return this.ctClass;
    }

    protected CtClassSource getSource() {
        return this.source;
    }
}

