/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.util;

import java.util.List;
import java.util.Map;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.InheritanceSearch;
import org.apache.tapestry.ioc.util.UtilMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StrategyRegistry<A> {
    private final Class<A> _adapterType;
    private final Map<Class, A> _registrations = CollectionFactory.newMap();
    private final Map<Class, A> _cache = CollectionFactory.newConcurrentMap();

    public StrategyRegistry(Class<A> adapterType, Map<Class, A> registrations) {
        this._adapterType = adapterType;
        this._registrations.putAll(registrations);
    }

    public static <A> StrategyRegistry<A> newInstance(Class<A> adapterType, Map<Class, A> registrations) {
        return new StrategyRegistry<A>(adapterType, registrations);
    }

    public void clearCache() {
        this._cache.clear();
    }

    public Class<A> getAdapterType() {
        return this._adapterType;
    }

    public A getByInstance(Object value) {
        return this.get(value == null ? Void.TYPE : value.getClass());
    }

    public A get(Class type) {
        A result = this._cache.get(type);
        if (result == null) {
            result = this.findMatch(type);
            this._cache.put(type, result);
        }
        return result;
    }

    private A findMatch(Class type) {
        for (Class t : new InheritanceSearch(type)) {
            A result = this._registrations.get(t);
            if (result == null) continue;
            return result;
        }
        List<String> names = CollectionFactory.newList();
        for (Class t : this._registrations.keySet()) {
            names.add(t.getName());
        }
        throw new IllegalArgumentException(UtilMessages.noStrategyAdapter(type, this._adapterType, names));
    }

    public String toString() {
        return String.format("StrategyRegistry[%s]", this._adapterType.getName());
    }
}

