/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.services;

import java.io.File;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.ioc.Configuration;
import org.apache.tapestry.ioc.MappedConfiguration;
import org.apache.tapestry.ioc.ObjectLocator;
import org.apache.tapestry.ioc.ObjectProvider;
import org.apache.tapestry.ioc.OrderedConfiguration;
import org.apache.tapestry.ioc.ServiceBinder;
import org.apache.tapestry.ioc.ServiceLifecycle;
import org.apache.tapestry.ioc.annotations.Marker;
import org.apache.tapestry.ioc.internal.services.ChainBuilderImpl;
import org.apache.tapestry.ioc.internal.services.DefaultImplementationBuilderImpl;
import org.apache.tapestry.ioc.internal.services.ExceptionAnalyzerImpl;
import org.apache.tapestry.ioc.internal.services.ExceptionTrackerImpl;
import org.apache.tapestry.ioc.internal.services.LoggingDecoratorImpl;
import org.apache.tapestry.ioc.internal.services.MapSymbolProvider;
import org.apache.tapestry.ioc.internal.services.MasterObjectProviderImpl;
import org.apache.tapestry.ioc.internal.services.PerThreadServiceLifecycle;
import org.apache.tapestry.ioc.internal.services.PipelineBuilderImpl;
import org.apache.tapestry.ioc.internal.services.PropertyAccessImpl;
import org.apache.tapestry.ioc.internal.services.PropertyShadowBuilderImpl;
import org.apache.tapestry.ioc.internal.services.RegistryStartup;
import org.apache.tapestry.ioc.internal.services.StrategyBuilderImpl;
import org.apache.tapestry.ioc.internal.services.SymbolObjectProvider;
import org.apache.tapestry.ioc.internal.services.SymbolSourceImpl;
import org.apache.tapestry.ioc.internal.services.SystemPropertiesSymbolProvider;
import org.apache.tapestry.ioc.internal.services.ThreadLocaleImpl;
import org.apache.tapestry.ioc.internal.services.TypeCoercerImpl;
import org.apache.tapestry.ioc.internal.services.ValueObjectProvider;
import org.apache.tapestry.ioc.services.ApplicationDefaults;
import org.apache.tapestry.ioc.services.Builtin;
import org.apache.tapestry.ioc.services.ChainBuilder;
import org.apache.tapestry.ioc.services.Coercion;
import org.apache.tapestry.ioc.services.CoercionTuple;
import org.apache.tapestry.ioc.services.DefaultImplementationBuilder;
import org.apache.tapestry.ioc.services.ExceptionAnalyzer;
import org.apache.tapestry.ioc.services.ExceptionTracker;
import org.apache.tapestry.ioc.services.FactoryDefaults;
import org.apache.tapestry.ioc.services.LoggingDecorator;
import org.apache.tapestry.ioc.services.PipelineBuilder;
import org.apache.tapestry.ioc.services.PropertyAccess;
import org.apache.tapestry.ioc.services.PropertyShadowBuilder;
import org.apache.tapestry.ioc.services.ServiceLifecycleSource;
import org.apache.tapestry.ioc.services.StrategyBuilder;
import org.apache.tapestry.ioc.services.SymbolProvider;
import org.apache.tapestry.ioc.services.SymbolSource;
import org.apache.tapestry.ioc.services.ThreadLocale;
import org.apache.tapestry.ioc.services.TypeCoercer;
import org.apache.tapestry.ioc.util.TimePeriod;
import org.apache.tapestry.services.MasterObjectProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Marker(value={Builtin.class})
public final class TapestryIOCModule {
    public static void bind(ServiceBinder binder) {
        binder.bind(LoggingDecorator.class, LoggingDecoratorImpl.class);
        binder.bind(ChainBuilder.class, ChainBuilderImpl.class);
        binder.bind(PropertyAccess.class, PropertyAccessImpl.class);
        binder.bind(StrategyBuilder.class, StrategyBuilderImpl.class);
        binder.bind(PropertyShadowBuilder.class, PropertyShadowBuilderImpl.class);
        binder.bind(PipelineBuilder.class, PipelineBuilderImpl.class);
        binder.bind(DefaultImplementationBuilder.class, DefaultImplementationBuilderImpl.class);
        binder.bind(ExceptionTracker.class, ExceptionTrackerImpl.class);
        binder.bind(ExceptionAnalyzer.class, ExceptionAnalyzerImpl.class);
        binder.bind(TypeCoercer.class, TypeCoercerImpl.class);
        binder.bind(ThreadLocale.class, ThreadLocaleImpl.class);
        binder.bind(SymbolSource.class, SymbolSourceImpl.class);
        binder.bind(SymbolProvider.class, MapSymbolProvider.class).withId("ApplicationDefaults").withMarker(ApplicationDefaults.class);
        binder.bind(SymbolProvider.class, MapSymbolProvider.class).withId("FactoryDefaults").withMarker(FactoryDefaults.class);
        binder.bind(Runnable.class, RegistryStartup.class).withId("RegistryStartup");
        binder.bind(MasterObjectProvider.class, MasterObjectProviderImpl.class);
    }

    public static ServiceLifecycleSource build(final Map<String, ServiceLifecycle> configuration) {
        return new ServiceLifecycleSource(){

            public ServiceLifecycle get(String lifecycleName) {
                return (ServiceLifecycle)configuration.get(lifecycleName);
            }
        };
    }

    public void contributeServiceLifecycleSource(MappedConfiguration<String, ServiceLifecycle> configuration, ObjectLocator locator) {
        configuration.add("perthread", locator.autobuild(PerThreadServiceLifecycle.class));
    }

    public static void contributeMasterObjectProvider(OrderedConfiguration<ObjectProvider> configuration, ObjectLocator locator) {
        configuration.add("Value", locator.autobuild(ValueObjectProvider.class), new String[0]);
        configuration.add("Symbol", locator.autobuild(SymbolObjectProvider.class), new String[0]);
    }

    public static void contributeTypeCoercer(Configuration<CoercionTuple> configuration) {
        TapestryIOCModule.add(configuration, Object.class, String.class, new Coercion<Object, String>(){

            @Override
            public String coerce(Object input) {
                return input.toString();
            }
        });
        TapestryIOCModule.add(configuration, Void.TYPE, String.class, new Coercion<Void, String>(){

            @Override
            public String coerce(Void input) {
                return null;
            }
        });
        TapestryIOCModule.add(configuration, Void.TYPE, List.class, new Coercion<Void, List>(){

            @Override
            public List coerce(Void input) {
                return null;
            }
        });
        TapestryIOCModule.add(configuration, String.class, Double.class, new Coercion<String, Double>(){

            @Override
            public Double coerce(String input) {
                return new Double(input);
            }
        });
        TapestryIOCModule.add(configuration, String.class, BigDecimal.class, new Coercion<String, BigDecimal>(){

            @Override
            public BigDecimal coerce(String input) {
                return new BigDecimal(input);
            }
        });
        TapestryIOCModule.add(configuration, BigDecimal.class, Double.class, new Coercion<BigDecimal, Double>(){

            @Override
            public Double coerce(BigDecimal input) {
                return input.doubleValue();
            }
        });
        TapestryIOCModule.add(configuration, String.class, BigInteger.class, new Coercion<String, BigInteger>(){

            @Override
            public BigInteger coerce(String input) {
                return new BigInteger(input);
            }
        });
        TapestryIOCModule.add(configuration, String.class, Long.class, new Coercion<String, Long>(){

            @Override
            public Long coerce(String input) {
                return new Long(input);
            }
        });
        TapestryIOCModule.add(configuration, Long.class, Byte.class, new Coercion<Long, Byte>(){

            @Override
            public Byte coerce(Long input) {
                return input.byteValue();
            }
        });
        TapestryIOCModule.add(configuration, Long.class, Short.class, new Coercion<Long, Short>(){

            @Override
            public Short coerce(Long input) {
                return input.shortValue();
            }
        });
        TapestryIOCModule.add(configuration, Long.class, Integer.class, new Coercion<Long, Integer>(){

            @Override
            public Integer coerce(Long input) {
                return input.intValue();
            }
        });
        TapestryIOCModule.add(configuration, Number.class, Long.class, new Coercion<Number, Long>(){

            @Override
            public Long coerce(Number input) {
                return input.longValue();
            }
        });
        TapestryIOCModule.add(configuration, Double.class, Float.class, new Coercion<Double, Float>(){

            @Override
            public Float coerce(Double input) {
                return Float.valueOf(input.floatValue());
            }
        });
        TapestryIOCModule.add(configuration, Long.class, Double.class, new Coercion<Long, Double>(){

            @Override
            public Double coerce(Long input) {
                return input.doubleValue();
            }
        });
        TapestryIOCModule.add(configuration, String.class, Boolean.class, new Coercion<String, Boolean>(){

            @Override
            public Boolean coerce(String input) {
                String trimmed = input.trim();
                if (trimmed.equalsIgnoreCase("false") || trimmed.length() == 0) {
                    return false;
                }
                return true;
            }
        });
        TapestryIOCModule.add(configuration, Long.class, Boolean.class, new Coercion<Long, Boolean>(){

            @Override
            public Boolean coerce(Long input) {
                return input != 0L;
            }
        });
        TapestryIOCModule.add(configuration, Void.TYPE, Boolean.class, new Coercion<Void, Boolean>(){

            @Override
            public Boolean coerce(Void input) {
                return false;
            }
        });
        TapestryIOCModule.add(configuration, Void.TYPE, Long.class, new Coercion<Void, Long>(){

            @Override
            public Long coerce(Void input) {
                return 0L;
            }
        });
        TapestryIOCModule.add(configuration, Void.TYPE, BigDecimal.class, new Coercion<Void, BigDecimal>(){

            @Override
            public BigDecimal coerce(Void input) {
                return BigDecimal.ZERO;
            }
        });
        TapestryIOCModule.add(configuration, Void.TYPE, BigInteger.class, new Coercion<Void, BigInteger>(){

            @Override
            public BigInteger coerce(Void input) {
                return BigInteger.ZERO;
            }
        });
        TapestryIOCModule.add(configuration, Void.TYPE, Double.class, new Coercion<Void, Double>(){

            @Override
            public Double coerce(Void input) {
                return 0.0;
            }
        });
        TapestryIOCModule.add(configuration, Collection.class, Boolean.class, new Coercion<Collection, Boolean>(){

            @Override
            public Boolean coerce(Collection input) {
                return !input.isEmpty();
            }
        });
        TapestryIOCModule.add(configuration, Object.class, List.class, new Coercion<Object, List>(){

            @Override
            public List coerce(Object input) {
                return Collections.singletonList(input);
            }
        });
        TapestryIOCModule.add(configuration, Object[].class, List.class, new Coercion<Object[], List>(){

            @Override
            public List coerce(Object[] input) {
                return Arrays.asList(input);
            }
        });
        TapestryIOCModule.add(configuration, Float.class, Double.class, new Coercion<Float, Double>(){

            @Override
            public Double coerce(Float input) {
                return input.doubleValue();
            }
        });
        Coercion<Object, List> primitiveArrayCoercion = new Coercion<Object, List>(){

            @Override
            public List<Object> coerce(Object input) {
                int length = Array.getLength(input);
                Object[] array = new Object[length];
                for (int i = 0; i < length; ++i) {
                    array[i] = Array.get(input, i);
                }
                return Arrays.asList(array);
            }
        };
        TapestryIOCModule.add(configuration, byte[].class, List.class, primitiveArrayCoercion);
        TapestryIOCModule.add(configuration, short[].class, List.class, primitiveArrayCoercion);
        TapestryIOCModule.add(configuration, int[].class, List.class, primitiveArrayCoercion);
        TapestryIOCModule.add(configuration, long[].class, List.class, primitiveArrayCoercion);
        TapestryIOCModule.add(configuration, float[].class, List.class, primitiveArrayCoercion);
        TapestryIOCModule.add(configuration, double[].class, List.class, primitiveArrayCoercion);
        TapestryIOCModule.add(configuration, char[].class, List.class, primitiveArrayCoercion);
        TapestryIOCModule.add(configuration, boolean[].class, List.class, primitiveArrayCoercion);
        TapestryIOCModule.add(configuration, String.class, File.class, new Coercion<String, File>(){

            @Override
            public File coerce(String input) {
                return new File(input);
            }
        });
        TapestryIOCModule.add(configuration, String.class, TimePeriod.class, new Coercion<String, TimePeriod>(){

            @Override
            public TimePeriod coerce(String input) {
                return new TimePeriod(input);
            }
        });
        TapestryIOCModule.add(configuration, TimePeriod.class, Long.class, new Coercion<TimePeriod, Long>(){

            @Override
            public Long coerce(TimePeriod input) {
                return input.milliseconds();
            }
        });
    }

    private static <S, T> void add(Configuration<CoercionTuple> configuration, Class<S> sourceType, Class<T> targetType, Coercion<S, T> coercion) {
        CoercionTuple<S, T> tuple = new CoercionTuple<S, T>(sourceType, targetType, coercion);
        configuration.add(tuple);
    }

    public static void contributeSymbolSource(OrderedConfiguration<SymbolProvider> configuration, @ApplicationDefaults SymbolProvider applicationDefaults, @FactoryDefaults SymbolProvider factoryDefaults) {
        configuration.add("SystemProperties", new SystemPropertiesSymbolProvider(), new String[0]);
        configuration.add("ApplicationDefaults", applicationDefaults, "after:SystemProperties");
        configuration.add("FactoryDefaults", factoryDefaults, "after:ApplicationDefaults");
    }
}

