/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.util;

import java.util.Formatter;
import org.apache.tapestry.ioc.Location;
import org.apache.tapestry.ioc.Resource;

public final class LocationImpl
implements Location {
    private final Resource _resource;
    private final int _line;
    private final int _column;
    private static final int UNKNOWN = -1;

    public LocationImpl(Resource resource) {
        this(resource, -1);
    }

    public LocationImpl(Resource resource, int line) {
        this(resource, line, -1);
    }

    public LocationImpl(Resource resource, int line, int column) {
        this._resource = resource;
        this._line = line;
        this._column = column;
    }

    public Resource getResource() {
        return this._resource;
    }

    public int getLine() {
        return this._line;
    }

    public int getColumn() {
        return this._column;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this._resource.toString());
        Formatter formatter = new Formatter(buffer);
        if (this._line != -1) {
            formatter.format(", line %d", this._line);
        }
        if (this._column != -1) {
            formatter.format(", column %d", this._column);
        }
        return buffer.toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this._column;
        result = 31 * result + this._line;
        result = 31 * result + (this._resource == null ? 0 : this._resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocationImpl other = (LocationImpl)obj;
        if (this._column != other._column) {
            return false;
        }
        if (this._line != other._line) {
            return false;
        }
        return !(this._resource == null ? other._resource != null : !this._resource.equals(other._resource));
    }
}

