/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import java.util.Map;
import javassist.CtClass;
import org.apache.tapestry.ioc.internal.services.CtClassSource;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.OneShotLock;
import org.slf4j.Logger;

public class AbstractFab {
    protected final OneShotLock _lock = new OneShotLock();
    private final CtClass _ctClass;
    private final CtClassSource _source;
    private final Logger _logger;
    private final Map<Class, CtClass> _ctClassCache = CollectionFactory.newMap();

    public AbstractFab(CtClassSource source, CtClass ctClass, Logger logger) {
        this._ctClass = ctClass;
        this._source = source;
        this._logger = logger;
    }

    public void addInterface(Class interfaceClass) {
        this._lock.check();
        CtClass ctInterfaceClass = this._source.getCtClass(interfaceClass);
        try {
            for (CtClass existing : this._ctClass.getInterfaces()) {
                if (existing != ctInterfaceClass) continue;
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._ctClass.addInterface(ctInterfaceClass);
    }

    protected CtClass[] convertClasses(Class[] inputClasses) {
        if (inputClasses == null || inputClasses.length == 0) {
            return null;
        }
        int count = inputClasses.length;
        CtClass[] result = new CtClass[count];
        for (int i = 0; i < count; ++i) {
            CtClass ctClass;
            result[i] = ctClass = this.convertClass(inputClasses[i]);
        }
        return result;
    }

    protected CtClass convertClass(Class inputClass) {
        CtClass result = this._ctClassCache.get(inputClass);
        if (result == null) {
            result = this._source.getCtClass(inputClass);
            this._ctClassCache.put(inputClass, result);
        }
        return result;
    }

    public Class createClass() {
        this._lock.lock();
        if (this._logger.isDebugEnabled()) {
            this._logger.debug(String.format("Creating class from %s", this));
        }
        return this._source.createClass(this._ctClass);
    }

    protected CtClass getCtClass() {
        return this._ctClass;
    }

    protected CtClassSource getSource() {
        return this._source;
    }
}

