/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.util;

import java.util.List;
import org.apache.tapestry.ioc.Orderable;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.ioc.internal.util.UtilMessages;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DependencyNode<T> {
    private final Logger _logger;
    private final Orderable<T> _orderable;
    private final List<DependencyNode<T>> _dependencies = CollectionFactory.newList();

    DependencyNode(Logger logger, Orderable<T> orderable) {
        this._logger = logger;
        this._orderable = orderable;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(String.format("[%s", this.getId()));
        boolean first = true;
        for (DependencyNode<T> node : this._dependencies) {
            buffer.append(first ? ": " : ", ");
            buffer.append(node.toString());
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public String getId() {
        return this._orderable.getId();
    }

    void addDependency(DependencyNode<T> node) {
        if (node.isReachable(this)) {
            this._logger.warn(UtilMessages.dependencyCycle(node, this));
            return;
        }
        this._dependencies.add(node);
    }

    boolean isReachable(DependencyNode<T> node) {
        if (this == node) {
            return true;
        }
        for (DependencyNode<T> d : this._dependencies) {
            if (d != node) continue;
            return true;
        }
        for (DependencyNode<T> d : this._dependencies) {
            if (!d.isReachable(node)) continue;
            return true;
        }
        return false;
    }

    List<Orderable<T>> getOrdered() {
        List<Orderable<T>> result = CollectionFactory.newList();
        this.fillOrder(result);
        return result;
    }

    private void fillOrder(List<Orderable<T>> list) {
        if (list.contains(this._orderable)) {
            return;
        }
        for (DependencyNode<T> node : this._dependencies) {
            super.fillOrder(list);
        }
        list.add(this._orderable);
    }
}

