/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.ioc.internal.services;

import org.apache.tapestry.ioc.ObjectCreator;
import org.apache.tapestry.ioc.internal.EagerLoadServiceProxy;
import org.apache.tapestry.ioc.internal.ServiceActivityTracker;
import org.apache.tapestry.ioc.internal.services.ServiceMessages;
import org.apache.tapestry.ioc.services.RegistryShutdownListener;
import org.apache.tapestry.ioc.services.Status;

public class JustInTimeObjectCreator
implements ObjectCreator,
EagerLoadServiceProxy,
RegistryShutdownListener {
    private final ServiceActivityTracker _tracker;
    private ObjectCreator _creator;
    private boolean _shutdown;
    private Object _object;
    private final String _serviceId;

    public JustInTimeObjectCreator(ServiceActivityTracker tracker, ObjectCreator creator, String serviceId) {
        this._tracker = tracker;
        this._creator = creator;
        this._serviceId = serviceId;
    }

    public synchronized Object createObject() {
        if (this._shutdown) {
            throw new IllegalStateException(ServiceMessages.registryShutdown(this._serviceId));
        }
        if (this._object == null) {
            try {
                this._object = this._creator.createObject();
                this._tracker.setStatus(this._serviceId, Status.REAL);
                this._creator = null;
            }
            catch (RuntimeException ex) {
                throw new RuntimeException(ServiceMessages.serviceBuildFailure(this._serviceId, ex), ex);
            }
        }
        return this._object;
    }

    public void eagerLoadService() {
        this.createObject();
    }

    public synchronized void registryDidShutdown() {
        this._shutdown = true;
        this._object = null;
        this._creator = null;
    }
}

