/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.util.HashMap;
import java.util.Map;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.plastic.asm.Opcodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PrimitiveType implements Opcodes
{
    VOID("void", "V", Void.TYPE, Void.class, null, null, 21, 54, 177),
    BOOLEAN("boolean", "Z", Boolean.TYPE, Boolean.class, "booleanValue", "getBoolean", 21, 54, 172),
    CHAR("char", "C", Character.TYPE, Character.class, "charValue", "getChar", 21, 54, 172),
    BYTE("byte", "B", Byte.TYPE, Byte.class, "byteValue", "getByte", 21, 54, 172),
    SHORT("short", "S", Short.TYPE, Short.class, "shortValue", "getShort", 21, 54, 172),
    INT("int", "I", Integer.TYPE, Integer.class, "intValue", "getInt", 21, 54, 172),
    FLOAT("float", "F", Float.TYPE, Float.class, "floatValue", "getFloat", 23, 56, 174),
    LONG("long", "J", Long.TYPE, Long.class, "longValue", "getLong", 22, 55, 173),
    DOUBLE("double", "D", Double.TYPE, Double.class, "doubleValue", "getDouble", 24, 57, 175);

    public final String name;
    public final String descriptor;
    public final String wrapperInternalName;
    public final String valueOfMethodDescriptor;
    public final String toValueMethodName;
    public final String getFromStaticContextMethodName;
    public final String toValueMethodDescriptor;
    public final String getFromStaticContextMethodDescriptor;
    public final Class primitiveType;
    public final Class wrapperType;
    public final int loadOpcode;
    public final int storeOpcode;
    public final int returnOpcode;
    private static final Map<String, PrimitiveType> BY_NAME;
    private static final Map<String, PrimitiveType> BY_DESC;
    private static final Map<Class, PrimitiveType> BY_PRIMITIVE_TYPE;

    private PrimitiveType(String name, String descriptor, Class primitiveType, Class wrapperType, String toValueMethodName, String getFromStaticContextMethodName, int loadOpcode, int storeOpcode, int returnOpcode) {
        this.name = name;
        this.descriptor = descriptor;
        this.primitiveType = primitiveType;
        this.wrapperType = wrapperType;
        this.wrapperInternalName = wrapperType == null ? null : PlasticInternalUtils.toInternalName(wrapperType.getName());
        this.toValueMethodName = toValueMethodName;
        this.getFromStaticContextMethodName = getFromStaticContextMethodName;
        this.loadOpcode = loadOpcode;
        this.storeOpcode = storeOpcode;
        this.returnOpcode = returnOpcode;
        this.valueOfMethodDescriptor = String.format("(%s)L%s;", descriptor, this.wrapperInternalName);
        this.toValueMethodDescriptor = "()" + descriptor;
        this.getFromStaticContextMethodDescriptor = "(I)" + descriptor;
    }

    public boolean isWide() {
        return this == LONG || this == DOUBLE;
    }

    public static PrimitiveType getByName(String name) {
        return BY_NAME.get(name);
    }

    public static PrimitiveType getByPrimitiveType(Class primitiveType) {
        return BY_PRIMITIVE_TYPE.get(primitiveType);
    }

    static {
        BY_NAME = new HashMap<String, PrimitiveType>();
        BY_DESC = new HashMap<String, PrimitiveType>();
        BY_PRIMITIVE_TYPE = new HashMap<Class, PrimitiveType>();
        for (PrimitiveType type : PrimitiveType.values()) {
            BY_NAME.put(type.name, type);
            BY_DESC.put(type.descriptor, type);
            BY_PRIMITIVE_TYPE.put(type.primitiveType, type);
        }
    }
}

