/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.tiles;

import com.opensymphony.xwork2.util.TextParseUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELResolver;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.servlet.jsp.JspFactory;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.tiles.I18NAttributeEvaluator;
import org.apache.struts2.tiles.StrutsAttributeEvaluator;
import org.apache.struts2.tiles.StrutsFreeMarkerAttributeRenderer;
import org.apache.struts2.tiles.StrutsPreparerFactory;
import org.apache.struts2.tiles.StrutsTilesLocaleResolver;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.definition.pattern.DefinitionPatternMatcherFactory;
import org.apache.tiles.definition.pattern.PatternDefinitionResolver;
import org.apache.tiles.definition.pattern.PrefixedPatternDefinitionResolver;
import org.apache.tiles.definition.pattern.regexp.RegexpDefinitionPatternMatcherFactory;
import org.apache.tiles.definition.pattern.wildcard.WildcardDefinitionPatternMatcherFactory;
import org.apache.tiles.el.ELAttributeEvaluator;
import org.apache.tiles.el.JspExpressionFactoryFactory;
import org.apache.tiles.el.ScopeELResolver;
import org.apache.tiles.el.TilesContextBeanELResolver;
import org.apache.tiles.el.TilesContextELResolver;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.evaluator.AttributeEvaluatorFactory;
import org.apache.tiles.evaluator.BasicAttributeEvaluatorFactory;
import org.apache.tiles.evaluator.impl.DirectAttributeEvaluator;
import org.apache.tiles.factory.BasicTilesContainerFactory;
import org.apache.tiles.factory.TilesContainerFactoryException;
import org.apache.tiles.impl.mgmt.CachingTilesContainer;
import org.apache.tiles.locale.LocaleResolver;
import org.apache.tiles.ognl.AnyScopePropertyAccessor;
import org.apache.tiles.ognl.DelegatePropertyAccessor;
import org.apache.tiles.ognl.NestedObjectDelegatePropertyAccessor;
import org.apache.tiles.ognl.NestedObjectExtractor;
import org.apache.tiles.ognl.OGNLAttributeEvaluator;
import org.apache.tiles.ognl.PropertyAccessorDelegateFactory;
import org.apache.tiles.ognl.ScopePropertyAccessor;
import org.apache.tiles.ognl.TilesApplicationContextNestedObjectExtractor;
import org.apache.tiles.ognl.TilesContextPropertyAccessorDelegateFactory;
import org.apache.tiles.preparer.factory.PreparerFactory;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.ApplicationResource;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.render.BasicRendererFactory;
import org.apache.tiles.request.render.ChainedDelegateRenderer;
import org.apache.tiles.request.render.Renderer;

public class StrutsTilesContainerFactory
extends BasicTilesContainerFactory {
    private static final Logger LOG = LogManager.getLogger(StrutsTilesContainerFactory.class);
    public static final String FREEMARKER_RENDERER_NAME = "freemarker";
    public static final String PATTERN_WILDCARD = "WILDCARD";
    public static final String PATTERN_REGEXP = "REGEXP";
    public static final String TILES_DEFAULT_PATTERN = "tiles*.xml";
    public static final String OGNL = "OGNL";
    public static final String EL = "EL";
    public static final String S2 = "S2";
    public static final String I18N = "I18N";

    public TilesContainer createDecoratedContainer(TilesContainer originalContainer, ApplicationContext applicationContext) {
        return new CachingTilesContainer(originalContainer);
    }

    protected void registerAttributeRenderers(BasicRendererFactory rendererFactory, ApplicationContext applicationContext, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        super.registerAttributeRenderers(rendererFactory, applicationContext, container, attributeEvaluatorFactory);
        StrutsFreeMarkerAttributeRenderer freemarkerRenderer = new StrutsFreeMarkerAttributeRenderer();
        rendererFactory.registerRenderer(FREEMARKER_RENDERER_NAME, (Renderer)freemarkerRenderer);
    }

    protected Renderer createDefaultAttributeRenderer(BasicRendererFactory rendererFactory, ApplicationContext applicationContext, TilesContainer container, AttributeEvaluatorFactory attributeEvaluatorFactory) {
        ChainedDelegateRenderer retValue = new ChainedDelegateRenderer();
        retValue.addAttributeRenderer(rendererFactory.getRenderer("definition"));
        retValue.addAttributeRenderer(rendererFactory.getRenderer(FREEMARKER_RENDERER_NAME));
        retValue.addAttributeRenderer(rendererFactory.getRenderer("template"));
        retValue.addAttributeRenderer(rendererFactory.getRenderer("string"));
        return retValue;
    }

    protected AttributeEvaluatorFactory createAttributeEvaluatorFactory(ApplicationContext applicationContext, LocaleResolver resolver) {
        BasicAttributeEvaluatorFactory attributeEvaluatorFactory = new BasicAttributeEvaluatorFactory((AttributeEvaluator)new DirectAttributeEvaluator());
        attributeEvaluatorFactory.registerAttributeEvaluator(S2, (AttributeEvaluator)this.createStrutsEvaluator());
        attributeEvaluatorFactory.registerAttributeEvaluator(I18N, (AttributeEvaluator)this.createI18NEvaluator());
        attributeEvaluatorFactory.registerAttributeEvaluator(OGNL, (AttributeEvaluator)this.createOGNLEvaluator());
        ELAttributeEvaluator elEvaluator = this.createELEvaluator(applicationContext);
        if (elEvaluator != null) {
            attributeEvaluatorFactory.registerAttributeEvaluator(EL, (AttributeEvaluator)elEvaluator);
        }
        return attributeEvaluatorFactory;
    }

    protected <T> PatternDefinitionResolver<T> createPatternDefinitionResolver(Class<T> customizationKeyClass) {
        WildcardDefinitionPatternMatcherFactory wildcardFactory = new WildcardDefinitionPatternMatcherFactory();
        RegexpDefinitionPatternMatcherFactory regexpFactory = new RegexpDefinitionPatternMatcherFactory();
        PrefixedPatternDefinitionResolver resolver = new PrefixedPatternDefinitionResolver();
        resolver.registerDefinitionPatternMatcherFactory(PATTERN_WILDCARD, (DefinitionPatternMatcherFactory)wildcardFactory);
        resolver.registerDefinitionPatternMatcherFactory(PATTERN_REGEXP, (DefinitionPatternMatcherFactory)regexpFactory);
        return resolver;
    }

    protected LocaleResolver createLocaleResolver(ApplicationContext applicationContext) {
        return new StrutsTilesLocaleResolver();
    }

    protected List<ApplicationResource> getSources(ApplicationContext applicationContext) {
        ArrayList resources = new ArrayList();
        Set<String> definitions = this.getTilesDefinitions(applicationContext.getInitParams());
        for (String definition : definitions) {
            resources.addAll(applicationContext.getResources(definition));
        }
        if (resources.contains(null)) {
            LOG.warn("Some resources were not found. Definitions: {}. Found resources: {}", definitions, resources);
        }
        ArrayList<ApplicationResource> filteredResources = new ArrayList<ApplicationResource>();
        for (ApplicationResource resource : resources) {
            if (resource == null || !Locale.ROOT.equals(resource.getLocale())) continue;
            filteredResources.add(resource);
        }
        return filteredResources;
    }

    protected PreparerFactory createPreparerFactory(ApplicationContext applicationContext) {
        return new StrutsPreparerFactory();
    }

    protected Set<String> getTilesDefinitions(Map<String, String> params) {
        if (params.containsKey("org.apache.tiles.definition.DefinitionsFactory.DEFINITIONS_CONFIG")) {
            return TextParseUtil.commaDelimitedStringToSet((String)params.get("org.apache.tiles.definition.DefinitionsFactory.DEFINITIONS_CONFIG"));
        }
        return TextParseUtil.commaDelimitedStringToSet((String)TILES_DEFAULT_PATTERN);
    }

    protected ELAttributeEvaluator createELEvaluator(ApplicationContext applicationContext) {
        if (JspFactory.getDefaultFactory() == null) {
            LOG.warn("JspFactory.getDefaultFactory returned null, EL support will be disabled");
            return null;
        }
        ELAttributeEvaluator evaluator = new ELAttributeEvaluator();
        JspExpressionFactoryFactory efFactory = new JspExpressionFactoryFactory();
        efFactory.setApplicationContext(applicationContext);
        evaluator.setExpressionFactory(efFactory.getExpressionFactory());
        CompositeELResolver elResolver = new CompositeELResolver(){
            {
                BeanELResolver beanElResolver = new BeanELResolver(false);
                this.add((ELResolver)new ScopeELResolver());
                this.add((ELResolver)new TilesContextELResolver((ELResolver)beanElResolver));
                this.add((ELResolver)new TilesContextBeanELResolver());
                this.add((ELResolver)new ArrayELResolver(false));
                this.add((ELResolver)new ListELResolver(false));
                this.add((ELResolver)new MapELResolver(false));
                this.add((ELResolver)new ResourceBundleELResolver());
                this.add((ELResolver)beanElResolver);
            }
        };
        evaluator.setResolver((ELResolver)elResolver);
        return evaluator;
    }

    protected StrutsAttributeEvaluator createStrutsEvaluator() {
        return new StrutsAttributeEvaluator();
    }

    protected I18NAttributeEvaluator createI18NEvaluator() {
        return new I18NAttributeEvaluator();
    }

    protected OGNLAttributeEvaluator createOGNLEvaluator() {
        try {
            PropertyAccessor objectPropertyAccessor = OgnlRuntime.getPropertyAccessor(Object.class);
            NestedObjectDelegatePropertyAccessor applicationContextPropertyAccessor = new NestedObjectDelegatePropertyAccessor((NestedObjectExtractor)new TilesApplicationContextNestedObjectExtractor(), objectPropertyAccessor);
            AnyScopePropertyAccessor anyScopePropertyAccessor = new AnyScopePropertyAccessor();
            ScopePropertyAccessor scopePropertyAccessor = new ScopePropertyAccessor();
            TilesContextPropertyAccessorDelegateFactory factory = new TilesContextPropertyAccessorDelegateFactory(objectPropertyAccessor, (PropertyAccessor)applicationContextPropertyAccessor, (PropertyAccessor)anyScopePropertyAccessor, (PropertyAccessor)scopePropertyAccessor);
            DelegatePropertyAccessor tilesRequestAccessor = new DelegatePropertyAccessor((PropertyAccessorDelegateFactory)factory);
            OgnlRuntime.setPropertyAccessor(Request.class, (PropertyAccessor)tilesRequestAccessor);
            return new OGNLAttributeEvaluator();
        }
        catch (OgnlException e) {
            throw new TilesContainerFactoryException("Cannot initialize OGNL evaluator", (Throwable)e);
        }
    }
}

