/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.json;

import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.WildcardUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.JSONReader;
import org.apache.struts2.json.JSONWriter;
import org.apache.struts2.json.SerializationParams;
import org.apache.struts2.json.annotations.SMDMethod;

public class JSONUtil {
    public static final String RFC3339_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final boolean CACHE_BEAN_INFO_DEFAULT = true;
    private static final Logger LOG = LogManager.getLogger(JSONUtil.class);
    public static final String REGEXP_PATTERN = "regexp";
    public static final String WILDCARD_PATTERN = "wildcard";
    static final String SPLIT_PATTERN = "split";
    static final String JOIN_STRING = "join";
    static final String ARRAY_BEGIN_STRING = "array-begin";
    static final String ARRAY_END_STRING = "array-end";
    private static final Map<String, Map<String, String>> defaultIncludePatternData = JSONUtil.getIncludePatternData();

    public static String serialize(Object object, boolean cacheBeanInfo) throws JSONException {
        JSONWriter writer = new JSONWriter();
        writer.setCacheBeanInfo(cacheBeanInfo);
        return writer.write(object);
    }

    public static String serialize(Object object, Collection<Pattern> excludeProperties, Collection<Pattern> includeProperties, boolean ignoreHierarchy, boolean excludeNullProperties) throws JSONException {
        return JSONUtil.serialize(object, excludeProperties, includeProperties, ignoreHierarchy, excludeNullProperties, true);
    }

    public static String serialize(Object object, Collection<Pattern> excludeProperties, Collection<Pattern> includeProperties, boolean ignoreHierarchy, boolean excludeNullProperties, boolean cacheBeanInfo) throws JSONException {
        JSONWriter writer = new JSONWriter();
        writer.setIgnoreHierarchy(ignoreHierarchy);
        writer.setCacheBeanInfo(cacheBeanInfo);
        return writer.write(object, excludeProperties, includeProperties, excludeNullProperties);
    }

    public static String serialize(Object object, Collection<Pattern> excludeProperties, Collection<Pattern> includeProperties, boolean ignoreHierarchy, boolean enumAsBean, boolean excludeNullProperties, String defaultDateFormat) throws JSONException {
        return JSONUtil.serialize(object, excludeProperties, includeProperties, ignoreHierarchy, enumAsBean, excludeNullProperties, defaultDateFormat, true);
    }

    public static String serialize(Object object, Collection<Pattern> excludeProperties, Collection<Pattern> includeProperties, boolean ignoreHierarchy, boolean enumAsBean, boolean excludeNullProperties, String defaultDateFormat, boolean cacheBeanInfo) throws JSONException {
        JSONWriter writer = new JSONWriter();
        writer.setIgnoreHierarchy(ignoreHierarchy);
        writer.setEnumAsBean(enumAsBean);
        writer.setDateFormatter(defaultDateFormat);
        writer.setCacheBeanInfo(cacheBeanInfo);
        return writer.write(object, excludeProperties, includeProperties, excludeNullProperties);
    }

    public static void serialize(Writer writer, Object object) throws IOException, JSONException {
        JSONUtil.serialize(writer, object, true);
    }

    public static void serialize(Writer writer, Object object, boolean cacheBeanInfo) throws IOException, JSONException {
        writer.write(JSONUtil.serialize(object, cacheBeanInfo));
    }

    public static void serialize(Writer writer, Object object, Collection<Pattern> excludeProperties, Collection<Pattern> includeProperties, boolean excludeNullProperties) throws IOException, JSONException {
        JSONUtil.serialize(writer, object, excludeProperties, includeProperties, excludeNullProperties, true);
    }

    public static void serialize(Writer writer, Object object, Collection<Pattern> excludeProperties, Collection<Pattern> includeProperties, boolean excludeNullProperties, boolean cacheBeanInfo) throws IOException, JSONException {
        writer.write(JSONUtil.serialize(object, excludeProperties, includeProperties, true, excludeNullProperties, cacheBeanInfo));
    }

    public static Object deserialize(String json) throws JSONException {
        JSONReader reader = new JSONReader();
        return reader.read(json);
    }

    public static Object deserialize(Reader reader) throws JSONException {
        BufferedReader bufferReader = new BufferedReader(reader);
        StringBuilder buffer = new StringBuilder();
        try {
            String line;
            while ((line = bufferReader.readLine()) != null) {
                buffer.append(line);
            }
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        return JSONUtil.deserialize(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJSONToResponse(SerializationParams serializationParams) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)serializationParams.getSerializedJSON())) {
            stringBuilder.append(serializationParams.getSerializedJSON());
        }
        if (StringUtils.isNotBlank((CharSequence)serializationParams.getWrapPrefix())) {
            stringBuilder.insert(0, serializationParams.getWrapPrefix());
        } else if (serializationParams.isWrapWithComments()) {
            stringBuilder.insert(0, "/* ");
            stringBuilder.append(" */");
        } else if (serializationParams.isPrefix()) {
            stringBuilder.insert(0, "{}&& ");
        }
        if (StringUtils.isNotBlank((CharSequence)serializationParams.getWrapSuffix())) {
            stringBuilder.append(serializationParams.getWrapSuffix());
        }
        String json = stringBuilder.toString();
        LOG.debug("[JSON] {}", (Object)json);
        HttpServletResponse response = serializationParams.getResponse();
        if (serializationParams.getStatusCode() > 0) {
            response.setStatus(serializationParams.getStatusCode());
        } else if (serializationParams.getErrorCode() > 0) {
            response.sendError(serializationParams.getErrorCode());
        }
        response.setContentType(serializationParams.getContentType() + ";charset=" + serializationParams.getEncoding());
        if (serializationParams.isNoCache()) {
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Expires", "0");
            response.setHeader("Pragma", "No-cache");
        }
        if (serializationParams.isGzip()) {
            response.addHeader("Content-Encoding", "gzip");
            GZIPOutputStream out = null;
            InputStream in = null;
            try {
                int len;
                out = new GZIPOutputStream((OutputStream)response.getOutputStream());
                in = new ByteArrayInputStream(json.getBytes(serializationParams.getEncoding()));
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.finish();
                    out.close();
                }
            }
        } else {
            response.setContentLength(json.getBytes(serializationParams.getEncoding()).length);
            PrintWriter out = response.getWriter();
            out.print(json);
        }
    }

    public static Set<String> asSet(String commaDelim) {
        if (commaDelim == null || commaDelim.trim().length() == 0) {
            return null;
        }
        return TextParseUtil.commaDelimitedStringToSet((String)commaDelim);
    }

    public static Method[] listSMDMethods(Class clazz, boolean ignoreInterfaces) {
        final LinkedList<Method> methods = new LinkedList<Method>();
        if (ignoreInterfaces) {
            for (Method method : clazz.getMethods()) {
                SMDMethod smdMethodAnnotation = method.getAnnotation(SMDMethod.class);
                if (smdMethodAnnotation == null) continue;
                methods.add(method);
            }
        } else {
            JSONUtil.visitInterfaces(clazz, new ClassVisitor(){

                @Override
                public boolean visit(Class aClass) {
                    for (Method method : aClass.getMethods()) {
                        SMDMethod smdMethodAnnotation = method.getAnnotation(SMDMethod.class);
                        if (smdMethodAnnotation == null || methods.contains(method)) continue;
                        methods.add(method);
                    }
                    return true;
                }
            });
        }
        Method[] methodResult = new Method[methods.size()];
        return methods.toArray(methodResult);
    }

    public static boolean visitInterfaces(Class aClass, ClassVisitor visitor) {
        LinkedList<Class> classesVisited = new LinkedList<Class>();
        return JSONUtil.visitUniqueInterfaces(aClass, visitor, classesVisited);
    }

    private static boolean visitUniqueInterfaces(Class thisClass, ClassVisitor visitor, List<Class> classesVisited) {
        boolean okayToContinue = true;
        if (!classesVisited.contains(thisClass)) {
            classesVisited.add(thisClass);
            okayToContinue = visitor.visit(thisClass);
            if (okayToContinue) {
                Class superClass;
                Class<?>[] interfaces = thisClass.getInterfaces();
                int index = 0;
                while (index < interfaces.length && okayToContinue) {
                    okayToContinue = JSONUtil.visitUniqueInterfaces(interfaces[index++], visitor, classesVisited);
                }
                if (okayToContinue && (superClass = thisClass.getSuperclass()) != null && !Object.class.equals(superClass)) {
                    okayToContinue = JSONUtil.visitUniqueInterfaces(superClass, visitor, classesVisited);
                }
            }
        }
        return okayToContinue;
    }

    public static boolean isGzipInRequest(HttpServletRequest request) {
        return StringUtils.contains((CharSequence)request.getHeader("Accept-Encoding"), (CharSequence)"gzip");
    }

    static Map<String, Map<String, String>> getIncludePatternData() {
        HashMap<String, Map<String, String>> includePatternData = new HashMap<String, Map<String, String>>();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(REGEXP_PATTERN, "\\\\\\.");
        data.put(WILDCARD_PATTERN, "\\.");
        includePatternData.put(SPLIT_PATTERN, data);
        data = new HashMap();
        data.put(REGEXP_PATTERN, "\\.");
        data.put(WILDCARD_PATTERN, ".");
        includePatternData.put(JOIN_STRING, data);
        data = new HashMap();
        data.put(REGEXP_PATTERN, "\\[");
        data.put(WILDCARD_PATTERN, "[");
        includePatternData.put(ARRAY_BEGIN_STRING, data);
        data = new HashMap();
        data.put(REGEXP_PATTERN, "\\]");
        data.put(WILDCARD_PATTERN, "]");
        includePatternData.put(ARRAY_END_STRING, data);
        return includePatternData;
    }

    public static List<Pattern> processIncludePatterns(Set<String> includePatterns, String type) {
        return JSONUtil.processIncludePatterns(includePatterns, type, defaultIncludePatternData);
    }

    static List<Pattern> processIncludePatterns(Set<String> includePatterns, String type, Map<String, Map<String, String>> includePatternData) {
        if (includePatterns != null) {
            ArrayList<Pattern> results = new ArrayList<Pattern>(includePatterns.size());
            HashMap<String, String> existingPatterns = new HashMap<String, String>();
            for (String pattern : includePatterns) {
                JSONUtil.processPattern(results, existingPatterns, pattern, type, includePatternData);
            }
            return results;
        }
        return null;
    }

    private static void processPattern(List<Pattern> results, Map<String, String> existingPatterns, String pattern, String type, Map<String, Map<String, String>> includePatternData) {
        String[] patternPieces = pattern.split(includePatternData.get(SPLIT_PATTERN).get(type));
        String patternExpr = "";
        for (String patternPiece : patternPieces) {
            patternExpr = JSONUtil.processPatternPiece(results, existingPatterns, patternExpr, patternPiece, type, includePatternData);
        }
    }

    private static String processPatternPiece(List<Pattern> results, Map<String, String> existingPatterns, String patternExpr, String patternPiece, String type, Map<String, Map<String, String>> includePatternData) {
        if (patternExpr.length() > 0) {
            patternExpr = patternExpr + includePatternData.get(JOIN_STRING).get(type);
        }
        if (!existingPatterns.containsKey(patternExpr = patternExpr + patternPiece)) {
            existingPatterns.put(patternExpr, patternExpr);
            if (JSONUtil.isIndexedProperty(patternPiece, type, includePatternData)) {
                JSONUtil.addPattern(results, patternExpr.substring(0, patternExpr.lastIndexOf(includePatternData.get(ARRAY_BEGIN_STRING).get(type))), type);
            }
            JSONUtil.addPattern(results, patternExpr, type);
        }
        return patternExpr;
    }

    private static boolean isIndexedProperty(String patternPiece, String type, Map<String, Map<String, String>> includePatternData) {
        return patternPiece.endsWith(includePatternData.get(ARRAY_END_STRING).get(type));
    }

    private static void addPattern(List<Pattern> results, String pattern, String type) {
        results.add(REGEXP_PATTERN.equals(type) ? Pattern.compile(pattern) : WildcardUtil.compileWildcardPattern((String)pattern));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Adding include {} expression: {}", (Object)(REGEXP_PATTERN.equals(type) ? "property" : WILDCARD_PATTERN), (Object)pattern);
        }
    }

    public static interface ClassVisitor {
        public boolean visit(Class var1);
    }
}

